/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.search.api.client.query.impl;

import java.io.Serializable;
import java.security.Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.search.api.client.query.SearchPrincipal;

public class SearchPrincipalImpl
implements SearchPrincipal {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(SearchPrincipalImpl.class);
    protected String name;
    protected String[] groups;
    protected boolean systemUser = false;
    protected boolean isAdministrator = false;
    protected Serializable originalPrincipal;

    public SearchPrincipalImpl() {
    }

    public SearchPrincipalImpl(String name) {
        this(name, null, false, false);
    }

    @Deprecated
    public SearchPrincipalImpl(String name, String[] groups, boolean isSystemUser) {
        this(name, groups, isSystemUser, false);
    }

    public SearchPrincipalImpl(String name, String[] groups, boolean isSystemUser, boolean isAdministrator) {
        this.name = name;
        this.groups = groups;
        this.systemUser = isSystemUser;
        this.isAdministrator = isAdministrator;
    }

    @Deprecated
    public SearchPrincipalImpl(String name, String[] groups, boolean isSystemUser, Principal originalPrincipal) {
        this(name, groups, isSystemUser, false, null);
    }

    public SearchPrincipalImpl(String name, String[] groups, boolean isSystemUser, boolean isAdministrator, Principal originalPrincipal) {
        this(name, groups, isSystemUser, isAdministrator);
        if (originalPrincipal != null) {
            if (originalPrincipal instanceof Serializable) {
                this.originalPrincipal = (Serializable)((Object)originalPrincipal);
            } else {
                log.warn((Object)("Principal with name= " + originalPrincipal.getName() + " is not serializble. Cannot store it on SearchPrincipal..."));
            }
        }
    }

    @Override
    public String[] getGroups() {
        if (this.groups == null) {
            this.groups = new String[0];
        }
        return this.groups;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isSystemUser() {
        return this.systemUser;
    }

    @Override
    public Serializable getOriginalPrincipal() {
        return this.originalPrincipal;
    }

    @Override
    public boolean isAdministrator() {
        return this.isAdministrator;
    }
}

