/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.managed.plugins.factory;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.config.spi.Configuration;
import org.jboss.logging.Logger;
import org.jboss.managed.api.Fields;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.managed.api.ManagedParameter;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.MutableManagedObject;
import org.jboss.managed.api.annotation.ActivationPolicy;
import org.jboss.managed.api.annotation.ConstraintsPopulatorFactory;
import org.jboss.managed.api.annotation.DefaultValueBuilderFactory;
import org.jboss.managed.api.annotation.FieldsFactory;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementDeployment;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementObjectID;
import org.jboss.managed.api.annotation.ManagementObjectRef;
import org.jboss.managed.api.annotation.ManagementOperation;
import org.jboss.managed.api.annotation.ManagementParameter;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.managed.api.annotation.ManagementPropertyFactory;
import org.jboss.managed.api.annotation.ManagementRuntimeRef;
import org.jboss.managed.api.annotation.Masked;
import org.jboss.managed.api.annotation.RunStateProperty;
import org.jboss.managed.api.annotation.ViewUse;
import org.jboss.managed.api.factory.ManagedObjectDefinition;
import org.jboss.managed.api.factory.ManagedObjectFactory;
import org.jboss.managed.plugins.DefaultFieldsImpl;
import org.jboss.managed.plugins.ManagedObjectImpl;
import org.jboss.managed.plugins.ManagedOperationImpl;
import org.jboss.managed.plugins.ManagedParameterImpl;
import org.jboss.managed.plugins.WritethroughManagedPropertyImpl;
import org.jboss.managed.plugins.factory.AbstractManagedObjectPopulator;
import org.jboss.managed.plugins.factory.DefaultInstanceClassFactory;
import org.jboss.managed.plugins.factory.PropertyConfigurationAccess;
import org.jboss.managed.plugins.factory.Utility;
import org.jboss.managed.spi.factory.InstanceClassFactory;
import org.jboss.managed.spi.factory.ManagedObjectBuilder;
import org.jboss.managed.spi.factory.ManagedObjectPopulator;
import org.jboss.managed.spi.factory.ManagedParameterConstraintsPopulator;
import org.jboss.managed.spi.factory.ManagedParameterConstraintsPopulatorFactory;
import org.jboss.managed.spi.factory.ManagedPropertyConstraintsPopulator;
import org.jboss.managed.spi.factory.ManagedPropertyConstraintsPopulatorFactory;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.signature.FieldSignature;
import org.jboss.metadata.spi.signature.MethodSignature;
import org.jboss.metadata.spi.signature.Signature;
import org.jboss.metatype.api.annotations.MetaMapping;
import org.jboss.metatype.api.annotations.MetaMappingFactory;
import org.jboss.metatype.api.types.ArrayMetaType;
import org.jboss.metatype.api.types.CollectionMetaType;
import org.jboss.metatype.api.types.GenericMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.MetaTypeFactory;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.MetaValueFactory;
import org.jboss.metatype.plugins.values.defaults.BigDecimalDefaultValueBuilder;
import org.jboss.metatype.plugins.values.defaults.BigIntegerDefaultValueBuilder;
import org.jboss.metatype.plugins.values.defaults.BooleanDefaultValueBuilder;
import org.jboss.metatype.plugins.values.defaults.BooleanPrimitiveDefaultValueBuilder;
import org.jboss.metatype.plugins.values.defaults.ByteDefaultValueBuilder;
import org.jboss.metatype.plugins.values.defaults.BytePrimitiveDefaultValueBuilder;
import org.jboss.metatype.plugins.values.defaults.CharDefaultValueBuilder;
import org.jboss.metatype.plugins.values.defaults.CharPrimitiveDefaultValueBuilder;
import org.jboss.metatype.plugins.values.defaults.DoubleDefaultValueBuilder;
import org.jboss.metatype.plugins.values.defaults.DoublePrimitiveDefaultValueBuilder;
import org.jboss.metatype.plugins.values.defaults.FloatDefaultValueBuilder;
import org.jboss.metatype.plugins.values.defaults.FloatPrimitiveDefaultValueBuilder;
import org.jboss.metatype.plugins.values.defaults.IntDefaultValueBuilder;
import org.jboss.metatype.plugins.values.defaults.IntPrimitiveDefaultValueBuilder;
import org.jboss.metatype.plugins.values.defaults.LongDefaultValueBuilder;
import org.jboss.metatype.plugins.values.defaults.LongPrimitiveDefaultValueBuilder;
import org.jboss.metatype.plugins.values.defaults.PropertiesDefaultValueBuilder;
import org.jboss.metatype.plugins.values.defaults.ShortDefaultValueBuilder;
import org.jboss.metatype.plugins.values.defaults.ShortPrimitiveDefaultValueBuilder;
import org.jboss.metatype.plugins.values.defaults.StringDefaultValueBuilder;
import org.jboss.metatype.spi.values.DefaultValueBuilder;
import org.jboss.metatype.spi.values.MetaMapper;
import org.jboss.metatype.spi.values.MetaMapperFactory;
import org.jboss.reflect.spi.AnnotatedInfo;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.MemberInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.ParameterInfo;
import org.jboss.reflect.spi.TypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractManagedObjectFactory
extends ManagedObjectFactory
implements ManagedObjectBuilder {
    private static final Logger log = Logger.getLogger(AbstractManagedObjectFactory.class);
    private static final Configuration configuration = PropertyConfigurationAccess.getConfiguration();
    public static final GenericMetaType MANAGED_OBJECT_META_TYPE = new GenericMetaType(ManagedObject.class.getName(), ManagedObject.class.getName());
    private MetaTypeFactory metaTypeFactory = MetaTypeFactory.getInstance();
    private MetaValueFactory metaValueFactory = MetaValueFactory.getInstance();
    private InstanceClassFactory<?> defaultInstanceFactory;
    private ManagedObjectPopulator<?> defaultManagedObjectPopulator;
    private Map<Class<?>, ManagedObjectBuilder> builders = new WeakHashMap();
    private Map<Class<?>, InstanceClassFactory<?>> instanceFactories = new WeakHashMap();
    private Map<MetaType, DefaultValueBuilder> defaultBuilders = new HashMap<MetaType, DefaultValueBuilder>();

    public static ManagedProperty createManagedProperty(Class<? extends ManagedProperty> factory, Fields fields) {
        ManagedProperty property = null;
        try {
            Class[] sig = new Class[]{Fields.class};
            Constructor<? extends ManagedProperty> ctor = factory.getConstructor(sig);
            Object[] args = new Object[]{fields};
            property = ctor.newInstance(args);
        }
        catch (Exception e) {
            log.debug((Object)"Failed to create ManagedProperty", (Throwable)e);
        }
        return property;
    }

    public AbstractManagedObjectFactory() {
        DefaultInstanceClassFactory icf = new DefaultInstanceClassFactory();
        icf.setMof(this);
        this.defaultInstanceFactory = icf;
        this.defaultManagedObjectPopulator = new AbstractManagedObjectPopulator(configuration, icf, this.instanceFactories);
        this.initDefaultValueBuilders();
    }

    public AbstractManagedObjectFactory(MetaTypeFactory metaTypeFactory, MetaValueFactory metaValueFactory, InstanceClassFactory<?> defaultInstanceFactory, ManagedObjectPopulator<?> defaultManagedObjectPopulator, Map<Class<?>, ManagedObjectBuilder> builders, Map<Class<?>, InstanceClassFactory<?>> instanceFactories) {
        this.metaTypeFactory = metaTypeFactory;
        this.metaValueFactory = metaValueFactory;
        this.defaultInstanceFactory = defaultInstanceFactory;
        this.defaultManagedObjectPopulator = defaultManagedObjectPopulator;
        this.builders = builders;
        this.instanceFactories = instanceFactories;
        this.initDefaultValueBuilders();
    }

    public void addManagedObjectDefinition(ManagedObjectDefinition definition) {
        if (definition == null || !definition.isValid()) {
            throw new IllegalArgumentException("Invalid MO definition: " + (Object)((Object)definition));
        }
        this.setBuilder(definition.getType(), definition.getBuilder());
    }

    public void removeManagedObjectDefinition(ManagedObjectDefinition definition) {
        if (definition == null) {
            return;
        }
        this.setBuilder(definition.getType(), null);
    }

    public void addDefaultValueBuilder(DefaultValueBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Null DefaultValueBuilder");
        }
        this.setDefaultsBuilder(builder.getType(), builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultsBuilder(MetaType type, DefaultValueBuilder builder) {
        Map<MetaType, DefaultValueBuilder> map = this.defaultBuilders;
        synchronized (map) {
            if (builder == null) {
                this.defaultBuilders.remove(type);
            } else {
                this.defaultBuilders.put(type, builder);
            }
        }
    }

    public void removeDefaltValueBuilder(DefaultValueBuilder builder) {
        if (builder == null) {
            return;
        }
        this.setDefaultsBuilder(builder.getType(), null);
    }

    public Configuration getConfiguration() {
        return configuration;
    }

    public MetaTypeFactory getMetaTypeFactory() {
        return this.metaTypeFactory;
    }

    public void setMetaTypeFactory(MetaTypeFactory metaTypeFactory) {
        this.metaTypeFactory = metaTypeFactory;
    }

    public MetaValueFactory getMetaValueFactory() {
        return this.metaValueFactory;
    }

    public void setMetaValueFactory(MetaValueFactory metaValueFactory) {
        this.metaValueFactory = metaValueFactory;
    }

    public Map<Class<?>, ManagedObjectBuilder> getBuilders() {
        return this.builders;
    }

    public void setBuilders(Map<Class<?>, ManagedObjectBuilder> builders) {
        this.builders = builders;
    }

    public Map<Class<?>, InstanceClassFactory<?>> getInstanceFactories() {
        return this.instanceFactories;
    }

    public void setInstanceFactories(Map<Class<?>, InstanceClassFactory<?>> instanceFactories) {
        this.instanceFactories = instanceFactories;
    }

    public InstanceClassFactory<?> getDefaultInstanceFactory() {
        return this.defaultInstanceFactory;
    }

    public void setDefaultInstanceFactory(InstanceClassFactory<? extends Serializable> defaultInstanceFactory) {
        this.defaultInstanceFactory = defaultInstanceFactory;
    }

    public ManagedObjectPopulator<?> getDefaultManagedObjectPopulator() {
        return this.defaultManagedObjectPopulator;
    }

    public void setDefaultManagedObjectPopulator(ManagedObjectPopulator<? extends Serializable> defaultManagedObjectPopulator) {
        this.defaultManagedObjectPopulator = defaultManagedObjectPopulator;
    }

    @Override
    public <T> ManagedObject createManagedObject(Class<T> clazz, MetaData metaData) {
        if (clazz == null) {
            throw new IllegalArgumentException("Null class");
        }
        ManagedObject result = this.createSkeletonManagedObject(clazz, metaData);
        ManagedObjectPopulator<T> populator = this.getPopulator(clazz);
        populator.createObject(result, clazz, metaData);
        return result;
    }

    @Override
    public ManagedObject initManagedObject(Object instance, Class<?> instanceType, MetaData metaData, String name, String nameType) {
        Class<?> moClass;
        if (instance == null) {
            throw new IllegalArgumentException("instance cannot be null");
        }
        Class<?> clazz = instance.getClass();
        InstanceClassFactory<?> icf = this.defaultInstanceFactory;
        if (instanceType != null && instanceType != clazz) {
            icf = this.getInstanceClassFactory((Class)instanceType, metaData);
        }
        if (icf == this.defaultInstanceFactory) {
            icf = this.getInstanceClassFactory((Class)clazz, metaData);
        }
        try {
            moClass = icf.getManagedObjectClass(instance);
        }
        catch (ClassNotFoundException e) {
            log.debug((Object)"Failed to load class for ManagedObject", (Throwable)e);
            return null;
        }
        if (moClass == null) {
            log.debug((Object)("ICF returned null class: " + instance));
            return null;
        }
        ManagedObject result = this.createSkeletonManagedObject(moClass, metaData);
        if (result == null) {
            log.debug((Object)("Null ManagedObject created for: " + moClass));
            return null;
        }
        log.debug((Object)("Created skeleton ManagedObject: " + result));
        if (result instanceof MutableManagedObject) {
            MutableManagedObject mmo = (MutableManagedObject)result;
            ManagedObjectPopulator<?> populator = this.getPopulator(moClass);
            populator.populateManagedObject(mmo, instance, metaData);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBuilder(Class<?> clazz, ManagedObjectBuilder builder) {
        Map<Class<?>, ManagedObjectBuilder> map = this.builders;
        synchronized (map) {
            if (builder == null) {
                this.builders.remove(clazz);
            } else {
                this.builders.put(clazz, builder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void setInstanceClassFactory(Class<T> clazz, InstanceClassFactory<T> factory) {
        Map<Class<?>, InstanceClassFactory<?>> map = this.instanceFactories;
        synchronized (map) {
            if (factory == null) {
                this.instanceFactories.remove(clazz);
                log.debug((Object)("Removed ICF for: " + clazz));
            } else {
                this.instanceFactories.put(clazz, factory);
                log.debug((Object)("Set ICF for: " + clazz + ", to: " + factory));
            }
        }
    }

    protected <T> ManagedObject createSkeletonManagedObject(Class<T> clazz, MetaData metaData) {
        if (clazz == null) {
            throw new IllegalArgumentException("Null class");
        }
        ManagedObjectBuilder builder = this.getBuilder(clazz);
        return builder.buildManagedObject(clazz, metaData);
    }

    @Override
    public ManagedObject buildManagedObject(Class<?> clazz, MetaData metaData) {
        ManagementObjectID moID;
        boolean trace = log.isTraceEnabled();
        BeanInfo beanInfo = configuration.getBeanInfo(clazz);
        ClassInfo classInfo = beanInfo.getClassInfo();
        ManagementObject managementObject = this.getAnnotation(ManagementObject.class, (AnnotatedInfo)classInfo, metaData);
        if (managementObject == null) {
            if (trace) {
                log.trace((Object)("No ManagementObject annotation, skipping ManagedObject for class: " + clazz));
            }
            return null;
        }
        Class<?> targetInterface = managementObject.targetInterface();
        if (targetInterface != Object.class) {
            beanInfo = this.getBeanInfo(targetInterface);
            classInfo = beanInfo.getClassInfo();
        }
        HashMap<String, Annotation> moAnnotations = new HashMap<String, Annotation>();
        moAnnotations.put(ManagementObject.class.getName(), managementObject);
        ManagementDeployment mnagementDeployment = this.getAnnotation(ManagementDeployment.class, (AnnotatedInfo)classInfo, metaData);
        if (mnagementDeployment != null) {
            moAnnotations.put(ManagementDeployment.class.getName(), mnagementDeployment);
        }
        if ((moID = this.getAnnotation(ManagementObjectID.class, (AnnotatedInfo)classInfo, metaData)) != null) {
            moAnnotations.put(ManagementObjectID.class.getName(), moID);
        }
        boolean isRuntime = managementObject.isRuntime();
        String name = classInfo.getName();
        String nameType = null;
        String attachmentName = classInfo.getName();
        Class<? extends Fields> moFieldsFactory = null;
        ConstraintsPopulatorFactory moCPF = null;
        Class<? extends ManagedPropertyConstraintsPopulatorFactory> moConstraintsFactory = null;
        Class<? extends ManagedProperty> moPropertyFactory = null;
        if (managementObject != null) {
            ManagementPropertyFactory mpf;
            FieldsFactory ff;
            name = managementObject.name();
            if (name.length() == 0 || name.equals("%Generated%")) {
                name = classInfo.getName();
            }
            if ((nameType = managementObject.type()).length() == 0) {
                nameType = null;
            }
            if ((attachmentName = managementObject.attachmentName()).length() == 0) {
                attachmentName = classInfo.getName();
            }
            ManagementComponent mc = null;
            if (metaData != null) {
                mc = (ManagementComponent)metaData.getAnnotation(ManagementComponent.class);
            }
            if (mc == null) {
                mc = managementObject.componentType();
            }
            if (mc.type().length() > 0 || mc.subtype().length() > 0) {
                log.debug((Object)("ManagedObject(" + name + ") is ManagedComponent type: " + mc));
                moAnnotations.put(ManagementComponent.class.getName(), mc);
            }
            if ((ff = this.getAnnotation(FieldsFactory.class, (AnnotatedInfo)classInfo, metaData)) != null) {
                moFieldsFactory = ff.value();
            }
            if ((moCPF = this.getAnnotation(ConstraintsPopulatorFactory.class, (AnnotatedInfo)classInfo, metaData)) != null) {
                moConstraintsFactory = moCPF.value();
            }
            if ((mpf = this.getAnnotation(ManagementPropertyFactory.class, (AnnotatedInfo)classInfo, metaData)) != null) {
                moPropertyFactory = mpf.value();
            }
        }
        if (trace) {
            log.trace((Object)("Building MangedObject(name=" + name + ",nameType=" + nameType + ",attachmentName=" + attachmentName + ",isRuntime=" + isRuntime + ")"));
        }
        ManagementProperties propertyType = ManagementProperties.ALL;
        HashSet<String> classProperties = null;
        if (managementObject != null && ((propertyType = managementObject.properties()) == ManagementProperties.CLASS || propertyType == ManagementProperties.CLASS_AND_EXPLICIT)) {
            classProperties = new HashSet<String>();
            for (ManagementProperty mp : managementObject.classProperties()) {
                if (mp.name().length() > 0) {
                    classProperties.add(mp.name());
                }
                if (mp.mappedName().length() <= 0) continue;
                classProperties.add(mp.mappedName());
            }
        }
        HashSet<ManagedProperty> properties = new HashSet<ManagedProperty>();
        Set propertyInfos = beanInfo.getProperties();
        if (propertyInfos != null && !propertyInfos.isEmpty()) {
            for (PropertyInfo propertyInfo : propertyInfos) {
                if ("class".equals(propertyInfo.getName())) continue;
                ManagementProperty managementProperty = this.getAnnotation(ManagementProperty.class, (AnnotatedInfo)propertyInfo, metaData);
                ManagementObjectID id = this.getAnnotation(ManagementObjectID.class, (AnnotatedInfo)propertyInfo, metaData);
                ManagementObjectRef ref = this.getAnnotation(ManagementObjectRef.class, (AnnotatedInfo)propertyInfo, metaData);
                ManagementRuntimeRef runtimeRef = this.getAnnotation(ManagementRuntimeRef.class, (AnnotatedInfo)propertyInfo, metaData);
                RunStateProperty rsp = this.getAnnotation(RunStateProperty.class, (AnnotatedInfo)propertyInfo, metaData);
                Masked masked = this.getAnnotation(Masked.class, (AnnotatedInfo)propertyInfo, metaData);
                DefaultValueBuilderFactory defaultsFactory = this.getAnnotation(DefaultValueBuilderFactory.class, (AnnotatedInfo)propertyInfo, metaData);
                HashMap<String, Annotation> propAnnotations = new HashMap<String, Annotation>();
                if (managementProperty != null) {
                    propAnnotations.put(ManagementProperty.class.getName(), managementProperty);
                }
                if (id != null) {
                    propAnnotations.put(ManagementObjectID.class.getName(), id);
                    nameType = id.type();
                }
                if (ref != null) {
                    propAnnotations.put(ManagementObjectRef.class.getName(), ref);
                }
                if (runtimeRef != null) {
                    propAnnotations.put(ManagementRuntimeRef.class.getName(), runtimeRef);
                }
                if (rsp != null) {
                    propAnnotations.put(RunStateProperty.class.getName(), rsp);
                }
                if (masked != null) {
                    propAnnotations.put(Masked.class.getName(), masked);
                }
                boolean includeProperty = false;
                switch (propertyType) {
                    case EXPLICIT: {
                        includeProperty = managementProperty != null && !managementProperty.ignored();
                        break;
                    }
                    case CLASS: {
                        includeProperty = classProperties.contains(propertyInfo.getName());
                        break;
                    }
                    case CLASS_AND_EXPLICIT: {
                        includeProperty = classProperties.contains(propertyInfo.getName()) || managementProperty != null && !managementProperty.ignored();
                        break;
                    }
                    case ALL: {
                        boolean bl = includeProperty = managementProperty == null || !managementProperty.ignored();
                    }
                }
                if (includeProperty) {
                    String defaultValue;
                    boolean readOnly;
                    Fields fields = null;
                    Class<? extends Fields> factory = moFieldsFactory;
                    FieldsFactory ff = this.getAnnotation(FieldsFactory.class, (AnnotatedInfo)propertyInfo, metaData);
                    if (ff != null) {
                        factory = ff.value();
                    }
                    if (factory != null) {
                        try {
                            fields = factory.newInstance();
                        }
                        catch (Exception e) {
                            log.debug((Object)"Failed to created Fields", (Throwable)e);
                        }
                    }
                    if (fields == null) {
                        fields = new DefaultFieldsImpl();
                    }
                    if (propertyInfo instanceof Serializable) {
                        Serializable info = (Serializable)Serializable.class.cast(propertyInfo);
                        fields.setField("propertyInfo", info);
                    }
                    String propertyName = propertyInfo.getName();
                    if (managementProperty != null) {
                        propertyName = managementProperty.name();
                    }
                    if (propertyName.length() == 0) {
                        propertyName = propertyInfo.getName();
                    }
                    fields.setField("name", propertyName);
                    String mappedName = propertyInfo.getName();
                    if (managementProperty != null) {
                        mappedName = managementProperty.mappedName();
                    }
                    if (mappedName.length() == 0) {
                        mappedName = propertyInfo.getName();
                    }
                    fields.setField("mappedName", mappedName);
                    String description = "%Generated%";
                    if (managementProperty != null) {
                        description = managementProperty.description();
                    }
                    if (description.equals("%Generated%")) {
                        description = propertyName;
                    }
                    fields.setField("description", description);
                    if (trace) {
                        log.trace((Object)("Building MangedProperty(name=" + propertyName + ",mappedName=" + mappedName + ") ,annotations=" + propAnnotations));
                    }
                    boolean mandatory = false;
                    if (managementProperty != null) {
                        mandatory = managementProperty.mandatory();
                    }
                    if (mandatory) {
                        fields.setField("mandatory", Boolean.TRUE);
                    }
                    boolean bl = readOnly = !propertyInfo.isWritable();
                    if (!readOnly && managementProperty != null) {
                        readOnly = managementProperty.readOnly();
                    }
                    if (readOnly) {
                        fields.setField("readOnly", Boolean.TRUE);
                    }
                    boolean managed = false;
                    if (managementProperty != null) {
                        managed = managementProperty.managed();
                    }
                    if (managementProperty != null) {
                        ViewUse[] use = managementProperty.use();
                        fields.setField("viewUse", use);
                    }
                    ActivationPolicy apolicy = ActivationPolicy.IMMEDIATE;
                    if (managementProperty != null) {
                        apolicy = managementProperty.activationPolicy();
                    }
                    fields.setField("activationPolicy", (Object)apolicy);
                    MetaMapper[] mapperReturn = new MetaMapper[]{null};
                    Object metaType = this.getMetaType((AnnotatedInfo)propertyInfo, propertyInfo.getType(), metaData, false, mapperReturn);
                    if (metaType == null) {
                        TypeInfo typeInfo;
                        metaType = managed ? ((typeInfo = propertyInfo.getType()).isArray() ? new ArrayMetaType(1, (MetaType)MANAGED_OBJECT_META_TYPE) : (typeInfo.isCollection() ? new CollectionMetaType(typeInfo.getName(), (MetaType)MANAGED_OBJECT_META_TYPE) : MANAGED_OBJECT_META_TYPE)) : this.metaTypeFactory.resolve(propertyInfo.getType());
                    }
                    fields.setField("metaType", metaType);
                    if (managementProperty != null && (defaultValue = managementProperty.defaultValue()).length() > 0) {
                        try {
                            DefaultValueBuilder builder = null;
                            if (defaultsFactory != null) {
                                Class<? extends DefaultValueBuilder> factoryClass = defaultsFactory.value();
                                builder = factoryClass.newInstance();
                            }
                            if (builder == null) {
                                builder = this.defaultBuilders.get(metaType);
                            }
                            if (builder != null) {
                                MetaValue defaultMV = builder.buildMetaValue(defaultValue);
                                if (defaultMV != null) {
                                    fields.setField("defaultValue", defaultMV);
                                }
                            } else {
                                log.warn((Object)("Failed to find DefaultValueBuilder for type: " + metaType));
                            }
                        }
                        catch (Exception e) {
                            log.warn((Object)("Failed to create default value for: " + propertyInfo), (Throwable)e);
                        }
                    }
                    if (!propAnnotations.isEmpty()) {
                        fields.setField("annotations", propAnnotations);
                    }
                    try {
                        ManagedPropertyConstraintsPopulatorFactory mpcpf;
                        ManagedPropertyConstraintsPopulator populator;
                        Class<? extends ManagedPropertyConstraintsPopulatorFactory> factoryClass = moConstraintsFactory;
                        ConstraintsPopulatorFactory cpf = this.getAnnotation(ConstraintsPopulatorFactory.class, (AnnotatedInfo)propertyInfo, metaData);
                        if (cpf != null) {
                            factoryClass = cpf.value();
                        } else {
                            cpf = moCPF;
                        }
                        if (factoryClass != null && (populator = (mpcpf = factoryClass.newInstance()).newInstance(cpf.min(), cpf.max(), cpf.legalValues(), cpf.args())) != null) {
                            populator.populateManagedProperty(clazz, propertyInfo, fields);
                        }
                    }
                    catch (Exception e) {
                        log.debug((Object)("Failed to populate constraints for: " + propertyInfo), (Throwable)e);
                    }
                    ManagedProperty property = null;
                    Class<? extends ManagedProperty> mpClass = moPropertyFactory;
                    ManagementPropertyFactory mpf = this.getAnnotation(ManagementPropertyFactory.class, (AnnotatedInfo)propertyInfo, metaData);
                    if (mpf != null) {
                        mpClass = mpf.value();
                    }
                    if (mpClass != null) {
                        property = this.getManagedProperty(mpClass, fields);
                    }
                    if (property == null) {
                        property = this.createDefaultManagedProperty(fields);
                    }
                    if (mapperReturn[0] != null) {
                        property.setTransientAttachment(MetaMapper.class.getName(), mapperReturn[0]);
                    }
                    properties.add(property);
                    continue;
                }
                if (!trace) continue;
                log.trace((Object)("Ignoring property: " + propertyInfo));
            }
        }
        HashSet<ManagedOperation> operations = new HashSet<ManagedOperation>();
        Set methodInfos = beanInfo.getMethods();
        if (methodInfos != null && !methodInfos.isEmpty()) {
            for (MethodInfo methodInfo : methodInfos) {
                ManagementOperation managementOp = this.getAnnotation(ManagementOperation.class, (AnnotatedInfo)methodInfo, metaData);
                if (managementOp == null) continue;
                ManagedOperation op = this.getManagedOperation(methodInfo, managementOp, metaData);
                operations.add(op);
            }
        }
        ManagedObjectImpl result = new ManagedObjectImpl(name, properties);
        result.setAnnotations(moAnnotations);
        if (isRuntime && !name.equals(classInfo.getName())) {
            result.setComponentName(name);
        }
        if (nameType != null) {
            result.setNameType(nameType);
        }
        if (attachmentName != null) {
            result.setAttachmentName(attachmentName);
        }
        if (operations.size() > 0) {
            result.setOperations(operations);
        }
        for (ManagedProperty property : properties) {
            property.setManagedObject(result);
        }
        result.setTransientAttachment(BeanInfo.class.getName(), beanInfo);
        return result;
    }

    protected ManagedProperty createDefaultManagedProperty(Fields fields) {
        return new WritethroughManagedPropertyImpl(fields, this.metaValueFactory, this);
    }

    protected String getPropertyName(ManagedProperty property) {
        String name = property.getMappedName();
        if (name == null) {
            property.getName();
        }
        return name;
    }

    protected ManagedOperation getManagedOperation(MethodInfo methodInfo, ManagementOperation opAnnotation, MetaData metaData) {
        String name = methodInfo.getName();
        String description = opAnnotation.description();
        ManagedOperation.Impact impact = opAnnotation.impact();
        ManagementParameter[] params = opAnnotation.params();
        ParameterInfo[] paramInfo = methodInfo.getParameters();
        ArrayList<ManagedParameterImpl> mparams = new ArrayList<ManagedParameterImpl>();
        Class<? extends ManagedParameterConstraintsPopulatorFactory> opConstraintsFactor = opAnnotation.constraintsFactory();
        MetaMapper[] returnTypeMapper = new MetaMapper[]{null};
        MetaType returnType = this.getMetaType((AnnotatedInfo)methodInfo, methodInfo.getReturnType(), metaData, true, returnTypeMapper);
        if (paramInfo != null) {
            for (int i = 0; i < paramInfo.length; ++i) {
                ParameterInfo pinfo = paramInfo[i];
                String pname = pinfo.getName();
                String pdescription = null;
                ManagementParameter mpa = null;
                if (i < params.length) {
                    mpa = params[i];
                    if (!mpa.name().equals("")) {
                        pname = mpa.name();
                    }
                    if (!mpa.description().equals("")) {
                        pdescription = mpa.description();
                    }
                }
                if (pname == null) {
                    pname = "arg#" + i;
                }
                DefaultFieldsImpl fields = new DefaultFieldsImpl(pname);
                if (pdescription != null) {
                    fields.setField("description", pdescription);
                }
                MetaMapper[] paramMapper = new MetaMapper[]{null};
                MetaType metaType = this.getMetaType((AnnotatedInfo)pinfo, pinfo.getParameterType(), metaData, true, paramMapper);
                fields.setField("metaType", metaType);
                try {
                    ManagedParameterConstraintsPopulatorFactory factory;
                    ManagedParameterConstraintsPopulator populator;
                    Class<? extends ManagedParameterConstraintsPopulatorFactory> factoryClass = opConstraintsFactor;
                    if (factoryClass == ManagementParameter.NULL_CONSTRAINTS.class && mpa != null) {
                        factoryClass = mpa.constraintsFactory();
                    }
                    if ((populator = (factory = factoryClass.newInstance()).newInstance()) != null) {
                        populator.populateManagedParameter(name, pinfo, fields);
                    }
                }
                catch (Exception e) {
                    log.debug((Object)("Failed to populate constraints for: " + pinfo), (Throwable)e);
                }
                ManagedParameterImpl mp = new ManagedParameterImpl(fields);
                if (paramMapper[0] != null) {
                    mp.setTransientAttachment(MetaMapper.class.getName(), paramMapper[0]);
                }
                mparams.add(mp);
            }
        }
        ManagedParameter[] parameters = new ManagedParameter[mparams.size()];
        mparams.toArray(parameters);
        ManagedOperationImpl op = new ManagedOperationImpl(name, description, impact, parameters, returnType);
        if (returnTypeMapper[0] != null) {
            op.setTransientAttachment(MetaMapper.class.getName(), returnTypeMapper[0]);
        }
        return op;
    }

    protected MetaType getMetaType(AnnotatedInfo info, TypeInfo infoType, MetaData metaData, boolean useTypeFactory, MetaMapper[] mapperReturn) {
        MetaType returnType = null;
        MetaMapper metaMapper = null;
        MetaMapping metaMapping = this.getAnnotation(MetaMapping.class, info, metaData);
        MetaMappingFactory metaMappingFactory = this.getAnnotation(MetaMappingFactory.class, info, metaData);
        if (metaMappingFactory != null) {
            Class mmfClass = metaMappingFactory.value();
            try {
                MetaMapperFactory mmf = (MetaMapperFactory)mmfClass.newInstance();
                String[] args = metaMappingFactory.args();
                metaMapper = args.length > 0 ? mmf.newInstance(args) : mmf.newInstance();
            }
            catch (Exception e) {
                log.debug((Object)("Failed to create MetaMapperFactory: " + metaMappingFactory), (Throwable)e);
            }
        }
        if (metaMapping != null) {
            Class mapperClass = metaMapping.value();
            try {
                metaMapper = (MetaMapper)mapperClass.newInstance();
            }
            catch (Exception e) {
                log.debug((Object)("Failed to create MetaMapper: " + metaMapping), (Throwable)e);
            }
        }
        if (metaMapper != null) {
            returnType = metaMapper.getMetaType();
            if (mapperReturn != null && mapperReturn.length > 0) {
                mapperReturn[0] = metaMapper;
            }
        }
        if (returnType == null && useTypeFactory) {
            returnType = this.metaTypeFactory.resolve(infoType);
        }
        return returnType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ManagedObjectBuilder getBuilder(Class<?> clazz) {
        Map<Class<?>, ManagedObjectBuilder> map = this.builders;
        synchronized (map) {
            ManagedObjectBuilder builder = this.builders.get(clazz);
            if (builder != null) {
                return builder;
            }
        }
        return this;
    }

    public <X> InstanceClassFactory<X> getInstanceClassFactory(Class<X> clazz, MetaData metaData) {
        InstanceClassFactory mdrFactory;
        InstanceClassFactory defaultFactory = this.defaultInstanceFactory;
        if (metaData != null && (mdrFactory = (InstanceClassFactory)metaData.getMetaData(InstanceClassFactory.class)) != null) {
            defaultFactory = mdrFactory;
        }
        InstanceClassFactory factory = Utility.getInstanceClassFactory(clazz, this.instanceFactories, defaultFactory);
        return factory;
    }

    protected void initDefaultValueBuilders() {
        this.addDefaultValueBuilder((DefaultValueBuilder)new BigDecimalDefaultValueBuilder());
        this.addDefaultValueBuilder((DefaultValueBuilder)new BigIntegerDefaultValueBuilder());
        this.addDefaultValueBuilder((DefaultValueBuilder)new DoubleDefaultValueBuilder());
        this.addDefaultValueBuilder((DefaultValueBuilder)new DoublePrimitiveDefaultValueBuilder());
        this.addDefaultValueBuilder((DefaultValueBuilder)new FloatDefaultValueBuilder());
        this.addDefaultValueBuilder((DefaultValueBuilder)new FloatPrimitiveDefaultValueBuilder());
        this.addDefaultValueBuilder((DefaultValueBuilder)new CharDefaultValueBuilder());
        this.addDefaultValueBuilder((DefaultValueBuilder)new CharPrimitiveDefaultValueBuilder());
        this.addDefaultValueBuilder((DefaultValueBuilder)new IntDefaultValueBuilder());
        this.addDefaultValueBuilder((DefaultValueBuilder)new IntPrimitiveDefaultValueBuilder());
        this.addDefaultValueBuilder((DefaultValueBuilder)new ShortDefaultValueBuilder());
        this.addDefaultValueBuilder((DefaultValueBuilder)new ShortPrimitiveDefaultValueBuilder());
        this.addDefaultValueBuilder((DefaultValueBuilder)new LongDefaultValueBuilder());
        this.addDefaultValueBuilder((DefaultValueBuilder)new LongPrimitiveDefaultValueBuilder());
        this.addDefaultValueBuilder((DefaultValueBuilder)new ByteDefaultValueBuilder());
        this.addDefaultValueBuilder((DefaultValueBuilder)new BytePrimitiveDefaultValueBuilder());
        this.addDefaultValueBuilder((DefaultValueBuilder)new BooleanDefaultValueBuilder());
        this.addDefaultValueBuilder((DefaultValueBuilder)new BooleanPrimitiveDefaultValueBuilder());
        this.addDefaultValueBuilder((DefaultValueBuilder)new PropertiesDefaultValueBuilder());
        this.addDefaultValueBuilder((DefaultValueBuilder)new StringDefaultValueBuilder());
    }

    protected <X> ManagedObjectPopulator<X> getPopulator(Class<X> clazz) {
        ManagedObjectBuilder builder = this.getBuilder(clazz);
        if (builder instanceof ManagedObjectPopulator) {
            return (ManagedObjectPopulator)((Object)builder);
        }
        ManagedObjectPopulator<?> mop = this.defaultManagedObjectPopulator;
        return mop;
    }

    protected Collection<?> getAsCollection(Object value) {
        if (value.getClass().isArray()) {
            return Arrays.asList(value);
        }
        if (value instanceof Collection) {
            return (Collection)Collection.class.cast(value);
        }
        return null;
    }

    protected ManagedProperty getManagedProperty(Class<? extends ManagedProperty> factory, Fields fields) {
        return AbstractManagedObjectFactory.createManagedProperty(factory, fields);
    }

    protected <X extends Annotation> X getAnnotation(Class<X> annotationType, AnnotatedInfo info, MetaData metaData) {
        Annotation annotation = null;
        if (metaData != null) {
            MethodInfo mi;
            Signature mis;
            MetaData imetaData;
            annotation = metaData.getAnnotation(annotationType);
            if (annotation == null && info instanceof MethodInfo && (imetaData = metaData.getComponentMetaData(mis = Signature.getSignature((MemberInfo)(mi = (MethodInfo)info)))) != null) {
                annotation = imetaData.getAnnotation(annotationType);
            }
            if (annotation == null && info instanceof PropertyInfo) {
                FieldSignature fis;
                PropertyInfo pi = (PropertyInfo)info;
                if (pi.getGetter() != null && (imetaData = metaData.getComponentMetaData(mis = new MethodSignature(pi.getGetter()))) != null) {
                    annotation = imetaData.getAnnotation(annotationType);
                }
                if (annotation == null && pi.getSetter() != null && (imetaData = metaData.getComponentMetaData(mis = new MethodSignature(pi.getSetter()))) != null) {
                    annotation = imetaData.getAnnotation(annotationType);
                }
                if (annotation == null && pi.getFieldInfo() != null && (imetaData = metaData.getComponentMetaData((Signature)(fis = new FieldSignature(pi.getFieldInfo())))) != null) {
                    annotation = imetaData.getAnnotation(annotationType);
                }
            }
            if (annotation != null) {
                log.trace((Object)("Loaded " + annotationType + " from MetaData"));
            }
        }
        if (annotation == null) {
            annotation = info.getUnderlyingAnnotation(annotationType);
        }
        return (X)annotation;
    }

    protected BeanInfo getBeanInfo(Class<?> iface) {
        BeanInfo ifaceBI = configuration.getBeanInfo(iface);
        Class<?>[] superIfaces = iface.getInterfaces();
        if (superIfaces != null && superIfaces.length > 0) {
            HashSet allProps = new HashSet(ifaceBI.getProperties());
            HashSet allMethods = new HashSet(ifaceBI.getMethods());
            for (Class<?> superIface : superIfaces) {
                Set methods;
                BeanInfo cBI = configuration.getBeanInfo(superIface);
                Set props = cBI.getProperties();
                if (props != null) {
                    allProps.addAll(props);
                }
                if ((methods = cBI.getMethods()) == null) continue;
                allMethods.addAll(methods);
            }
            ifaceBI.setProperties(allProps);
            ifaceBI.setMethods(allMethods);
        }
        return ifaceBI;
    }
}

