/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.schema.DocumentTypeDescriptor;
import org.nuxeo.ecm.core.schema.PrefetchInfo;
import org.nuxeo.ecm.core.schema.SchemaBindingDescriptor;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.SchemaManagerImpl;
import org.nuxeo.ecm.core.schema.TypeConfiguration;
import org.nuxeo.ecm.core.schema.TypeHelperDescriptor;
import org.nuxeo.ecm.core.schema.TypeProvider;
import org.nuxeo.ecm.core.schema.TypeProviderDescriptor;
import org.nuxeo.ecm.core.schema.XSDLoader;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.TypeException;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.api.ServiceGroup;
import org.nuxeo.runtime.api.ServiceManager;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;
import org.nuxeo.runtime.model.RuntimeContext;
import org.xml.sax.SAXException;

public class TypeService
extends DefaultComponent {
    public static final ComponentName NAME = new ComponentName("org.nuxeo.ecm.core.schema.TypeService");
    private static final Log log = LogFactory.getLog(TypeService.class);
    private SchemaManagerImpl typeManager;
    private XSDLoader schemaLoader;
    private ComponentContext context;
    private TypeConfiguration configuration;
    private static SchemaManager schemaManagerInstance;

    public static SchemaManager getSchemaManager() {
        return schemaManagerInstance;
    }

    public SchemaManager getTypeManager() {
        return this.typeManager;
    }

    public XSDLoader getSchemaLoader() {
        return this.schemaLoader;
    }

    public void activate(ComponentContext context) {
        this.context = context;
        try {
            this.typeManager = new SchemaManagerImpl();
            this.schemaLoader = new XSDLoader(this.typeManager);
            schemaManagerInstance = this.typeManager;
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    public void deactivate(ComponentContext context) {
        this.typeManager.clear();
        this.typeManager = null;
        schemaManagerInstance = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void registerExtension(Extension extension) {
        String xp = extension.getExtensionPoint();
        if ("doctype".equals(xp)) {
            Object[] contribs;
            for (Object contrib : contribs = extension.getContributions()) {
                this.typeManager.registerDocumentType((DocumentTypeDescriptor)contrib);
            }
            return;
        } else if ("schema".equals(xp)) {
            Object[] contribs;
            for (Object contrib : contribs = extension.getContributions()) {
                try {
                    SchemaBindingDescriptor sbd = (SchemaBindingDescriptor)contrib;
                    sbd.context = extension.getContext();
                    this.registerSchema(sbd);
                }
                catch (Exception e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
            return;
        } else if ("configuration".equals(xp)) {
            Object[] contribs = extension.getContributions();
            if (contribs.length <= 0) return;
            this.setConfiguration((TypeConfiguration)contribs[0]);
            return;
        } else if ("helper".equals(xp)) {
            Object[] contribs = extension.getContributions();
            if (contribs.length <= 0) return;
            TypeHelperDescriptor thd = (TypeHelperDescriptor)contribs[0];
            try {
                this.typeManager.registerHelper(thd.schema, thd.type, thd.helperClass.newInstance());
                return;
            }
            catch (Exception e) {
                log.error((Object)("Failed to instantiate type helper: " + thd.helperClass), (Throwable)e);
            }
            return;
        } else {
            Object[] contribs;
            if (!"provider".equals(xp) || (contribs = extension.getContributions()).length <= 0) return;
            TypeProviderDescriptor tpd = (TypeProviderDescriptor)contribs[0];
            ServiceManager sm = (ServiceManager)Framework.getLocalService(ServiceManager.class);
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(TypeService.class.getClassLoader());
                TypeProvider provider = null;
                if (tpd.uri != null) {
                    provider = (TypeProvider)sm.getService(tpd.uri);
                } else if (tpd.group != null) {
                    ServiceGroup group = sm.getGroup(tpd.group);
                    if (group != null) {
                        provider = (TypeProvider)group.getService(TypeProvider.class);
                    } else {
                        log.warn((Object)("Invalid type provider extension contribued by: " + extension.getComponent().getName() + ". no such service group: " + tpd.group));
                    }
                } else {
                    log.warn((Object)("Invalid type provider extension contribued by: " + extension.getComponent().getName()));
                }
                if (provider != null) {
                    if (provider == this.typeManager) return;
                    log.info((Object)"Importing types from external provider");
                    this.typeManager.importTypes(provider);
                    return;
                }
                log.warn((Object)("Could not instatiate or locate the type provider contributed by: " + extension.getComponent().getName()));
                return;
            }
            catch (Exception e) {
                log.error((Object)"Failed to register type provider", (Throwable)e);
                return;
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
    }

    public void unregisterExtension(Extension extension) {
        String xp = extension.getExtensionPoint();
        if ("doctype".equals(xp)) {
            Object[] contribs;
            for (Object contrib : contribs = extension.getContributions()) {
                this.typeManager.unregisterDocumentType(((DocumentTypeDescriptor)contrib).name);
            }
        } else if ("schema".equals(xp)) {
            Object[] contribs;
            for (Object contrib : contribs = extension.getContributions()) {
                this.typeManager.unregisterSchema(((SchemaBindingDescriptor)contrib).name);
            }
        } else if ("helper".equals(xp)) {
            Object[] contribs = extension.getContributions();
            if (contribs.length > 0) {
                TypeHelperDescriptor thd = (TypeHelperDescriptor)contribs[0];
                this.typeManager.unregisterHelper(thd.schema, thd.type);
            }
        } else if ("provider".equals(xp)) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerSchema(SchemaBindingDescriptor sd) throws IOException, TypeException, SAXException {
        if (sd.src != null && sd.src.length() > 0) {
            RuntimeContext schemaContext = sd.context == null ? this.context.getRuntimeContext() : sd.context;
            URL url = schemaContext.getLocalResource(sd.src);
            if (url == null) {
                url = schemaContext.getResource(sd.src);
            }
            if (url != null) {
                InputStream in = url.openStream();
                try {
                    File file = new File(this.typeManager.getSchemaDirectory(), sd.name + ".xsd");
                    FileUtils.copyToFile((InputStream)in, (File)file);
                    Schema oldschema = this.typeManager.getSchema(sd.name);
                    this.schemaLoader.loadSchema(sd.name, sd.prefix, file, sd.override);
                    if (oldschema == null) {
                        log.info((Object)("Registered schema: " + sd.name + " from " + url.toString()));
                    }
                    log.info((Object)("Reregistered schema: " + sd.name));
                }
                finally {
                    in.close();
                }
            } else {
                log.error((Object)("XSD Schema not found: " + sd.src));
            }
        } else {
            log.error((Object)"INLINE Schemas ARE NOT YET IMPLEMENTED!");
        }
    }

    public void setConfiguration(TypeConfiguration configuration) {
        this.configuration = configuration;
        if (this.typeManager != null) {
            this.typeManager.setPrefetchInfo(new PrefetchInfo(configuration.prefetchInfo));
        }
    }

    public TypeConfiguration getConfiguration() {
        return this.configuration;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (SchemaManager.class.isAssignableFrom(adapter)) {
            return (T)this.typeManager;
        }
        if (TypeProvider.class.isAssignableFrom(adapter)) {
            return (T)this.typeManager;
        }
        return null;
    }
}

