/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.plugins.context.AbstractURLHandler;
import org.jboss.virtual.plugins.context.AbstractVFSContext;
import org.jboss.virtual.plugins.context.DelegatingHandler;
import org.jboss.virtual.plugins.context.file.FileHandler;
import org.jboss.virtual.plugins.context.file.LinkHandler;
import org.jboss.virtual.plugins.context.jar.JarHandler;
import org.jboss.virtual.plugins.context.jar.JarUtils;
import org.jboss.virtual.plugins.context.zip.ZipEntryContext;
import org.jboss.virtual.spi.LinkInfo;
import org.jboss.virtual.spi.VFSContextConstraints;
import org.jboss.virtual.spi.VirtualFileHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemContext
extends AbstractVFSContext {
    protected static final Logger staticLog = Logger.getLogger(FileSystemContext.class);
    private static boolean forceVfsJar = AccessController.doPrivileged(new CheckForceVfsJar());
    private static boolean forceCaseSensitive;
    private static final Set<VFSContextConstraints> CONSTRAINTS;
    private volatile transient File file;
    private volatile VirtualFileHandler root;

    private static File getFile(URI uri) throws IOException, URISyntaxException {
        if (uri == null) {
            throw new IllegalArgumentException("Null uri");
        }
        if (uri.getAuthority() != null || uri.getFragment() != null || uri.getQuery() != null) {
            uri = new URI("file", null, uri.getPath(), null);
        }
        return new File(uri);
    }

    private static URI getFileURI(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        URI url = file.toURI();
        String path = url.getPath();
        if (!file.isDirectory()) {
            path = VFSUtils.fixName(path);
        } else if (!path.endsWith("/")) {
            path = path + '/';
        }
        try {
            return new URI("file", null, path, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Failed to convert file.toURI", e);
        }
    }

    public FileSystemContext(URL rootURL) throws IOException, URISyntaxException {
        this(VFSUtils.toURI(rootURL));
    }

    public FileSystemContext(URI rootURI) throws IOException, URISyntaxException {
        this(rootURI, FileSystemContext.getFile(rootURI));
    }

    public FileSystemContext(File file) throws IOException, URISyntaxException {
        this(FileSystemContext.getFileURI(file), file);
    }

    private FileSystemContext(URI rootURI, File file) throws IOException {
        super(rootURI);
        this.file = file;
    }

    @Override
    public Set<VFSContextConstraints> getConstraints() {
        return CONSTRAINTS;
    }

    @Override
    public String getName() {
        return this.root != null ? this.root.getName() : this.file.getName();
    }

    @Override
    public VirtualFileHandler getRoot() throws IOException {
        if (this.root == null) {
            this.root = this.createVirtualFileHandler(null, this.file);
            if (this.root == null) {
                throw new FileNotFoundException((this.file == null ? "<null>" : this.file.getName()) + " doesn't exist. (rootURI: " + this.getRootURI() + ", file: " + this.file + ")");
            }
            this.file = null;
        }
        return this.root;
    }

    public VirtualFileHandler createVirtualFileHandler(VirtualFileHandler parent, File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        String name = file.getName();
        if (file.isFile() && JarUtils.isArchive(name)) {
            if (!this.exists(file)) {
                return null;
            }
            if (forceVfsJar) {
                try {
                    return new JarHandler(this, parent, file, file.toURI().toURL(), name);
                }
                catch (IOException e) {
                    this.log.debug((Object)("Exception while trying to handle file (" + name + ") as a jar: " + e.getMessage()));
                }
            } else {
                try {
                    return this.mountZipFS(parent, name, file);
                }
                catch (Exception e) {
                    this.log.debug((Object)("IGNORING: Exception while trying to handle file (" + name + ") as a jar through ZipEntryContext: "), (Throwable)e);
                }
            }
        }
        return this.createVirtualFileHandler(parent, file, FileSystemContext.getFileURI(file));
    }

    protected DelegatingHandler mountZipFS(VirtualFileHandler parent, String name, File file) throws IOException, URISyntaxException {
        URL fileUrl;
        DelegatingHandler delegator = new DelegatingHandler(this, parent, name);
        URL delegatorUrl = fileUrl = file.toURI().toURL();
        if (parent != null) {
            delegatorUrl = this.getChildURL(parent, name);
        }
        delegatorUrl = this.setOptionsToURL(delegatorUrl);
        ZipEntryContext ctx = new ZipEntryContext(delegatorUrl, delegator, fileUrl);
        VirtualFileHandler handler = ctx.getRoot();
        delegator.setDelegate(handler);
        return delegator;
    }

    public VirtualFileHandler createVirtualFileHandler(VirtualFileHandler parent, File file, URI uri) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        if (uri == null) {
            throw new IllegalArgumentException("Null uri");
        }
        AbstractURLHandler handler = null;
        if (VFSUtils.isLink(file.getName())) {
            handler = this.createLinkHandler(parent, file, null);
        } else if (!this.exists(file) && parent != null) {
            if (parent instanceof FileHandler) {
                handler = ((FileHandler)parent).getChildLink(file.getName());
            }
        } else if (this.exists(file)) {
            handler = new FileHandler(this, parent, file, uri);
        }
        return handler;
    }

    LinkHandler createLinkHandler(VirtualFileHandler parent, File file, String linkNameCondition) throws IOException {
        URI uri = file.toURI();
        LinkHandler handler = null;
        Properties props = new Properties();
        FileInputStream fis = new FileInputStream(file);
        try {
            List<LinkInfo> links = VFSUtils.readLinkInfo(fis, file.getName(), props);
            String name = file.getName();
            name = name.substring(0, name.indexOf(".vfslink"));
            if (name.length() == 0 || ".".equals(name) || "..".equals(name)) {
                throw new IOException("Invalid link name: " + name + " (generated from file: " + file + ")");
            }
            if (linkNameCondition == null || linkNameCondition.equals(name)) {
                handler = new LinkHandler(this, parent, uri, name, links);
            }
        }
        catch (URISyntaxException e) {
            IOException ex = new IOException("Failed to parse link URIs");
            ex.initCause(e);
            throw ex;
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException e) {
                this.log.debug((Object)("Exception closing file input stream: " + fis), (Throwable)e);
            }
        }
        return handler;
    }

    protected boolean exists(File file) throws IOException {
        boolean isCaseSensitive = forceCaseSensitive;
        if (!isCaseSensitive) {
            isCaseSensitive = this.getOptions().getBooleanOption("caseSensitive");
        }
        if (isCaseSensitive && !file.getCanonicalFile().getName().equals(file.getName())) {
            return false;
        }
        return file.exists();
    }

    public boolean isForcedCaseSensitive() {
        return forceCaseSensitive;
    }

    static {
        if (forceVfsJar) {
            staticLog.info((Object)"VFS forced fallback to vfsjar is enabled.");
        }
        if (forceCaseSensitive = AccessController.doPrivileged(new CheckForceCaseSensitive()).booleanValue()) {
            staticLog.debug((Object)"VFS forced case sensitivity is enabled.");
        }
        CONSTRAINTS = Collections.singleton(VFSContextConstraints.CACHEABLE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CheckForceCaseSensitive
    implements PrivilegedAction<Boolean> {
        private CheckForceCaseSensitive() {
        }

        @Override
        public Boolean run() {
            String forceString = System.getProperty("jboss.vfs.forceCaseSensitive", "false");
            return Boolean.valueOf(forceString);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CheckForceVfsJar
    implements PrivilegedAction<Boolean> {
        private CheckForceVfsJar() {
        }

        @Override
        public Boolean run() {
            String forceString = System.getProperty("jboss.vfs.forceVfsJar", "false");
            return Boolean.valueOf(forceString);
        }
    }
}

