/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.protocol;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLStreamHandler;
import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.plugins.vfs.VirtualFileURLConnection;
import org.jboss.virtual.spi.registry.VFSRegistry;

public abstract class AbstractVFSHandler
extends URLStreamHandler {
    private static Map<Class, Integer> lengths = new WeakHashMap<Class, Integer>();

    protected int getProtocolNameLength() {
        Class<?> clazz = this.getClass();
        Integer length = lengths.get(clazz);
        if (length == null) {
            Package pck = clazz.getPackage();
            String pckName = pck.getName();
            int p = pckName.lastIndexOf(46);
            length = pckName.substring(p + 1).length();
            lengths.put(clazz, length);
        }
        return length;
    }

    protected URLConnection openConnection(URL url) throws IOException {
        String relative;
        File fp;
        VFSRegistry registry = VFSRegistry.getInstance();
        VirtualFile vf = registry.getFile(url);
        if (vf != null) {
            return new VirtualFileURLConnection(url, vf);
        }
        String file = URLDecoder.decode(url.toExternalForm(), "UTF-8").substring(this.getProtocolNameLength() + 1);
        URL vfsurl = null;
        String queryStr = url.getQuery();
        if (queryStr != null) {
            file = file.substring(0, file.lastIndexOf(63));
        }
        if ((fp = new File(file)).exists()) {
            vfsurl = fp.getParentFile().toURI().toURL();
            relative = fp.getName();
        } else {
            File curr = fp;
            relative = fp.getName();
            while ((curr = curr.getParentFile()) != null) {
                if (curr.exists()) {
                    vfsurl = curr.toURI().toURL();
                    break;
                }
                relative = curr.getName() + "/" + relative;
            }
        }
        if (vfsurl == null) {
            throw new IOException("VFS file does not exist: " + url);
        }
        if (queryStr != null) {
            vfsurl = new URL(vfsurl + "?" + queryStr);
        }
        return new VirtualFileURLConnection(url, vfsurl, relative);
    }
}

