/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.util;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.apache.xerces.xs.XSWildcard;
import org.jboss.logging.Logger;
import org.jboss.xb.binding.Util;
import org.jboss.xb.binding.resolver.MultiClassSchemaResolver;
import org.jboss.xb.binding.sunday.unmarshalling.AllBinding;
import org.jboss.xb.binding.sunday.unmarshalling.AttributeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ChoiceBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ModelGroupBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SequenceBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TermBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.UnorderedSequenceBinding;
import org.jboss.xb.binding.sunday.unmarshalling.WildcardBinding;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaBindingValidator {
    private static final Logger log = Logger.getLogger(SchemaBindingValidator.class);
    private static final QName WILDCARD = new QName("wildcard", "wildcard");
    private Set<String> excludedNs = new HashSet<String>();
    private Set<QName> excludedTypes = new HashSet<QName>();
    private Set<QName> validatedTypes = new HashSet<QName>();
    private Set<QName> validatedElements = new HashSet<QName>();
    private boolean loggingEnabled;

    public SchemaBindingValidator() {
        this.reset();
        this.excludeNs("http://www.w3.org/2001/XMLSchema");
    }

    public void reset() {
        this.loggingEnabled = log.isTraceEnabled();
        this.validatedTypes.clear();
        this.validatedElements.clear();
    }

    public boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    public void enableLogging(boolean value) {
        this.loggingEnabled = value;
    }

    public void excludeNs(String ns) {
        this.excludedNs.add(ns);
    }

    public boolean isNsExcluded(String ns) {
        return this.excludedNs.contains(ns);
    }

    public void includeNs(String ns) {
        this.excludedNs.remove(ns);
    }

    public void excludeType(QName qName) {
        this.excludedTypes.add(qName);
    }

    public boolean isTypeExcluded(QName qName) {
        return this.excludedTypes.contains(qName);
    }

    public void includeType(QName qName) {
        this.excludedTypes.remove(qName);
    }

    public void validate(InputSource is, SchemaBinding binding) {
        XSModel xsModel = Util.loadSchema(is, binding.getSchemaResolver());
        this.validate(xsModel, binding);
    }

    public void validate(String xsdName, Class<?> ... cls) {
        XSModel xsModel;
        this.log("validate: " + xsdName + ", " + Arrays.asList(cls));
        URL xsdUrl = Thread.currentThread().getContextClassLoader().getResource("schema/" + xsdName);
        if (xsdUrl == null) {
            this.handleError("Failed to load schema from the classpath: schema/" + xsdName);
        }
        MultiClassSchemaResolver resolver = new MultiClassSchemaResolver();
        resolver.mapLocationToClasses(xsdName, cls);
        SchemaBinding binding = resolver.resolve("", null, xsdName);
        try {
            xsModel = Util.loadSchema(xsdUrl.openStream(), null, (SchemaBindingResolver)resolver);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read schema " + xsdName, e);
        }
        this.validate(xsModel, binding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(XSModel xsSchema, SchemaBinding schemaBinding) {
        try {
            XSNamedMap types = xsSchema.getComponents((short)3);
            for (int i = 0; i < types.getLength(); ++i) {
                QName typeQName;
                XSTypeDefinition xsType = (XSTypeDefinition)types.item(i);
                if (this.excludedNs.contains(xsType.getNamespace()) || this.excludedTypes.contains(typeQName = new QName(xsType.getNamespace(), xsType.getName()))) continue;
                TypeBinding typeBinding = schemaBinding.getType(typeQName);
                if (typeBinding == null) {
                    boolean ignoreIfNotFound = false;
                    if (xsType.getTypeCategory() == 16) {
                        ignoreIfNotFound = true;
                    } else {
                        XSComplexTypeDefinition xsComplexType = (XSComplexTypeDefinition)xsType;
                        if (xsComplexType.getContentType() == 1) {
                            XSAttributeUse xsAttrUse;
                            XSAttributeDeclaration xsAttr;
                            XSObjectList attributeUses = xsComplexType.getAttributeUses();
                            if (attributeUses.getLength() == 0) {
                                ignoreIfNotFound = true;
                            } else if (attributeUses.getLength() == 1 && (xsAttr = (xsAttrUse = (XSAttributeUse)attributeUses.item(0)).getAttrDeclaration()).getNamespace() == null && "id".equals(xsAttr.getName())) {
                                ignoreIfNotFound = true;
                            }
                        }
                    }
                    if (ignoreIfNotFound) continue;
                    if (this.isLoggingEnabled()) {
                        this.log("SchemaBinding global types: ");
                        Iterator<TypeBinding> iter = schemaBinding.getTypes();
                        while (iter.hasNext()) {
                            TypeBinding type = iter.next();
                            if (this.excludedNs.contains(type.getQName().getNamespaceURI())) continue;
                            this.log("- " + type.getQName());
                        }
                    }
                    this.handleError("TypeBinding " + typeQName + " is not found in the SchemaBinding.");
                    continue;
                }
                this.validate(xsType, typeBinding);
            }
            XSNamedMap elements = xsSchema.getComponents((short)2);
            for (int i = 0; i < elements.getLength(); ++i) {
                XSElementDeclaration xsElement = (XSElementDeclaration)elements.item(i);
                if (this.excludedNs.contains(xsElement.getNamespace())) continue;
                QName elementQName = new QName(xsElement.getNamespace(), xsElement.getName());
                ElementBinding elementBinding = schemaBinding.getElement(elementQName);
                if (elementBinding == null) {
                    this.handleError("ElementBinding " + elementQName + " is not found in the SchemaBinding.");
                }
                this.validate(xsElement.getTypeDefinition(), elementBinding.getType());
            }
        }
        finally {
            this.reset();
        }
    }

    public void validate(XSElementDeclaration xsElement, ElementBinding elementBinding) {
        QName xsQName = new QName(xsElement.getNamespace(), xsElement.getName());
        if (xsQName.equals(elementBinding.getQName())) {
            this.handleError("Compared elements have difference names: XSD QName is " + xsQName + ", ElementBinding QName is " + elementBinding.getQName());
        }
        this.log("element " + xsQName);
        if (this.validatedElements.contains(xsQName)) {
            return;
        }
        this.validatedElements.add(xsQName);
        this.validate(xsElement.getTypeDefinition(), elementBinding.getType());
    }

    public void validate(XSTypeDefinition xsType, TypeBinding typeBinding) {
        if (xsType.getName() == null) {
            if (typeBinding.getQName() != null) {
                this.handleError("XSD type is anonymous but TypeBinding has QName " + typeBinding.getQName());
            }
        } else {
            if (this.excludedNs.contains(xsType.getNamespace())) {
                return;
            }
            QName xsQName = new QName(xsType.getNamespace(), xsType.getName());
            if (!xsQName.equals(typeBinding.getQName())) {
                this.handleError("Compared types have different names: XSD QName is " + xsQName + ", TypeBinding QName is " + typeBinding.getQName());
            }
            if (this.validatedTypes.contains(xsQName) || this.excludedTypes.contains(xsQName)) {
                return;
            }
            this.validatedTypes.add(xsQName);
        }
        if (xsType.getTypeCategory() == 16) {
            this.validate((XSSimpleTypeDefinition)xsType, typeBinding);
        } else {
            this.validate((XSComplexTypeDefinition)xsType, typeBinding);
        }
    }

    public void validate(XSSimpleTypeDefinition xsType, TypeBinding typeBinding) {
        if (!typeBinding.isSimple()) {
            this.handleError("XSD type " + typeBinding.getQName() + " is simple but TypeBinding is not.");
        }
    }

    public void validate(XSComplexTypeDefinition xsType, TypeBinding typeBinding) {
        XSParticle xsParticle;
        XSSimpleTypeDefinition xsSimpleType;
        XSObjectList xsAttrUses;
        QName xsQName = xsType.getName() == null ? null : new QName(xsType.getNamespace(), xsType.getName());
        this.log("complex type " + xsQName);
        if (xsQName == null && typeBinding.getQName() != null || xsQName != null && !xsQName.equals(typeBinding.getQName())) {
            this.handleError("Compared complex types have different names: XSD QName is " + xsQName + ", TypeBindign QName is " + typeBinding.getQName());
        }
        if ((xsAttrUses = xsType.getAttributeUses()).getLength() != 0) {
            for (int i = 0; i < xsAttrUses.getLength(); ++i) {
                XSAttributeDeclaration xsAttr = ((XSAttributeUse)xsAttrUses.item(i)).getAttrDeclaration();
                QName xsAttrQName = new QName(xsAttr.getNamespace(), xsAttr.getName());
                AttributeBinding attrBinding = typeBinding.getAttribute(xsAttrQName);
                if (attrBinding == null) {
                    this.handleError("Attribute " + xsAttrQName + " is not found in TypeBinding " + typeBinding.getQName());
                }
                this.validate(xsAttr.getTypeDefinition(), attrBinding.getType());
            }
        }
        XSWildcard xsAttrWildcard = xsType.getAttributeWildcard();
        if (xsAttrWildcard != null && typeBinding.getAnyAttribute() == null) {
            this.handleError("TypeBinding " + typeBinding.getQName() + " doesn't have AnyAttributeBinding");
        }
        if ((xsSimpleType = xsType.getSimpleType()) != null) {
            TypeBinding simpleTypeBinding = typeBinding.getSimpleType();
            if (simpleTypeBinding == null) {
                this.handleError("XSD type " + typeBinding.getQName() + " allows text content but its corresponding TypeBinding doesn't.");
            }
            this.validate(xsSimpleType, simpleTypeBinding);
        }
        if ((xsParticle = xsType.getParticle()) != null) {
            ParticleBinding particleBinding = typeBinding.getParticle();
            if (particleBinding == null) {
                this.handleError("TypeBinding " + xsQName + " doesn't contain a ParticleBinding.");
            }
            this.validate(xsParticle, particleBinding);
        }
    }

    public void validate(XSParticle xsParticle, ParticleBinding particleBinding) {
        XSTerm xsTerm = xsParticle.getTerm();
        TermBinding termBinding = particleBinding.getTerm();
        if (termBinding == null) {
            this.handleError("ParticleBinding doesn't contain a TermBinding.");
        }
        short xsTermType = xsTerm.getType();
        String termStr = null;
        if (xsTermType == 7) {
            termStr = "sequence";
            XSModelGroup xsModelGroup = (XSModelGroup)xsTerm;
            short xsModelGroupCompositor = xsModelGroup.getCompositor();
            if (2 == xsModelGroupCompositor) {
                termStr = "choice";
            } else if (3 == xsModelGroupCompositor) {
                termStr = "all";
            }
            if (!termBinding.isModelGroup()) {
                if (xsModelGroup.getParticles().getLength() == 1) {
                    XSParticle xsWrappedParticle = (XSParticle)xsModelGroup.getParticles().item(0);
                    this.validate(xsWrappedParticle, particleBinding);
                } else {
                    this.handleError("TermBinding expected to be a " + termStr + " but was " + termBinding);
                }
            } else {
                this.validate(xsModelGroup, (ModelGroupBinding)termBinding);
            }
        } else if (xsTermType == 2) {
            XSElementDeclaration xsElement = (XSElementDeclaration)xsTerm;
            QName xsElementName = new QName(xsElement.getNamespace(), xsElement.getName());
            termStr = xsElementName.toString();
            if (!termBinding.isElement()) {
                ParticleBinding particle;
                SequenceBinding seq;
                Collection<ParticleBinding> particles;
                if (termBinding instanceof SequenceBinding && (particles = (seq = (SequenceBinding)termBinding).getParticles()).size() == 1 && (particle = particles.iterator().next()).getTerm().isElement()) {
                    particleBinding = particle;
                    termBinding = particle.getTerm();
                }
                if (!termBinding.isElement()) {
                    this.handleError("TermBinding expected to be element " + termStr + " but was " + termBinding);
                }
            }
            if (!xsElementName.equals(((ElementBinding)termBinding).getQName())) {
                this.handleError("Compared elements have different names: XSD QName is " + xsElementName + ", ElementBinding QName is " + ((ElementBinding)termBinding).getQName());
            }
        } else if (xsTermType == 9) {
            if (!termBinding.isWildcard()) {
                this.handleError("TermBinding expected to be a wildcard but was " + termBinding);
            }
            XSWildcard xsWildcard = (XSWildcard)xsTerm;
            WildcardBinding wildcardBinding = (WildcardBinding)termBinding;
            if (xsWildcard.getProcessContents() != wildcardBinding.getProcessContents()) {
                throw new IllegalStateException("Wildcard processContents doesn't match: XSD processContents is " + xsWildcard.getProcessContents() + ", WildcardBinding processContents is " + wildcardBinding.getProcessContents());
            }
            termStr = "wildcard";
        } else {
            this.handleError("Unexpected XSTerm type: " + xsTermType);
        }
        if (xsParticle.getMaxOccursUnbounded()) {
            if (!particleBinding.getMaxOccursUnbounded()) {
                this.handleError("XSD particle has maxOccurs unbounded but ParticleBinding of " + particleBinding.getTerm() + " does not.");
            }
        } else if (xsParticle.getMaxOccurs() != particleBinding.getMaxOccurs()) {
            this.handleError("maxOccurs for particle of " + particleBinding.getTerm() + " don't match: XSD maxOccurs=" + xsParticle.getMaxOccurs() + ", ParticleBinding maxOccurs=" + particleBinding.getMaxOccurs());
        }
    }

    public void validate(XSModelGroup xsModelGroup, ModelGroupBinding modelGroupBinding) {
        short xsCompositor = xsModelGroup.getCompositor();
        boolean all = false;
        if (xsCompositor == 1) {
            this.log("sequence");
            if (!(modelGroupBinding instanceof SequenceBinding)) {
                if (modelGroupBinding instanceof AllBinding || modelGroupBinding instanceof UnorderedSequenceBinding) {
                    all = true;
                } else {
                    this.handleError("ModelGroupBinding expected to be a sequence but was " + modelGroupBinding);
                }
            }
        } else if (xsCompositor == 2) {
            ParticleBinding particleBinding;
            Collection<ParticleBinding> particles;
            this.log("choice");
            if (modelGroupBinding instanceof SequenceBinding && (particles = modelGroupBinding.getParticles()).size() == 1 && (particleBinding = particles.iterator().next()).getTerm() instanceof ChoiceBinding) {
                modelGroupBinding = (ModelGroupBinding)particleBinding.getTerm();
            }
            if (!(modelGroupBinding instanceof ChoiceBinding)) {
                this.handleError("XSD model group is choice but ModelGroupBinding is " + modelGroupBinding);
            }
        } else if (xsCompositor == 3) {
            this.log("all");
            if (!(modelGroupBinding instanceof AllBinding)) {
                this.handleError("XSD model group is all but ModelGroupBinding is " + modelGroupBinding);
            }
            all = true;
        } else {
            this.handleError("Unexpected compositor type for model group " + xsCompositor);
        }
        XSObjectList xsParticles = xsModelGroup.getParticles();
        Collection<ParticleBinding> particleBindings = modelGroupBinding.getParticles();
        HashMap<QName, XSParticle> xsElementParticles = null;
        HashMap<QName, ParticleBinding> elementParticles = null;
        if (xsParticles.getLength() > 0) {
            if (particleBindings == null) {
                this.handleError("XSD model group has " + xsParticles.getLength() + " particles but ModelGroupBinding doesn't have any.");
            }
            if (xsParticles.getLength() != particleBindings.size() || all) {
                xsElementParticles = new HashMap<QName, XSParticle>();
                this.flatten(xsModelGroup, xsElementParticles);
                elementParticles = new HashMap<QName, ParticleBinding>();
                this.flatten(modelGroupBinding, elementParticles);
                if (xsElementParticles.size() != elementParticles.size()) {
                    if (this.isLoggingEnabled()) {
                        String msg = "expected particles:\n";
                        for (int i = 0; i < xsParticles.getLength(); ++i) {
                            XSTerm xsTerm = ((XSParticle)xsParticles.item(i)).getTerm();
                            short type = xsTerm.getType();
                            if (type == 7) {
                                short compositor = ((XSModelGroup)xsTerm).getCompositor();
                                if (compositor == 1) {
                                    msg = msg + "- sequence\n";
                                    continue;
                                }
                                if (compositor == 2) {
                                    msg = msg + "- choice\n";
                                    continue;
                                }
                                if (compositor != 3) continue;
                                msg = msg + "- all\n";
                                continue;
                            }
                            if (type == 2) {
                                XSElementDeclaration element = (XSElementDeclaration)xsTerm;
                                msg = msg + "- " + new QName(element.getNamespace(), element.getName()) + "\n";
                                continue;
                            }
                            msg = msg + "- wildcard\n";
                        }
                        msg = msg + "actual particles:\n";
                        Iterator<ParticleBinding> iter = particleBindings.iterator();
                        while (iter.hasNext()) {
                            TermBinding term = iter.next().getTerm();
                            if (term.isModelGroup()) {
                                if (term instanceof SequenceBinding) {
                                    msg = msg + "- sequence\n";
                                    continue;
                                }
                                if (term instanceof ChoiceBinding) {
                                    msg = msg + "- choice\n";
                                    continue;
                                }
                                msg = msg + "- wildcard\n";
                                continue;
                            }
                            if (term.isElement()) {
                                msg = msg + "- " + ((ElementBinding)term).getQName() + "\n";
                                continue;
                            }
                            msg = msg + "- wildcard";
                        }
                        this.log(msg);
                        ArrayList missing = new ArrayList(xsElementParticles.keySet());
                        missing.removeAll(elementParticles.keySet());
                        this.log("flattened ModelGroupBinding is missing: ");
                        Iterator missingNames = missing.iterator();
                        while (missingNames.hasNext()) {
                            this.log("- " + missingNames.next());
                        }
                        missing = new ArrayList(elementParticles.keySet());
                        missing.removeAll(xsElementParticles.keySet());
                        this.log("flattened XSModelGroup is missing: ");
                        missingNames = missing.iterator();
                        while (missingNames.hasNext()) {
                            this.log("- " + missingNames.next());
                        }
                    }
                    this.handleError("ModelGroupBinding expected to have " + xsParticles.getLength() + " particle(s) but has " + particleBindings.size());
                }
            }
        }
        if (xsElementParticles != null) {
            for (ParticleBinding particleBinding : elementParticles.values()) {
                TermBinding termBinding = particleBinding.getTerm();
                QName particleQName = termBinding.isWildcard() ? WILDCARD : ((ElementBinding)termBinding).getQName();
                XSParticle xsParticle = (XSParticle)xsElementParticles.get(particleQName);
                if (xsParticle == null) {
                    if (particleQName == WILDCARD) {
                        this.handleError("WildcardBinding is missing");
                    } else {
                        this.handleError("ElementBinding " + particleQName + " is missing: " + xsElementParticles.keySet());
                    }
                }
                this.validate(xsParticle, particleBinding);
            }
        } else {
            Iterator<ParticleBinding> iter = particleBindings.iterator();
            for (int i = 0; i < xsParticles.getLength(); ++i) {
                XSParticle xsParticle = (XSParticle)xsParticles.item(i);
                this.validate(xsParticle, iter.next());
            }
        }
    }

    private void flatten(XSModelGroup xsModelGroup, Map<QName, XSParticle> elementParticles) {
        XSObjectList xsParticles = xsModelGroup.getParticles();
        for (int i = 0; i < xsParticles.getLength(); ++i) {
            XSParticle particle = (XSParticle)xsParticles.item(i);
            XSTerm term = particle.getTerm();
            short termType = term.getType();
            if (termType == 2) {
                XSElementDeclaration element = (XSElementDeclaration)term;
                QName qName = new QName(element.getNamespace(), element.getName());
                elementParticles.put(qName, particle);
                continue;
            }
            if (termType == 9) {
                elementParticles.put(WILDCARD, particle);
                continue;
            }
            XSModelGroup modelGroup = (XSModelGroup)term;
            this.flatten(modelGroup, elementParticles);
        }
    }

    private void flatten(ModelGroupBinding group, Map<QName, ParticleBinding> elementParticles) {
        for (ParticleBinding particle : group.getParticles()) {
            TermBinding term = particle.getTerm();
            if (term.isElement()) {
                ElementBinding element = (ElementBinding)term;
                elementParticles.put(element.getQName(), particle);
                continue;
            }
            if (term.isWildcard()) {
                elementParticles.put(WILDCARD, particle);
                continue;
            }
            ModelGroupBinding modelGroup = (ModelGroupBinding)term;
            this.flatten(modelGroup, elementParticles);
        }
    }

    protected void handleError(String msg) {
        throw new IllegalStateException(msg);
    }

    protected void log(String msg) {
        if (this.loggingEnabled) {
            log.trace((Object)msg);
        }
    }
}

