/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jpa.impl.injection;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.jboss.jpa.impl.tx.TransactionScopedEntityManager;
import org.jboss.jpa.spi.PersistenceUnit;
import org.jboss.jpa.spi.PersistenceUnitRegistry;

public class InjectedEntityManagerFactory
implements EntityManagerFactory,
Externalizable {
    private static final long serialVersionUID = 1L;
    private transient EntityManagerFactory delegate;
    private transient PersistenceUnit persistenceUnit;

    public InjectedEntityManagerFactory() {
    }

    public InjectedEntityManagerFactory(PersistenceUnit persistenceUnit) {
        assert (persistenceUnit != null) : "persistenceUnit is null";
        this.delegate = persistenceUnit.getContainerEntityManagerFactory();
        this.persistenceUnit = persistenceUnit;
    }

    public EntityManagerFactory getDelegate() {
        return this.delegate;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.persistenceUnit.getName());
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        String kernelName = in.readUTF();
        this.persistenceUnit = PersistenceUnitRegistry.getPersistenceUnit((String)kernelName);
        if (this.persistenceUnit == null) {
            throw new IOException("Unable to find persistence unit in registry: " + kernelName);
        }
        this.delegate = this.persistenceUnit.getContainerEntityManagerFactory();
    }

    public EntityManager createEntityManager() {
        return this.getDelegate().createEntityManager();
    }

    public EntityManager createEntityManager(Map map) {
        return this.delegate.createEntityManager(map);
    }

    public EntityManager getEntityManager() {
        return new TransactionScopedEntityManager(this.persistenceUnit);
    }

    public void close() {
        throw new IllegalStateException("It is illegal to close an injected EntityManagerFactory");
    }

    public boolean isOpen() {
        return this.getDelegate().isOpen();
    }
}

