/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jpa.impl.tx;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import org.hibernate.Session;
import org.hibernate.ejb.HibernateEntityManager;
import org.jboss.jpa.spi.PersistenceUnit;
import org.jboss.jpa.spi.PersistenceUnitRegistry;
import org.jboss.jpa.spi.XPCResolver;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionScopedEntityManager
implements EntityManager,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(TransactionScopedEntityManager.class);
    private transient PersistenceUnit persistenceUnit;

    public Session getHibernateSession() {
        EntityManager em = this.persistenceUnit.getTransactionScopedEntityManager();
        if (em instanceof HibernateEntityManager) {
            return ((HibernateEntityManager)em).getSession();
        }
        throw new RuntimeException("ILLEGAL ACTION:  Not a Hibernate persistence provider");
    }

    public TransactionScopedEntityManager(PersistenceUnit persistenceUnit) {
        if (persistenceUnit == null) {
            throw new NullPointerException("persistenceUnit must not be null");
        }
        this.persistenceUnit = persistenceUnit;
    }

    public TransactionScopedEntityManager() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.persistenceUnit.getName());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        String kernelName = in.readUTF();
        this.persistenceUnit = PersistenceUnitRegistry.getPersistenceUnit((String)kernelName);
        if (this.persistenceUnit == null) {
            throw new IOException("Unable to find persistence unit in registry: " + kernelName);
        }
    }

    public Object getDelegate() {
        return this.getEntityManager().getDelegate();
    }

    public void joinTransaction() {
        this.persistenceUnit.verifyInTx();
        this.getEntityManager().joinTransaction();
    }

    public void clear() {
        this.getEntityManager().clear();
    }

    public FlushModeType getFlushMode() {
        return this.getEntityManager().getFlushMode();
    }

    public void lock(Object entity, LockModeType lockMode) {
        this.persistenceUnit.verifyInTx();
        this.getEntityManager().lock(entity, lockMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        EntityManager em = this.getEntityManager();
        if (!this.persistenceUnit.isInTx()) {
            em.clear();
        }
        try {
            Object object = em.getReference(entityClass, primaryKey);
            return (T)object;
        }
        finally {
            if (!this.persistenceUnit.isInTx()) {
                em.clear();
            }
        }
    }

    public void setFlushMode(FlushModeType flushMode) {
        this.getEntityManager().setFlushMode(flushMode);
    }

    public Query createQuery(String ejbqlString) {
        EntityManager em = this.getEntityManager();
        if (!this.persistenceUnit.isInTx()) {
            em.clear();
        }
        return em.createQuery(ejbqlString);
    }

    public Query createNamedQuery(String name) {
        EntityManager em = this.getEntityManager();
        if (!this.persistenceUnit.isInTx()) {
            em.clear();
        }
        return em.createNamedQuery(name);
    }

    public Query createNativeQuery(String sqlString) {
        EntityManager em = this.getEntityManager();
        if (!this.persistenceUnit.isInTx()) {
            em.clear();
        }
        return em.createNativeQuery(sqlString);
    }

    public Query createNativeQuery(String sqlString, Class resultClass) {
        EntityManager em = this.getEntityManager();
        if (!this.persistenceUnit.isInTx()) {
            em.clear();
        }
        return em.createNativeQuery(sqlString, resultClass);
    }

    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        EntityManager em = this.getEntityManager();
        if (!this.persistenceUnit.isInTx()) {
            em.clear();
        }
        return em.createNativeQuery(sqlString, resultSetMapping);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <A> A find(Class<A> entityClass, Object primaryKey) {
        EntityManager em = this.getEntityManager();
        if (!this.persistenceUnit.isInTx()) {
            em.clear();
        }
        try {
            Object object = em.find(entityClass, primaryKey);
            return (A)object;
        }
        finally {
            if (!this.persistenceUnit.isInTx()) {
                em.clear();
            }
        }
    }

    public void persist(Object entity) {
        this.persistenceUnit.verifyInTx();
        this.getEntityManager().persist(entity);
    }

    public <A> A merge(A entity) {
        this.persistenceUnit.verifyInTx();
        return (A)this.getEntityManager().merge(entity);
    }

    public void remove(Object entity) {
        this.persistenceUnit.verifyInTx();
        this.getEntityManager().remove(entity);
    }

    public void refresh(Object entity) {
        this.persistenceUnit.verifyInTx();
        this.getEntityManager().refresh(entity);
    }

    public boolean contains(Object entity) {
        return this.getEntityManager().contains(entity);
    }

    public void flush() {
        this.persistenceUnit.verifyInTx();
        this.getEntityManager().flush();
    }

    public void close() {
        throw new IllegalStateException("Illegal to call this method from injected, managed EntityManager");
    }

    public boolean isOpen() {
        throw new IllegalStateException("Illegal to call this method from injected, managed EntityManager");
    }

    public EntityTransaction getTransaction() {
        throw new IllegalStateException("Illegal to call this method from injected, managed EntityManager");
    }

    protected EntityManager getEntityManager() {
        String kernelName = this.persistenceUnit.getName();
        PersistenceUnit pu = PersistenceUnitRegistry.getPersistenceUnit((String)kernelName);
        XPCResolver xpcResolver = pu.getXPCResolver();
        EntityManager em = xpcResolver.getExtendedPersistenceContext(kernelName);
        if (em != null) {
            return em;
        }
        return this.persistenceUnit.getTransactionScopedEntityManager();
    }
}

