/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.javassist;

import java.lang.reflect.Array;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtPrimitiveType;
import org.jboss.reflect.plugins.javassist.JavassistTypeInfo;
import org.jboss.reflect.plugins.javassist.JavassistTypeInfoFactory;
import org.jboss.reflect.plugins.javassist.JavassistTypeInfoFactoryImpl;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.NotFoundException;
import org.jboss.reflect.spi.TypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavassistUtil {
    static ClassPool pool = ClassPool.getDefault();
    static ClassLoader loader = JavassistUtil.class.getClassLoader();

    public static Class<?> ctClassToClass(CtClass ct) {
        if (ct.isModified()) {
            try {
                ct.toClass();
            }
            catch (CannotCompileException e) {
                throw new org.jboss.reflect.spi.CannotCompileException(e.toString());
            }
        }
        try {
            if (ct.isArray()) {
                int dim = 0;
                while (ct.getComponentType() != null) {
                    ++dim;
                    ct = ct.getComponentType();
                }
                if (ct.isPrimitive()) {
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < dim; ++i) {
                        sb.append("[");
                    }
                    sb.append(((CtPrimitiveType)ct).getDescriptor());
                    try {
                        return loader.loadClass(sb.toString());
                    }
                    catch (ClassNotFoundException cnfe) {
                        return Class.forName(sb.toString(), false, loader);
                    }
                }
                return Array.newInstance(JavassistUtil.ctClassToClass(ct), new int[dim]).getClass();
            }
            return loader.loadClass(ct.getName());
        }
        catch (javassist.NotFoundException e) {
            throw new NotFoundException(e.toString());
        }
        catch (ClassNotFoundException e) {
            try {
                return ct.toClass();
            }
            catch (CannotCompileException e1) {
                throw new org.jboss.reflect.spi.CannotCompileException(e1.toString());
            }
        }
    }

    public static CtClass toCtClass(String name) {
        try {
            return pool.get(name);
        }
        catch (javassist.NotFoundException e) {
            throw new NotFoundException(e.toString());
        }
    }

    public static CtClass[] toCtClass(String[] names) {
        if (names == null) {
            return new CtClass[0];
        }
        CtClass[] classes = new CtClass[names.length];
        for (int i = 0; i < names.length; ++i) {
            classes[i] = JavassistUtil.toCtClass(names[i]);
        }
        return classes;
    }

    public static CtClass toCtClass(ClassInfo clazz) {
        if (clazz instanceof JavassistTypeInfo) {
            return ((JavassistTypeInfo)clazz).getCtClass();
        }
        try {
            ClassLoader classLoader = clazz.getClassLoader();
            ClassPool classPool = JavassistTypeInfoFactoryImpl.getPoolFactory().getPoolForLoader(classLoader);
            return classPool.get(clazz.getName());
        }
        catch (javassist.NotFoundException e) {
            throw new NotFoundException(e.toString());
        }
    }

    public static TypeInfo toTypeInfo(CtClass ctClass) {
        JavassistTypeInfoFactoryImpl impl = JavassistTypeInfoFactory.delegate;
        return impl.get(ctClass, null);
    }

    public static CtClass[] toCtClass(ClassInfo[] classes) {
        CtClass[] clazzes = new CtClass[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            clazzes[i] = JavassistUtil.toCtClass(classes[i]);
        }
        return clazzes;
    }

    static ClassLoader getClassLoader(CtClass ctClass) {
        ClassPool pool = ctClass.getClassPool();
        return pool != null ? pool.getClassLoader() : null;
    }
}

