/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.interceptors.aop;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import org.jboss.aop.Domain;
import org.jboss.ejb3.interceptors.lang.BootstrapClassLoader;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainClassLoader
extends ClassLoader {
    private static final Logger log = Logger.getLogger(DomainClassLoader.class);
    private ClassLoader delegate;
    private ClassLoader bootstrapClassLoader = new BootstrapClassLoader();
    private Domain domain;

    public DomainClassLoader(ClassLoader parent, ClassLoader delegate, Domain domain) {
        super(parent);
        assert (delegate != null) : "delegate is null";
        assert (domain != null) : "domain is null";
        this.delegate = delegate;
        this.domain = domain;
    }

    private Class<?> defineClassFromBytes(String name, ClassBytes bytes, boolean resolve) {
        this.definePackage(name);
        byte[] b = bytes.bytes;
        Class<?> clazz = this.defineClass(name, b, 0, b.length, bytes.protectionDomain);
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    private void definePackage(String className) {
        int i = className.lastIndexOf(46);
        if (i == -1) {
            return;
        }
        try {
            this.definePackage(className.substring(0, i), null, null, null, null, null, null, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private ClassLoader getDelegate() {
        return this.delegate;
    }

    public Domain getDomain() {
        return this.domain;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz;
        if (log.isTraceEnabled()) {
            log.trace((Object)("loadClass " + name));
        }
        if ((clazz = this.findLoadedClass(name)) != null) {
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        try {
            clazz = this.bootstrapClassLoader.loadClass(name);
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        catch (ClassNotFoundException e) {
            log.trace((Object)("Can't find class '" + name + "' in bootstrap."));
            String classFileName = name.replace('.', '/') + ".class";
            URL url = this.getDelegate().getResource(classFileName);
            if (url == null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Did not find an url for '" + name + "'."));
                }
                clazz = this.getParent().loadClass(name);
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
            log.debug((Object)(name + " found on " + url));
            try {
                ClassBytes origBytes = this.loadClassBytes(name, classFileName, url);
                ClassBytes classBytes = new ClassBytes();
                assert (!name.startsWith("org.jboss.aop")) : "We should not have found a valid url";
                classBytes.bytes = this.domain.transform((ClassLoader)this, name, null, origBytes.protectionDomain, origBytes.bytes);
                classBytes.protectionDomain = origBytes.protectionDomain;
                if (classBytes.bytes == null) {
                    classBytes = origBytes;
                }
                Class<?> cls = this.defineClassFromBytes(name, classBytes, resolve);
                if (resolve) {
                    this.resolveClass(cls);
                }
                return cls;
            }
            catch (ClassNotFoundException e2) {
                log.warn((Object)("Unable to instrument '" + name + "'"), (Throwable)e2);
                return super.loadClass(name, resolve);
            }
            catch (IOException ioe) {
                throw new ClassNotFoundException("Unable to load " + name, ioe);
            }
            catch (IllegalAccessException iae) {
                throw new Error(iae);
            }
            catch (Exception e3) {
                throw new Error("Error transforming the class " + name, e3);
            }
        }
    }

    private ClassBytes loadClassBytes(String name, final String classFileName, final URL url) throws ClassNotFoundException, IOException {
        ProtectionDomain protectionDomain = null;
        InputStream in = null;
        if (url != null) {
            String cs;
            int i;
            try {
                in = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                    @Override
                    public InputStream run() throws Exception {
                        return url.openStream();
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw new ClassNotFoundException(name, e);
            }
            String urlstring = url.toExternalForm();
            URL urlCS = url;
            if (urlstring.startsWith("jar:")) {
                i = urlstring.indexOf(33);
                cs = urlstring.substring(4, i);
                urlCS = new URL(cs);
            } else {
                i = urlstring.indexOf(classFileName);
                if (i != -1) {
                    cs = urlstring.substring(0, i);
                    urlCS = new URL(cs);
                }
            }
            CodeSource codeSource = new CodeSource(urlCS, (Certificate[])null);
            protectionDomain = new ProtectionDomain(codeSource, null, this, null);
        } else {
            try {
                in = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                    @Override
                    public InputStream run() throws Exception {
                        String tmpdir = System.getProperty("java.io.tmpdir");
                        File aopdynclasses = new File(tmpdir, "aopdynclasses");
                        File classFile = new File(aopdynclasses, classFileName);
                        return new FileInputStream(classFile);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw new ClassNotFoundException(name, e);
            }
        }
        byte[][] bufs = new byte[8][];
        int bufsize = 4096;
        for (int i = 0; i < 8; ++i) {
            bufs[i] = new byte[bufsize];
            int size = 0;
            int len = 0;
            do {
                if ((len = in.read(bufs[i], size, bufsize - size)) >= 0) continue;
                byte[] result = new byte[bufsize - 4096 + size];
                int s = 0;
                for (int j = 0; j < i; ++j) {
                    System.arraycopy(bufs[j], 0, result, s, s + 4096);
                    s = s + s + 4096;
                }
                System.arraycopy(bufs[i], 0, result, s, size);
                ClassBytes classBytes = new ClassBytes();
                classBytes.bytes = result;
                classBytes.protectionDomain = protectionDomain;
                return classBytes;
            } while ((size += len) < bufsize);
            bufsize *= 2;
        }
        throw new IOException("too much data loading class " + name);
    }

    private static class ClassBytes {
        public ProtectionDomain protectionDomain;
        public byte[] bytes;

        private ClassBytes() {
        }
    }
}

