/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.blobholder;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.BlobHolderAdapterService;
import org.nuxeo.ecm.core.api.blobholder.BlobHolderFactory;
import org.nuxeo.ecm.core.api.blobholder.BlobHolderFactoryDescriptor;
import org.nuxeo.ecm.core.api.blobholder.DocumentBlobHolder;
import org.nuxeo.ecm.core.api.blobholder.DocumentStringBlobHolder;
import org.nuxeo.ecm.core.api.externalblob.ExternalBlobAdapter;
import org.nuxeo.ecm.core.api.externalblob.ExternalBlobAdapterDescriptor;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class BlobHolderAdapterComponent
extends DefaultComponent
implements BlobHolderAdapterService {
    private static final Log log = LogFactory.getLog(BlobHolderAdapterComponent.class);
    public static final String BLOBHOLDERFACTORY_EP = "BlobHolderFactory";
    public static final String EXTERNALBLOB_ADAPTER_EP = "ExternalBlobAdapter";
    protected static final Map<String, BlobHolderFactory> factories = new HashMap<String, BlobHolderFactory>();
    protected static final Map<String, ExternalBlobAdapter> externalBlobAdapters = new HashMap<String, ExternalBlobAdapter>();

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (BLOBHOLDERFACTORY_EP.equals(extensionPoint)) {
            BlobHolderFactoryDescriptor desc = (BlobHolderFactoryDescriptor)contribution;
            factories.put(desc.getDocType(), desc.getFactory());
        } else if (EXTERNALBLOB_ADAPTER_EP.equals(extensionPoint)) {
            ExternalBlobAdapterDescriptor desc = (ExternalBlobAdapterDescriptor)contribution;
            ExternalBlobAdapter adapter = desc.getAdapter();
            String prefix = desc.getPrefix();
            if (externalBlobAdapters.containsKey(prefix)) {
                log.info((Object)String.format("Overriding external blob adapter with prefix '%s'", prefix));
                externalBlobAdapters.remove(prefix);
            }
            adapter.setPrefix(desc.getPrefix());
            adapter.setProperties(desc.getProperties());
            externalBlobAdapters.put(desc.getPrefix(), adapter);
            log.info((Object)String.format("Registered external blob adapter with prefix '%s'", prefix));
        } else {
            log.error((Object)("Unknown extension point " + extensionPoint));
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
    }

    public static Set<String> getFactoryNames() {
        return factories.keySet();
    }

    @Override
    public ExternalBlobAdapter getExternalBlobAdapterForPrefix(String prefix) {
        return externalBlobAdapters.get(prefix);
    }

    @Override
    public ExternalBlobAdapter getExternalBlobAdapterForUri(String uri) {
        if (uri != null && uri.contains(":")) {
            String prefix = uri.substring(0, uri.indexOf(":"));
            return this.getExternalBlobAdapterForPrefix(prefix);
        }
        return null;
    }

    @Override
    public Blob getExternalBlobForUri(String uri) throws PropertyException {
        ExternalBlobAdapter adapter = this.getExternalBlobAdapterForUri(uri);
        if (adapter == null) {
            throw new PropertyException(String.format("No external blob adapter found for uri '%s'", uri));
        }
        return adapter.getBlob(uri);
    }

    @Override
    public BlobHolder getBlobHolderAdapter(DocumentModel doc) {
        if (factories.containsKey(doc.getType())) {
            BlobHolderFactory factory = factories.get(doc.getType());
            return factory.getBlobHolder(doc);
        }
        if (doc.hasSchema("file")) {
            return new DocumentBlobHolder(doc, "file:content", "file:filename");
        }
        if (doc.hasSchema("note")) {
            try {
                String mt = null;
                try {
                    String note;
                    mt = (String)((Object)doc.getPropertyValue("note:mime_type"));
                    if (mt == null && (note = (String)((Object)doc.getPropertyValue("note:note"))) != null && !"".equals(note)) {
                        mt = "text/plain";
                    }
                }
                catch (PropertyException propertyException) {
                    // empty catch block
                }
                return new DocumentStringBlobHolder(doc, "note:note", mt);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        return null;
    }
}

