/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.impl;

import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PathRef;

public class DocumentLocationImpl
implements DocumentLocation {
    private static final long serialVersionUID = -1109935626596128985L;
    private final String serverName;
    private final DocumentRef docRef;
    private final IdRef docIdRef;
    private final PathRef docPathRef;

    public DocumentLocationImpl(DocumentModel doc) {
        this.serverName = doc.getRepositoryName();
        this.docRef = doc.getRef();
        String id = doc.getId();
        this.docIdRef = id != null ? new IdRef(id) : null;
        String path = doc.getPathAsString();
        this.docPathRef = path != null ? new PathRef(path) : null;
    }

    public DocumentLocationImpl(String serverName, IdRef idRef, PathRef pathRef) {
        this.serverName = serverName;
        this.docRef = idRef;
        this.docIdRef = idRef;
        this.docPathRef = pathRef;
    }

    public DocumentLocationImpl(String serverName, DocumentRef docRef) {
        this.serverName = serverName;
        this.docRef = docRef;
        if (docRef instanceof IdRef) {
            this.docIdRef = (IdRef)docRef;
            this.docPathRef = null;
        } else if (docRef instanceof PathRef) {
            this.docIdRef = null;
            this.docPathRef = (PathRef)docRef;
        } else {
            this.docIdRef = null;
            this.docPathRef = null;
        }
    }

    @Override
    public DocumentRef getDocRef() {
        return this.docRef;
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    @Override
    public IdRef getIdRef() {
        return this.docIdRef;
    }

    @Override
    public PathRef getPathRef() {
        return this.docPathRef;
    }

    public String toString() {
        return String.format("DocumentLocationImpl [docIdRef=%s, docPathRef=%s, docRef=%s, serverName=%s]", this.docIdRef, this.docPathRef, this.docRef, this.serverName);
    }
}

