/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.model.impl;

import java.util.Hashtable;
import java.util.Map;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyFactory;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Type;

public class CompositePropertyFactory
implements PropertyFactory {
    protected final Map<String, PropertyFactory> factories = new Hashtable<String, PropertyFactory>();
    protected final PropertyFactory defaultFactory;

    public CompositePropertyFactory(PropertyFactory defaultFactory) {
        this.defaultFactory = defaultFactory;
    }

    public void registerFactory(String type, PropertyFactory factory) {
        this.factories.put(type, factory);
    }

    public void registerFactory(String schema, String type, PropertyFactory factory) {
        if (schema == null) {
            this.factories.put(type, factory);
        } else {
            this.factories.put(schema + ':' + type, factory);
        }
    }

    public PropertyFactory getFactory(String type) {
        return this.factories.get(type);
    }

    public PropertyFactory getFactory(String schema, String type) {
        String key = schema + ':' + type;
        PropertyFactory factory = this.factories.get(key);
        if (factory == null) {
            factory = this.factories.get(type);
            this.factories.put(key, factory);
        }
        return factory;
    }

    @Override
    public Property createProperty(Property parent, Field field, int flags) {
        Type type = field.getType();
        PropertyFactory factory = this.getFactory(type.getSchemaName(), type.getName());
        if (factory != null) {
            return factory.createProperty(parent, field, flags);
        }
        return this.defaultFactory.createProperty(parent, field, flags);
    }
}

