/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.model.impl;

import org.nuxeo.ecm.core.api.model.DocumentPart;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyFactory;
import org.nuxeo.ecm.core.api.model.impl.ArrayProperty;
import org.nuxeo.ecm.core.api.model.impl.CompositePropertyFactory;
import org.nuxeo.ecm.core.api.model.impl.DocumentPartImpl;
import org.nuxeo.ecm.core.api.model.impl.ListProperty;
import org.nuxeo.ecm.core.api.model.impl.MapProperty;
import org.nuxeo.ecm.core.api.model.impl.ScalarProperty;
import org.nuxeo.ecm.core.api.model.impl.primitives.BinaryProperty;
import org.nuxeo.ecm.core.api.model.impl.primitives.BlobProperty;
import org.nuxeo.ecm.core.api.model.impl.primitives.BooleanProperty;
import org.nuxeo.ecm.core.api.model.impl.primitives.DateProperty;
import org.nuxeo.ecm.core.api.model.impl.primitives.DoubleProperty;
import org.nuxeo.ecm.core.api.model.impl.primitives.ExternalBlobProperty;
import org.nuxeo.ecm.core.api.model.impl.primitives.LongProperty;
import org.nuxeo.ecm.core.api.model.impl.primitives.StringProperty;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.runtime.api.Framework;

public class DefaultPropertyFactory
extends CompositePropertyFactory {
    private static DefaultPropertyFactory instance;
    public static final PropertyFactory DEFAULT;
    public static final PropertyFactory STRING;
    public static final PropertyFactory INTEGER;
    public static final PropertyFactory DOUBLE;
    public static final PropertyFactory DATE;
    public static final PropertyFactory BOOLEAN;
    public static final PropertyFactory BINARY;
    public static final PropertyFactory BLOB;
    public static final PropertyFactory EXTERNAL_BLOB;

    public static DefaultPropertyFactory getInstance() {
        if (instance == null) {
            instance = new DefaultPropertyFactory();
            instance.registerFactory("string", STRING);
            instance.registerFactory("long", INTEGER);
            instance.registerFactory("integer", INTEGER);
            instance.registerFactory("double", DOUBLE);
            instance.registerFactory("boolean", BOOLEAN);
            instance.registerFactory("date", DATE);
            instance.registerFactory("binary", BINARY);
            instance.registerFactory("content", BLOB);
            instance.registerFactory("externalcontent", EXTERNAL_BLOB);
        }
        return instance;
    }

    private DefaultPropertyFactory() {
        super(DEFAULT);
    }

    public void unregisterFactory(String schema, String type) {
        if (schema == null) {
            this.factories.remove(type);
        } else {
            this.factories.remove(schema + ':' + type);
        }
    }

    @Override
    public PropertyFactory getFactory(String schema, String type) {
        String key = schema + ':' + type;
        PropertyFactory factory = (PropertyFactory)this.factories.get(key);
        if (factory == null && (factory = (PropertyFactory)this.factories.get(type)) != null) {
            this.factories.put(key, factory);
        }
        return factory;
    }

    public static DocumentPart newDocumentPart(Schema schema) {
        return new DocumentPartImpl(schema);
    }

    public static DocumentPart newDocumentPart(String schemaName) {
        SchemaManager mgr = (SchemaManager)Framework.getLocalService(SchemaManager.class);
        Schema schema = mgr != null ? mgr.getSchema(schemaName) : null;
        return DefaultPropertyFactory.newDocumentPart(schema);
    }

    public static Property newMapProperty(Property parent, Field field) {
        return new MapProperty(parent, field);
    }

    public static Property newMapProperty(Property parent, Field field, int flags) {
        return new MapProperty(parent, field, flags);
    }

    public static Property newListProperty(Property parent, Field field) {
        return new ListProperty(parent, field);
    }

    public static Property newListProperty(Property parent, Field field, int flags) {
        return new ListProperty(parent, field, flags);
    }

    public static Property newScalarProperty(Property parent, Field field) {
        return new ScalarProperty(parent, field);
    }

    public static Property newScalarProperty(Property parent, Field field, int flags) {
        return new ScalarProperty(parent, field, flags);
    }

    public static Property newArrayProperty(Property parent, Field field, int flags) {
        return new ArrayProperty(parent, field, flags);
    }

    public static Property newProperty(Property parent, Field field, int flags) {
        Property property;
        Type type = field.getType();
        if (type.isSimpleType()) {
            property = DefaultPropertyFactory.newScalarProperty(parent, field, flags);
        } else if (type.isComplexType()) {
            property = DefaultPropertyFactory.newMapProperty(parent, field, flags);
        } else if (type.isListType()) {
            ListType ltype = (ListType)type;
            property = ltype.isArray() ? DefaultPropertyFactory.newArrayProperty(parent, field, flags) : DefaultPropertyFactory.newListProperty(parent, field, flags);
        } else {
            throw new IllegalArgumentException("Given field type is unsupported: " + field.getType().getName());
        }
        return property;
    }

    static {
        DEFAULT = new PropertyFactory(){

            @Override
            public Property createProperty(Property parent, Field field, int flags) {
                return DefaultPropertyFactory.newProperty(parent, field, flags);
            }
        };
        STRING = new PropertyFactory(){

            @Override
            public Property createProperty(Property parent, Field field, int flags) {
                return new StringProperty(parent, field, flags);
            }
        };
        INTEGER = new PropertyFactory(){

            @Override
            public Property createProperty(Property parent, Field field, int flags) {
                return new LongProperty(parent, field, flags);
            }
        };
        DOUBLE = new PropertyFactory(){

            @Override
            public Property createProperty(Property parent, Field field, int flags) {
                return new DoubleProperty(parent, field, flags);
            }
        };
        DATE = new PropertyFactory(){

            @Override
            public Property createProperty(Property parent, Field field, int flags) {
                return new DateProperty(parent, field, flags);
            }
        };
        BOOLEAN = new PropertyFactory(){

            @Override
            public Property createProperty(Property parent, Field field, int flags) {
                return new BooleanProperty(parent, field, flags);
            }
        };
        BINARY = new PropertyFactory(){

            @Override
            public Property createProperty(Property parent, Field field, int flags) {
                return new BinaryProperty(parent, field, flags);
            }
        };
        BLOB = new PropertyFactory(){

            @Override
            public Property createProperty(Property parent, Field field, int flags) {
                return new BlobProperty(parent, field, flags);
            }
        };
        EXTERNAL_BLOB = new PropertyFactory(){

            @Override
            public Property createProperty(Property parent, Field field, int flags) {
                return new ExternalBlobProperty(parent, field, flags);
            }
        };
    }
}

