/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.repository;

import java.io.Serializable;
import java.security.Principal;
import java.util.HashMap;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.impl.UserPrincipal;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryInstanceHandler;
import org.nuxeo.runtime.api.Framework;

public class LocalRepositoryInstanceHandler
extends RepositoryInstanceHandler {
    private static final long serialVersionUID = 1L;
    protected final Principal principal;

    public LocalRepositoryInstanceHandler(Repository repository, NuxeoPrincipal principal) {
        super(repository);
        this.principal = principal;
    }

    public LocalRepositoryInstanceHandler(Repository repository, String username) {
        this(repository, new UserPrincipal(username));
    }

    @Override
    protected void open(Repository repository) throws Exception {
        this.session = (CoreSession)Framework.getLocalService(CoreSession.class);
        String repositoryUri = repository.getRepositoryUri();
        if (repositoryUri == null) {
            repositoryUri = repository.getName();
        }
        HashMap<String, Serializable> ctx = new HashMap<String, Serializable>();
        ctx.put("principal", (NuxeoPrincipal)this.principal);
        String sid = this.session.connect(repositoryUri, ctx);
        CoreInstance.getInstance().registerSession(sid, this.proxy);
    }
}

