/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.runtime.api.Framework;

public class BlobsExtractor {
    protected static final Log log = LogFactory.getLog(BlobsExtractor.class);
    protected final Map<String, Map<String, List<String>>> blobFieldPaths = new HashMap<String, Map<String, List<String>>>();
    protected List<String> docTypeCached = new ArrayList<String>();
    protected SchemaManager schemaManager;
    private Set<String> pathProperties;
    private Set<String> excludedPathProperties;
    private boolean indexAllBinary = false;
    private boolean isDefaultConfiguration = true;

    protected SchemaManager getSchemaManager() throws Exception {
        if (this.schemaManager == null) {
            this.schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
        }
        return this.schemaManager;
    }

    public List<Property> getBlobsProperties(DocumentModel doc) throws Exception {
        ArrayList<Property> result = new ArrayList<Property>();
        for (String schema : this.getBlobFieldPathForDocumentType(doc.getType()).keySet()) {
            List<String> pathsList = this.getBlobFieldPathForDocumentType(doc.getType()).get(schema);
            for (String path : pathsList) {
                if (!this.isInterestingBlobProperty(path, this.schemaManager.getSchema((String)schema).getNamespace().prefix)) continue;
                List<String> pathSplitted = Arrays.asList(path.split("/[*]/"));
                if (pathSplitted.size() == 0) {
                    throw new IllegalStateException("Path detected not wellformed: " + pathsList);
                }
                Property prop = doc.getProperty(schema + ":" + pathSplitted.get(0));
                if (pathSplitted.size() < 1) continue;
                List<String> subPath = pathSplitted.subList(1, pathSplitted.size());
                this.getBlobValue(prop, subPath, path, result);
            }
        }
        return result;
    }

    public Map<String, List<String>> getBlobFieldPathForDocumentType(String documentType) throws Exception {
        DocumentType docType = this.getSchemaManager().getDocumentType(documentType);
        if (!this.docTypeCached.contains(documentType)) {
            HashMap paths = new HashMap();
            this.blobFieldPaths.put(docType.getName(), paths);
            this.createCacheForDocumentType(docType);
        }
        return this.blobFieldPaths.get(documentType);
    }

    public void invalidateDocumentTypeCache(String docType) {
        if (this.docTypeCached.contains(docType)) {
            this.docTypeCached.remove(docType);
        }
    }

    public void invalidateCache() {
        this.docTypeCached = new ArrayList<String>();
    }

    protected void createCacheForDocumentType(DocumentType docType) throws Exception {
        for (Schema schema : docType.getSchemas()) {
            this.findInteresting(docType, schema, "", (ComplexType)schema);
        }
        if (!this.docTypeCached.contains(docType.getName())) {
            this.docTypeCached.add(docType.getName());
        }
    }

    protected boolean findInteresting(DocumentType docType, Schema schema, String path, ComplexType ct) throws Exception {
        boolean interesting = false;
        for (Field field : ct.getFields()) {
            String blobMatchedPath;
            Type type = field.getType();
            if (type.isSimpleType()) continue;
            if (type.isListType()) {
                Type ftype = ((ListType)type).getField().getType();
                if (!ftype.isComplexType()) continue;
                blobMatchedPath = path + String.format("/%s/*", field.getName().getLocalName());
                if ("*".equals(field.getName())) {
                    throw new Exception("A field can't be named '*' please check this field: " + path);
                }
                if (!this.findInteresting(docType, schema, blobMatchedPath, (ComplexType)ftype)) continue;
                this.containsBlob(docType, schema, blobMatchedPath, field);
                interesting |= true;
                continue;
            }
            ComplexType ctype = (ComplexType)type;
            if (type.getName().equals("content")) {
                blobMatchedPath = path + String.format("/%s", field.getName().getLocalName());
                this.blobMatched(docType, schema, blobMatchedPath, field);
                interesting = true;
                continue;
            }
            blobMatchedPath = path + String.format("/%s", field.getName().getLocalName());
            interesting |= this.findInteresting(docType, schema, blobMatchedPath, ctype);
        }
        if (interesting) {
            this.containsBlob(docType, schema, path, null);
        }
        return interesting;
    }

    protected void blobMatched(DocumentType docType, Schema schema, String path, Field field) {
        Map<String, List<String>> blobPathsForDocType = this.blobFieldPaths.get(docType.getName());
        List<String> pathsList = blobPathsForDocType.get(schema.getName());
        if (pathsList == null) {
            pathsList = new ArrayList<String>();
            blobPathsForDocType.put(schema.getName(), pathsList);
            this.blobFieldPaths.put(docType.getName(), blobPathsForDocType);
        }
        pathsList.add(path);
    }

    protected void containsBlob(DocumentType docType, Schema schema, String path, Field field) {
    }

    protected void getBlobValue(Property prop, List<String> subPath, String completePath, List<Property> result) throws Exception {
        if (subPath.size() == 0) {
            if (!(prop.getValue() instanceof Blob)) {
                log.debug((Object)("Path Field not contains a blob value: " + completePath));
                return;
            }
            result.add(prop);
            return;
        }
        for (Property childProp : prop.getChildren()) {
            if ("/*".equals(subPath.get(0))) {
                log.debug((Object)("TODO : BLOB IN A LIST NOT IMPLEMENTED for this path " + completePath));
            }
            Property childSubProp = childProp.get(subPath.get(0));
            this.getBlobValue(childSubProp, subPath.subList(1, subPath.size()), completePath, result);
        }
    }

    public List<Blob> getBlobs(DocumentModel doc) throws ClientException {
        ArrayList<Blob> result = new ArrayList<Blob>();
        try {
            for (Property blobField : this.getBlobsProperties(doc)) {
                Blob blob = (Blob)((Object)blobField.getValue());
                result.add(blob);
            }
        }
        catch (Exception e) {
            throw new ClientException(e);
        }
        return result;
    }

    public void setExtractorProperties(Set<String> pathProps, Set<String> excludedPathProps, boolean indexBlobs) {
        this.pathProperties = pathProps;
        this.excludedPathProperties = excludedPathProps;
        this.indexAllBinary = indexBlobs;
        this.isDefaultConfiguration = pathProps == null && excludedPathProps == null && Boolean.TRUE.equals(indexBlobs);
    }

    private boolean isInterestingBlobProperty(String path, String prefix) {
        if (this.isDefaultConfiguration) {
            return true;
        }
        if (this.pathProperties != null && this.matchProperty(prefix, path, this.pathProperties)) {
            return true;
        }
        if (this.excludedPathProperties != null && this.matchProperty(prefix, path, this.excludedPathProperties)) {
            return false;
        }
        return Boolean.TRUE.equals(this.indexAllBinary);
    }

    private boolean matchProperty(String prefix, String fieldPath, Set<String> propPaths) {
        String pathToMatch = (prefix == "" ? "" : prefix + ":") + fieldPath.substring(1);
        for (String propPath : propPaths) {
            if (!propPath.startsWith(pathToMatch)) continue;
            return true;
        }
        return false;
    }
}

