/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.AbstractSession;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocsQueryProvider;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.impl.DocsQueryProviderDef;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.model.DocumentIterator;
import org.nuxeo.ecm.core.query.Query;
import org.nuxeo.ecm.core.query.QueryException;

final class DocsQueryProviderFactory {
    private static final Log log = LogFactory.getLog(DocsQueryProviderFactory.class);
    private final AbstractSession session;

    DocsQueryProviderFactory(AbstractSession session) {
        this.session = session;
    }

    public DocsQueryProvider getDQLbyType(DocsQueryProviderDef dqpDef) throws ClientException {
        DocsQueryProvider dqp;
        try {
            switch (dqpDef.getType()) {
                case TYPE_CHILDREN: {
                    dqp = this.getDQPChildren(dqpDef.getParent());
                    break;
                }
                case TYPE_CHILDREN_NON_FOLDER: {
                    dqp = this.getDQPChildrenNonFolder(dqpDef.getParent());
                    break;
                }
                case TYPE_CHILDREN_FOLDERS: {
                    dqp = this.getDQPChildrenFolder(dqpDef.getParent());
                    break;
                }
                case TYPE_QUERY: {
                    dqp = this.getDQPQueryResult(dqpDef.getQuery());
                    break;
                }
                case TYPE_QUERY_FTS: {
                    dqp = this.getDQPQueryFtsResult(dqpDef.getQuery(), dqpDef.getStartingPath());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("cannot get here");
                }
            }
        }
        catch (DocumentException e) {
            throw new ClientException("DocumentException", (Throwable)e);
        }
        return dqp;
    }

    private DocsQueryProvider getDQPQueryResult(String query) throws ClientException {
        Query compiledQuery;
        try {
            compiledQuery = this.session.getSession().createQuery(query, Query.Type.NXQL, new String[0]);
        }
        catch (QueryException e1) {
            throw new ClientException("qe", (Throwable)e1);
        }
        return new DocsQueryProvider(){

            @Override
            public DocumentIterator getDocs(int start) throws ClientException {
                DocumentIterator documents;
                try {
                    documents = (DocumentIterator)compiledQuery.execute().getDocuments(start);
                }
                catch (QueryException e) {
                    throw new ClientException("Query exception, ", (Throwable)e);
                }
                return documents;
            }

            @Override
            public boolean accept(Document child) {
                return true;
            }
        };
    }

    private DocsQueryProvider getDQPQueryFtsResult(String keywords, String startingPath) throws ClientException {
        Query compiledQuery;
        StringBuffer xpathPrefix = new StringBuffer("//");
        String[] pathElements = new String[]{};
        if (startingPath != null) {
            for (String element : pathElements = startingPath.split("\\/")) {
                xpathPrefix.append("?/");
            }
        }
        String xpathQ = xpathPrefix + "element(*, ecmnt:document)[jcr:contains(.,'*?*')]";
        String[] params = new String[pathElements.length + 1];
        System.arraycopy(pathElements, 0, params, 0, pathElements.length);
        params[params.length - 1] = keywords;
        try {
            compiledQuery = this.session.getSession().createQuery(xpathQ, Query.Type.XPATH, params);
        }
        catch (QueryException e) {
            log.error((Object)("Error executing xpath query: " + xpathQ), (Throwable)e);
            throw new ClientException("qe", (Throwable)e);
        }
        DocsQueryProvider dqProvider = new DocsQueryProvider(){

            @Override
            public DocumentIterator getDocs(int start) throws ClientException {
                DocumentIterator documents;
                try {
                    documents = (DocumentIterator)compiledQuery.execute().getDocuments(start);
                }
                catch (QueryException e) {
                    throw new ClientException("Query exception, ", (Throwable)e);
                }
                return documents;
            }

            @Override
            public boolean accept(Document child) {
                return true;
            }
        };
        return dqProvider;
    }

    private DocsQueryProvider getDQPChildren(DocumentRef parent) throws DocumentException, ClientException {
        final Document doc = this.session.resolveReference(parent);
        this.session.checkPermission(doc, "ReadChildren");
        DocsQueryProvider dqProvider = new DocsQueryProvider(){

            @Override
            public DocumentIterator getDocs(int start) throws ClientException {
                DocumentIterator children;
                try {
                    children = doc.getChildren(start);
                }
                catch (DocumentException e) {
                    throw new ClientException("DocumentException", (Throwable)e);
                }
                return children;
            }

            @Override
            public boolean accept(Document child) {
                return true;
            }
        };
        return dqProvider;
    }

    private DocsQueryProvider getDQPChildrenNonFolder(DocumentRef parent) throws DocumentException, ClientException {
        final Document doc = this.session.resolveReference(parent);
        this.session.checkPermission(doc, "ReadChildren");
        DocsQueryProvider dqProvider = new DocsQueryProvider(){

            @Override
            public DocumentIterator getDocs(int start) throws ClientException {
                DocumentIterator children;
                try {
                    children = doc.getChildren(start);
                }
                catch (DocumentException e) {
                    throw new ClientException("DocumentException", (Throwable)e);
                }
                return children;
            }

            @Override
            public boolean accept(Document child) throws ClientException {
                try {
                    return !child.isFolder() && DocsQueryProviderFactory.this.session.hasPermission(child, "Read");
                }
                catch (DocumentException e) {
                    throw new ClientException("DocumentException", (Throwable)e);
                }
            }
        };
        return dqProvider;
    }

    private DocsQueryProvider getDQPChildrenFolder(DocumentRef parent) throws DocumentException, ClientException {
        final Document doc = this.session.resolveReference(parent);
        this.session.checkPermission(doc, "ReadChildren");
        DocsQueryProvider dqProvider = new DocsQueryProvider(){

            @Override
            public DocumentIterator getDocs(int start) throws ClientException {
                DocumentIterator childrenIt;
                try {
                    childrenIt = doc.getChildren(start);
                }
                catch (DocumentException e) {
                    throw new ClientException("DocumentException", (Throwable)e);
                }
                return childrenIt;
            }

            @Override
            public boolean accept(Document child) throws ClientException {
                try {
                    return child.isFolder() && DocsQueryProviderFactory.this.session.hasPermission(child, "Read");
                }
                catch (DocumentException e) {
                    throw new ClientException("DocumentException", (Throwable)e);
                }
            }
        };
        return dqProvider;
    }
}

