/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.versioning;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.versioning.StandardVersioningService;
import org.nuxeo.ecm.core.versioning.VersioningService;
import org.nuxeo.ecm.core.versioning.VersioningServiceDescriptor;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class VersioningComponent
extends DefaultComponent
implements VersioningService {
    private static final Log log = LogFactory.getLog(VersioningComponent.class);
    public static final String XP = "versioningService";
    public VersioningService service;
    protected LinkedList<Class<? extends VersioningService>> contribs;
    protected boolean recompute;

    public void activate(ComponentContext context) throws Exception {
        this.contribs = new LinkedList();
        this.recompute = true;
        this.service = null;
    }

    public void deactivate(ComponentContext context) throws Exception {
        this.contribs.clear();
        this.service = null;
    }

    public void registerContribution(Object contrib, String xp, ComponentInstance contributor) throws Exception {
        Class<?> klass;
        if (!XP.equals(xp)) {
            log.error((Object)("Unknown extension point " + xp));
            return;
        }
        if (!(contrib instanceof VersioningServiceDescriptor)) {
            log.error((Object)("Invalid contribution: " + contrib.getClass().getName()));
            return;
        }
        VersioningServiceDescriptor desc = (VersioningServiceDescriptor)contrib;
        try {
            klass = Class.forName(desc.className);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Invalid contribution class: " + desc.className));
            return;
        }
        if (!VersioningService.class.isAssignableFrom(klass)) {
            log.error((Object)("Invalid contribution class: " + desc.className));
            return;
        }
        this.contribs.add(klass);
        log.info((Object)("Registered versioning service: " + desc.className));
        this.recompute = true;
    }

    public void unregisterContribution(Object contrib, String xp, ComponentInstance contributor) throws Exception {
        Class<VersioningService> klass;
        if (!XP.equals(xp)) {
            return;
        }
        if (!(contrib instanceof VersioningServiceDescriptor)) {
            return;
        }
        VersioningServiceDescriptor desc = (VersioningServiceDescriptor)contrib;
        try {
            klass = Class.forName(desc.className);
        }
        catch (ClassNotFoundException e) {
            return;
        }
        if (!klass.isAssignableFrom(VersioningService.class)) {
            return;
        }
        this.contribs.remove(klass);
        log.info((Object)("Unregistered versioning service: " + desc.className));
        this.recompute = true;
    }

    protected void recompute() {
        Class klass = this.contribs.size() == 0 ? StandardVersioningService.class : this.contribs.getLast();
        if (this.service == null || klass != this.service.getClass()) {
            try {
                this.service = (VersioningService)klass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public VersioningService getService() {
        if (this.recompute) {
            this.recompute();
            this.recompute = false;
        }
        return this.service;
    }

    @Override
    public String getVersionLabel(DocumentModel doc) {
        return this.getService().getVersionLabel(doc);
    }

    @Override
    public void doPostCreate(Document doc) throws DocumentException {
        this.getService().doPostCreate(doc);
    }

    @Override
    public List<VersioningOption> getSaveOptions(DocumentModel docModel) throws ClientException {
        return this.getService().getSaveOptions(docModel);
    }

    @Override
    public VersioningOption doPreSave(Document doc, boolean isDirty, VersioningOption option, String checkinComment) throws DocumentException {
        return this.getService().doPreSave(doc, isDirty, option, checkinComment);
    }

    @Override
    public void doPostSave(Document doc, VersioningOption option, String checkinComment) throws DocumentException {
        this.getService().doPostSave(doc, option, checkinComment);
    }

    @Override
    public Document doCheckIn(Document doc, VersioningOption option, String checkinComment) throws DocumentException {
        return this.getService().doCheckIn(doc, option, checkinComment);
    }

    @Override
    public void doCheckOut(Document doc) throws DocumentException {
        this.getService().doCheckOut(doc);
    }
}

