/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.classpool;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.SecurityActions;
import org.jboss.classpool.spi.ClassPoolRepositoryCallback;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderRepository
implements ClassPoolRepositoryCallback {
    private static final Logger logger = Logger.getLogger(ClassLoaderRepository.class);
    private static final ClassLoaderRepository instance = new ClassLoaderRepository();
    protected final HashMap<ClassLoader, HashSet<Class<?>>> ucl2classes = new HashMap();
    AspectManager manager;

    public static ClassLoaderRepository getInstance() {
        return instance;
    }

    private ClassLoaderRepository() {
    }

    public void setAspectManager(AspectManager manager) {
        this.manager = manager;
    }

    public void registerClass(Class<?> clazz) {
        ClassLoader classLoader = SecurityActions.getClassLoader(clazz);
        HashSet<Class<Object>> classes = this.ucl2classes.get(classLoader);
        if (classes == null) {
            classes = new HashSet();
            this.ucl2classes.put(classLoader, classes);
        }
        classes.add(clazz);
    }

    public void classLoaderRegistered(ClassLoader classLoader) {
    }

    public void classLoaderUnregistered(ClassLoader classLoader) {
        if (System.getSecurityManager() == null) {
            UnregisterClassLoaderAction.NON_PRIVILEGED.unregister(this, classLoader);
        } else {
            UnregisterClassLoaderAction.PRIVILEGED.unregister(this, classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUnregisterClassLoader(ClassLoader cl) {
        ClassLoaderRepository classLoaderRepository = this;
        synchronized (classLoaderRepository) {
            HashSet<Class<?>> classes = this.ucl2classes.remove(cl);
            if (classes != null) {
                for (Class<?> clazz : classes) {
                    Map<Class<?>, WeakReference<Advisor>> map = this.manager.getAdvisors();
                    synchronized (map) {
                        WeakReference<Advisor> ref = this.manager.getAdvisors().get(clazz);
                        if (ref != null) {
                            Advisor advisor = (Advisor)ref.get();
                            this.manager.getAdvisors().remove(clazz);
                            if (advisor != null) {
                                advisor.cleanup();
                            }
                        }
                        Class<?> advisedClass = clazz;
                        try {
                            Field f = advisedClass.getDeclaredField("aop$classAdvisor$aop");
                            f.setAccessible(true);
                            f.set(null, null);
                        }
                        catch (NoSuchFieldException e) {
                            logger.warn((Object)("Error unsetting advisor for " + advisedClass.getName() + " " + e));
                        }
                        catch (IllegalAccessException e) {
                            logger.warn((Object)("Error unsetting advisor for " + advisedClass.getName() + " " + e));
                        }
                    }
                }
            }
        }
    }

    static interface UnregisterClassLoaderAction {
        public static final UnregisterClassLoaderAction PRIVILEGED = new UnregisterClassLoaderAction(){

            public void unregister(final ClassLoaderRepository repository, final ClassLoader loader) {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() {
                            repository.doUnregisterClassLoader(loader);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    Exception ex = e.getException();
                    if (ex instanceof RuntimeException) {
                        throw (RuntimeException)ex;
                    }
                    throw new RuntimeException(ex);
                }
            }
        };
        public static final UnregisterClassLoaderAction NON_PRIVILEGED = new UnregisterClassLoaderAction(){

            public void unregister(ClassLoaderRepository repository, ClassLoader loader) {
                repository.doUnregisterClassLoader(loader);
            }
        };

        public void unregister(ClassLoaderRepository var1, ClassLoader var2);
    }
}

