/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.client;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.Environment;
import org.nuxeo.osgi.BundleFile;
import org.nuxeo.osgi.BundleImpl;
import org.nuxeo.osgi.DirectoryBundleFile;
import org.nuxeo.osgi.JarBundleFile;
import org.nuxeo.osgi.OSGiAdapter;
import org.osgi.framework.BundleException;

public class NuxeoApp {
    private static final Log log = LogFactory.getLog(NuxeoApp.class);
    protected OSGiAdapter osgi;
    protected final ClassLoader loader;
    protected final Environment env;

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return cl == null ? NuxeoApp.class.getClassLoader() : cl;
    }

    public NuxeoApp() {
        this(new File("."), NuxeoApp.getDefaultClassLoader());
    }

    public NuxeoApp(File home) {
        this(home, NuxeoApp.getDefaultClassLoader());
    }

    public NuxeoApp(File home, ClassLoader loader) {
        this.loader = loader;
        this.env = new Environment(home);
        Environment.setDefault((Environment)this.env);
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    public Environment getEnvironment() {
        return this.env;
    }

    public void deployBundles(String bundlePath) throws BundleException, IOException {
        this.deployBundles(NuxeoApp.getBundleFiles(new File("."), bundlePath, ":"));
    }

    public void deployBundles(File baseDir, String bundlePath) throws BundleException, IOException {
        this.deployBundles(NuxeoApp.getBundleFiles(baseDir, bundlePath, ":"));
    }

    public synchronized void deployBundles(Collection<File> files) throws BundleException, IOException {
        if (!this.isStarted()) {
            throw new IllegalStateException("Framework not started");
        }
        for (File file : files) {
            this.deployBundle(file);
        }
    }

    public synchronized void deployBundle(File file) throws BundleException, IOException {
        if (!this.isStarted()) {
            throw new IllegalStateException("Framework not started");
        }
        DirectoryBundleFile bf = file.isDirectory() ? new DirectoryBundleFile(file) : new JarBundleFile(file);
        try {
            BundleImpl bundle = new BundleImpl(this.osgi, (BundleFile)bf, this.loader);
            if (bundle.getSymbolicName() != null) {
                this.osgi.install(bundle);
            }
        }
        catch (NullPointerException t) {
            log.error((Object)("Caught a NPE while loading bundle " + bf.getFileName()), (Throwable)t);
        }
    }

    public synchronized void start() {
        if (this.osgi != null) {
            throw new IllegalStateException("Nuxeo Runtime already started");
        }
        this.osgi = new OSGiAdapter(this.env.getHome(), this.env.getData(), this.env.getProperties());
    }

    public synchronized boolean isStarted() {
        return this.osgi != null;
    }

    public synchronized OSGiAdapter getOsgi() {
        return this.osgi;
    }

    public synchronized void shutdown() throws IOException {
        if (this.osgi == null) {
            throw new IllegalStateException("Nuxeo Runtime not started");
        }
        this.osgi.shutdown();
        this.osgi = null;
    }

    public static Collection<File> getBundleFiles(File baseDir, String bundles, String delim) throws IOException {
        LinkedHashSet<File> result = new LinkedHashSet<File>();
        StringTokenizer tokenizer = new StringTokenizer(bundles, delim == null ? " \t\n\r\f" : delim);
        while (tokenizer.hasMoreTokens()) {
            String tok = tokenizer.nextToken();
            List<File> files = NuxeoApp.expandFiles(baseDir, tok);
            for (File file : files) {
                result.add(file.getCanonicalFile());
            }
        }
        return result;
    }

    public static File makeFile(File baseDir, String path) {
        if (path.startsWith("/")) {
            return new File(path);
        }
        return new File(baseDir, path);
    }

    public static List<File> expandFiles(File baseDir, String line) {
        int p = line.lastIndexOf("/");
        String fileName = null;
        if (p > -1) {
            fileName = line.substring(p + 1);
            baseDir = NuxeoApp.makeFile(baseDir, line.substring(0, p));
        } else {
            fileName = line;
        }
        if (fileName.length() == 0) {
            return Arrays.asList(baseDir.listFiles());
        }
        p = fileName.indexOf("*");
        if (p == -1) {
            return Collections.singletonList(NuxeoApp.makeFile(baseDir, fileName));
        }
        if (p == 0) {
            String suffix = fileName.substring(p + 1);
            ArrayList<File> result = new ArrayList<File>();
            String[] names = baseDir.list();
            if (names != null) {
                for (String name : names) {
                    if (!name.endsWith(suffix)) continue;
                    result.add(NuxeoApp.makeFile(baseDir, name));
                }
            }
            return result;
        }
        if (p == fileName.length() - 1) {
            String prefix = fileName.substring(0, p);
            ArrayList<File> result = new ArrayList<File>();
            String[] names = baseDir.list();
            if (names != null) {
                for (String name : names) {
                    if (!name.startsWith(prefix)) continue;
                    result.add(NuxeoApp.makeFile(baseDir, name));
                }
            }
            return result;
        }
        String prefix = fileName.substring(0, p);
        String suffix = fileName.substring(p + 1);
        ArrayList<File> result = new ArrayList<File>();
        String[] names = baseDir.list();
        if (names != null) {
            for (String name : names) {
                if (!name.startsWith(prefix) || !name.endsWith(suffix)) continue;
                result.add(NuxeoApp.makeFile(baseDir, name));
            }
        }
        return result;
    }
}

