/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.event.jmx;

import org.nuxeo.ecm.core.event.EventServiceAdmin;
import org.nuxeo.ecm.core.event.impl.EventListenerDescriptor;
import org.nuxeo.ecm.core.event.impl.EventListenerList;
import org.nuxeo.ecm.core.event.jmx.EventMonitoringMBean;
import org.nuxeo.ecm.core.event.jmx.EventStatsHolder;
import org.nuxeo.runtime.api.Framework;

public class EventMonitoring
implements EventMonitoringMBean {
    private static EventServiceAdmin getAdminService() {
        return (EventServiceAdmin)Framework.getLocalService(EventServiceAdmin.class);
    }

    @Override
    public boolean isAsyncHandlersTrackingEnabled() {
        return EventStatsHolder.isCollectAsyncHandlersExecTime();
    }

    @Override
    public void setAsyncHandlersTrackingEnabled(boolean collectAsyncHandlersExecTime) {
        EventStatsHolder.setCollectAsyncHandlersExecTime(collectAsyncHandlersExecTime);
    }

    @Override
    public boolean isSyncHandlersTrackingEnabled() {
        return EventStatsHolder.isCollectSyncHandlersExecTime();
    }

    @Override
    public void setSyncHandlersTrackingEnabled(boolean collectSyncHandlersExecTime) {
        EventStatsHolder.setCollectSyncHandlersExecTime(collectSyncHandlersExecTime);
    }

    @Override
    public int getActiveThreadsCount() {
        return EventMonitoring.getAdminService().getActiveThreadsCount();
    }

    @Override
    public int getEventsInQueueCount() {
        return EventMonitoring.getAdminService().getEventsInQueueCount();
    }

    @Override
    public String getAsyncHandlersExecTime() {
        return EventStatsHolder.getAsyncHandlersExecTime();
    }

    @Override
    public String getSyncHandlersExecTime() {
        return EventStatsHolder.getSyncHandlersExecTime();
    }

    @Override
    public boolean isBlockAsyncHandlers() {
        return EventMonitoring.getAdminService().isBlockAsyncHandlers();
    }

    @Override
    public void setBlockAsyncHandlers(boolean blockAsyncHandlers) {
        EventMonitoring.getAdminService().setBlockAsyncHandlers(blockAsyncHandlers);
    }

    @Override
    public boolean isBlockSyncPostCommitHandlers() {
        return EventMonitoring.getAdminService().isBlockSyncPostCommitHandlers();
    }

    @Override
    public void setBlockSyncPostCommitHandlers(boolean blockSyncPostCommitHandlers) {
        EventMonitoring.getAdminService().setBlockSyncPostCommitHandlers(blockSyncPostCommitHandlers);
    }

    @Override
    public void resetHandlersExecTime() {
        EventStatsHolder.resetHandlersExecTime();
    }

    @Override
    public String getListenersConfig() {
        EventListenerList listenerList = EventMonitoring.getAdminService().getListenerList();
        StringBuilder sb = new StringBuilder();
        for (EventListenerDescriptor desc : listenerList.getAsyncPostCommitListenersDescriptors()) {
            sb.append(desc.getName());
            sb.append(" - Async PostCommit - ");
            sb.append(desc.isEnabled());
            sb.append("\n");
        }
        for (EventListenerDescriptor desc : listenerList.getSyncPostCommitListenersDescriptors()) {
            sb.append(desc.getName());
            sb.append(" - Sync PostCommit - ");
            sb.append(desc.isEnabled());
            sb.append("\n");
        }
        for (EventListenerDescriptor desc : listenerList.getInlineListenersDescriptors()) {
            sb.append(desc.getName());
            sb.append(" - Synchronous - ");
            sb.append(desc.isEnabled());
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public void setListenerEnabledFlag(String listenerName, boolean enabled) {
        EventMonitoring.getAdminService().setListenerEnabledFlag(listenerName, enabled);
    }

    @Override
    public boolean isBulkModeEnabled() {
        return EventMonitoring.getAdminService().isBulkModeEnabled();
    }

    @Override
    public void setBulkModeEnabled(boolean bulkModeEnabled) {
        EventMonitoring.getAdminService().setBulkModeEnabled(bulkModeEnabled);
    }
}

