/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.shell.commands.repository;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.client.NuxeoClient;
import org.nuxeo.ecm.shell.CommandLine;
import org.nuxeo.ecm.shell.commands.repository.AbstractCommand;

public class ConnectCommand
extends AbstractCommand {
    private static final Log log = LogFactory.getLog(ConnectCommand.class);

    @Override
    public void run(CommandLine cmdLine) throws Exception {
        try {
            NuxeoClient.getInstance().tryDisconnect();
        }
        catch (Exception e) {
            // empty catch block
        }
        String[] parameters = cmdLine.getParameters();
        if (parameters.length > 0) {
            this.context.setUsername(parameters[0]);
            if (parameters.length > 1) {
                this.context.setPassword(parameters[1]);
            }
        }
        try {
            log.info((Object)"First try to connect...");
            this.context.getRepositoryInstance().getRootDocument();
        }
        catch (Exception e) {
            log.info((Object)("Connection failure with user " + this.context.getUsername()));
            this.context.setRepositoryInstance(null);
            this.context.setUsername(null);
            this.context.setPassword(null);
            try {
                NuxeoClient.getInstance().tryDisconnect();
            }
            catch (Exception e1) {
                // empty catch block
            }
            try {
                log.info((Object)"Second try to connect...");
                this.context.getRepositoryInstance().getRootDocument();
            }
            catch (Exception e2) {
                log.error((Object)("Connection failed: " + e2.getMessage()));
                throw e2;
            }
        }
        log.info((Object)("Connected to " + this.context.getHost() + ":" + this.context.getPort()));
    }
}

