/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.shell.commands.repository;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.search.api.client.IndexingException;
import org.nuxeo.ecm.core.search.api.client.SearchService;
import org.nuxeo.ecm.core.search.api.client.common.SearchServiceDelegate;
import org.nuxeo.ecm.shell.CommandLine;
import org.nuxeo.ecm.shell.commands.repository.AbstractCommand;

public class IndexCommand
extends AbstractCommand {
    private static final Log log = LogFactory.getLog(IndexCommand.class);
    private static final String REPO_NAME = "default";
    private static final long SLEEPING_DURATION = 10000L;

    private void printHelp() {
        System.out.println("");
        System.out.println("Syntax: index [repository_name] [path] [batch_size] [full_text]");
        System.out.println(" repository_name (optionnal, default=default): name of the repository to reindex");
        System.out.println(" path (optionnal, default=/): path used for reindex");
        System.out.println(" batch_size (optionnal, default=20): size of reindex batch");
        System.out.println(" full_text (optionnal, default=true : include fullText in indexing true/false");
    }

    @Override
    public void run(CommandLine cmdLine) throws Exception {
        String repo = REPO_NAME;
        String path = "/";
        Boolean fullText = true;
        int batchSize = 20;
        String[] elements = cmdLine.getParameters();
        if (elements.length >= 1) {
            if ("help".equals(elements[0])) {
                this.printHelp();
                return;
            }
            repo = elements[0];
        }
        if (elements.length >= 2) {
            path = elements[1];
        }
        if (elements.length >= 3) {
            try {
                batchSize = Integer.parseInt(elements[2]);
            }
            catch (Throwable t) {
                batchSize = 20;
                log.error((Object)("Failed to parse batch size, using default batchSize=" + batchSize), t);
            }
        }
        if (elements.length >= 4) {
            try {
                fullText = Boolean.parseBoolean(elements[3]);
            }
            catch (Throwable t) {
                log.error((Object)"Failed to parse fullText option : skipping", t);
                fullText = true;
            }
        }
        this.index(repo, path, batchSize, fullText);
    }

    public void index(String repoName, String path, int batchSize, Boolean fullText) {
        SimpleDateFormat timeFormater = new SimpleDateFormat("HH:mm:ss");
        try {
            SearchService searchService = SearchServiceDelegate.getRemoteSearchService();
            if (searchService == null) {
                throw new IndexingException("Cannot find search service");
            }
            long initialIndexingThreadNumber = searchService.getTotalCompletedIndexingTasks();
            int orgBatchSize = searchService.getIndexingDocBatchSize();
            searchService.setIndexingDocBatchSize(batchSize);
            searchService.reindexAll(repoName, path, fullText.booleanValue());
            log.info((Object)(timeFormater.format(new Date()) + " Indexing: " + path + " indexingDocBatchSize: " + orgBatchSize + " fullText: " + fullText));
            double s = System.currentTimeMillis();
            long lastNbIndexedDocs = 0L;
            long lastDiff = 0L;
            double lastTm = s / 1000.0;
            while (true) {
                Thread.sleep(10000L);
                long nbIndexedDocs = searchService.getTotalCompletedIndexingTasks() - initialIndexingThreadNumber;
                long diff = nbIndexedDocs - lastNbIndexedDocs;
                lastNbIndexedDocs = nbIndexedDocs;
                if (diff == 0L && lastDiff == 0L && searchService.getActiveIndexingTasks() <= 0) break;
                lastDiff = diff;
                double tm = ((double)System.currentTimeMillis() - s) / 1000.0;
                double flow = (double)nbIndexedDocs / tm;
                double dflow = (double)diff / (tm - lastTm);
                lastTm = tm;
                log.info((Object)String.format("%s indexed %5d docs at %6.2f docs/s (%7d docs at %6.2f docs/s) %d threads %d queued (batch %d). \n", timeFormater.format(new Date()), diff, dflow, nbIndexedDocs, flow, searchService.getActiveIndexingTasks(), searchService.getIndexingWaitingQueueSize(), searchService.getIndexingDocBatchSize()));
            }
            searchService.setIndexingDocBatchSize(orgBatchSize);
            double tm = ((double)System.currentTimeMillis() - s) / 1000.0;
            log.info((Object)("Indexing " + lastNbIndexedDocs + " done in " + tm + " seconds"));
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }
}

