/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.shell.commands.repository;

import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.shell.CommandLine;
import org.nuxeo.ecm.shell.commands.repository.AbstractCommand;
import org.nuxeo.ecm.shell.commands.repository.ThreadedImportTask;

public class MTFSImportCommand
extends AbstractCommand {
    static ThreadPoolExecutor importTP;
    static Map<String, Long> nbCreatedDocsByThreads;
    private static final Log log;

    public static ThreadPoolExecutor getExecutor() {
        return importTP;
    }

    public static synchronized void addCreatedDoc(String taskId, long nbDocs) {
        String tid = Thread.currentThread().getName();
        nbCreatedDocsByThreads.put(tid + "-" + taskId, nbDocs);
    }

    public static synchronized long getCreatedDocsCounter() {
        long counter = 0L;
        for (String tid : nbCreatedDocsByThreads.keySet()) {
            Long tCounter = nbCreatedDocsByThreads.get(tid);
            if (tCounter == null) continue;
            counter += tCounter.longValue();
        }
        return counter;
    }

    private void printHelp() {
        System.out.println("");
        System.out.println("Syntax: mtfsimport local_file_path [remote_path] [batch_size] [nbThreads]");
    }

    @Override
    public void run(CommandLine cmdLine) throws Exception {
        DocumentModel parent;
        nbCreatedDocsByThreads = new ConcurrentHashMap<String, Long>();
        String[] elements = cmdLine.getParameters();
        if (elements.length == 0) {
            log.error((Object)"SYNTAX ERROR: the mtfsimport command must take at least one argument: fsimport local_file_path [remote_path] [batch_size] [nbThreads] ");
            this.printHelp();
            return;
        }
        File localFile = new File(elements[0]);
        if ("help".equals(elements[0])) {
            this.printHelp();
            return;
        }
        if (elements.length >= 2) {
            Path path = new Path(elements[1]);
            try {
                parent = this.context.fetchDocument(path);
            }
            catch (Exception e) {
                log.error((Object)"Failed to retrieve the given folder", (Throwable)e);
                return;
            }
        } else {
            parent = this.context.fetchDocument();
        }
        Integer batchSize = 50;
        if (elements.length >= 3) {
            try {
                batchSize = Integer.parseInt(elements[2]);
            }
            catch (Throwable t) {
                batchSize = 10;
                log.error((Object)("Failed to parse batch size, using default batchSize=" + batchSize), t);
            }
        }
        Integer nbThreads = 5;
        if (elements.length >= 4) {
            try {
                nbThreads = Integer.parseInt(elements[3]);
            }
            catch (Throwable t) {
                log.error((Object)"Failed to parse nbThreads, using default", t);
            }
        }
        importTP = new ThreadPoolExecutor(nbThreads, nbThreads, 500L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(100));
        ThreadedImportTask rootImportTask = new ThreadedImportTask(localFile, parent);
        rootImportTask.setRootTask();
        long t0 = System.currentTimeMillis();
        importTP.execute(rootImportTask);
        Thread.sleep(200L);
        int activeTasks = importTP.getActiveCount();
        int oldActiveTasks = 0;
        while (activeTasks > 0) {
            Thread.sleep(200L);
            activeTasks = importTP.getActiveCount();
            if (oldActiveTasks == activeTasks) continue;
            oldActiveTasks = activeTasks;
            log.info((Object)("currently " + activeTasks + " active import Threads"));
            long inbCreatedDocs = MTFSImportCommand.getCreatedDocsCounter();
            log.info((Object)(inbCreatedDocs + " docs created"));
            long ti = System.currentTimeMillis();
            log.info((Object)(1000.0f * ((float)inbCreatedDocs / (float)(ti - t0)) + " docs/s"));
        }
        log.info((Object)"All Threads terminated");
        long t1 = System.currentTimeMillis();
        long nbCreatedDocs = MTFSImportCommand.getCreatedDocsCounter();
        log.info((Object)(nbCreatedDocs + " docs created"));
        log.info((Object)(1000.0f * ((float)nbCreatedDocs / (float)(t1 - t0)) + " docs/s"));
        for (String k : nbCreatedDocsByThreads.keySet()) {
            log.debug((Object)(k + " --> " + nbCreatedDocsByThreads.get(k)));
        }
    }

    static {
        nbCreatedDocsByThreads = new ConcurrentHashMap<String, Long>();
        log = LogFactory.getLog(MTFSImportCommand.class);
    }
}

