/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.shell.commands.repository;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.shell.CommandLine;
import org.nuxeo.ecm.shell.commands.repository.AbstractCommand;

public class MkDirCommand
extends AbstractCommand {
    private static final Log log = LogFactory.getLog(MkDirCommand.class);

    @Override
    public void run(CommandLine cmdLine) throws Exception {
        String[] elements = cmdLine.getParameters();
        if (elements.length == 0) {
            log.error((Object)"SYNTAX ERROR: the mkdir command must take at least one argument: mkdir path_or_name [type]");
            return;
        }
        DocumentModel parent = null;
        String dirName = null;
        if (elements.length >= 1) {
            Path path = new Path(elements[0]);
            if ((path = path.removeTrailingSeparator()).isAbsolute()) {
                Path parentPath = path.removeLastSegments(1);
                parent = this.context.fetchDocument(parentPath);
                dirName = path.lastSegment();
            } else {
                DocumentRef currentDocRef = this.context.getCurrentDocument();
                parent = this.context.getRepositoryInstance().getSession().getDocument(currentDocRef);
                dirName = path.toString();
            }
        }
        String dirType = elements.length == 2 ? elements[1] : "Folder";
        this.createDir(parent, dirName, dirType);
    }

    private DocumentModel createDir(DocumentModel parent, String name, String docType) throws Exception {
        CoreSession session = this.context.getRepositoryInstance().getSession();
        DocumentModel doc = session.createDocumentModel(docType);
        doc.setPathInfo(parent.getPathAsString(), name);
        doc.setProperty("dublincore", "title", (Object)name);
        doc = session.createDocument(doc);
        session.save();
        return doc;
    }
}

