/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.shell.commands.repository;

import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.client.NuxeoClient;
import org.nuxeo.ecm.shell.CommandLine;
import org.nuxeo.ecm.shell.commands.repository.AbstractCommand;

public class RepoStatsCommand
extends AbstractCommand {
    private static final Log log = LogFactory.getLog(RepoStatsCommand.class);
    public static StatInfo info;
    protected Boolean includeBlob = true;
    private long t0;
    private long lastStatTime;
    private long printStatCount;
    private static final String printStatHeader = "time     threads      docs  docs/s     blobs   size(M)     M/s tdocs/s tdoc/th/s";
    private static final SimpleDateFormat timeFormater;
    protected static ThreadPoolExecutor pool;

    private void printHelp() {
        System.out.println("");
        System.out.println("Synthax: repostats doc_path");
        System.out.println(" doc_path: reprository path from where stats must be gathered");
        System.out.println(" [nbThreads]: defines the number of cucurrent threads (optional, default=5)");
        System.out.println(" [includeBlobs]: Boolean indicating if Blob data should introspected (optional, default=false)");
        System.out.println("Information displayed while gathering data:");
        System.out.println(" time, number of running threads,");
        System.out.println(" total number of documents processed, average of documents per second processed,");
        System.out.println(" number of blobs processed, blobs size in megabytes, average megabytes per second (M/s),");
        System.out.println(" trend of document per second processed (tdocs/s), trend of document per second and per active thread.");
    }

    private void printStats(int activeThread) {
        long now = System.currentTimeMillis();
        long lastProcessed = info.getLastTotalNbDocs();
        long processed = info.getTotalNbDocs();
        long blobProcessed = info.getTotalBlobNumber();
        long blobSize = info.getTotalBlobSize();
        long t1 = activeThread == 0 && processed == lastProcessed ? this.lastStatTime : now;
        double trend = (double)(processed - lastProcessed) / ((double)(t1 - this.lastStatTime) / 1000.0);
        double trendThread = trend / (double)activeThread;
        if (this.printStatCount % 25L == 0L) {
            log.info((Object)printStatHeader);
        }
        log.info((Object)String.format("%s %7d %9d %7.2f %9d %9.2f %7.3f %7.2f %9.2f", timeFormater.format(now), activeThread, processed, (double)processed / (double)(t1 - this.t0) * 1000.0, blobProcessed, (double)blobSize / 1024.0 / 1024.0, (double)blobSize / (double)(t1 - this.t0) / 1024.0 / 1024.0 * 1000.0, trend, trendThread));
        ++this.printStatCount;
        this.lastStatTime = t1;
    }

    @Override
    public void run(CommandLine cmdLine) throws Exception {
        String[] elements = cmdLine.getParameters();
        if (elements.length == 0) {
            log.error((Object)"SYNTAX ERROR: the repostats command must take at least one argument");
            this.printHelp();
            return;
        }
        if ("help".equals(elements[0])) {
            this.printHelp();
            return;
        }
        DocumentModel root = null;
        if (elements.length >= 1) {
            Path path = new Path(elements[0]);
            try {
                root = this.context.fetchDocument(path);
            }
            catch (Exception e) {
                log.error((Object)"Failed to retrieve the given folder", (Throwable)e);
                return;
            }
        }
        int nbThreads = 5;
        if (elements.length >= 2) {
            try {
                nbThreads = Integer.parseInt(elements[1]);
            }
            catch (Exception e) {
                log.error((Object)"Failed to parse number of threads", (Throwable)e);
                return;
            }
        } else {
            log.info((Object)(" Using default Thread number: " + nbThreads));
        }
        if (elements.length >= 3) {
            try {
                this.includeBlob = Boolean.parseBoolean(elements[2]);
            }
            catch (Exception e) {
                log.error((Object)"Failed to parse the includeBlob parameter", (Throwable)e);
                return;
            }
        } else {
            this.includeBlob = false;
        }
        info = new StatInfo();
        StatTask task = new StatTask(root);
        pool = new ThreadPoolExecutor(nbThreads, nbThreads, 500L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(100));
        this.t0 = System.currentTimeMillis();
        pool.execute(task);
        Thread.sleep(100L);
        do {
            this.printStats(pool.getActiveCount());
            Thread.sleep(1000L);
        } while (pool.getActiveCount() > 0);
        this.printStats(pool.getActiveCount());
        long t1 = System.currentTimeMillis();
        log.info((Object)("Stats for " + root.getPathAsString()));
        log.info((Object)("Total number of documents (without versions):" + info.getTotalNbDocs()));
        Map<String, Long> docsPerType = info.getDocsPerType();
        for (String type : docsPerType.keySet()) {
            log.info((Object)("   Number of " + type + " docs: " + docsPerType.get(type)));
        }
        if (this.includeBlob.booleanValue()) {
            log.info((Object)("Total number of blobs:" + info.getTotalBlobNumber()));
            log.info((Object)("   Total size of blobs (M): " + (float)info.getTotalBlobSize() / 1048576.0f));
            log.info((Object)("   Average blob size (K): " + (float)info.getTotalBlobSize() / 1024.0f / (float)info.getTotalBlobNumber()));
            log.info((Object)("   Maximum blob size (M): " + (double)info.maxBlobSize / 1024.0 / 1024.0 + " in " + info.maxBlobSizePath));
        }
        if (root.getPathAsString().equals("/")) {
            long count = this.context.getCoreSession().query("select * from Document where ecm:isCheckedInVersion=1").size();
            log.info((Object)("Versions: " + count));
            log.info((Object)("Total number of documents (with versions): " + (info.getTotalNbDocs() + count)));
            count = this.context.getCoreSession().query("select * from Document where ecm:isProxy=1").size();
            log.info((Object)("Proxies: " + count));
            count = this.context.getCoreSession().query("select * from Document where ecm:currentLifeCycleState = 'deleted'").size();
            log.info((Object)("Mark as deleted: " + count));
        }
        log.info((Object)"Folders");
        log.info((Object)("   Maximum depth: " + info.maxDepth + " in " + info.maxDepthPath));
        log.info((Object)("   Maximum children: " + info.maxChildren + " in " + info.maxChildrenPath));
        log.info((Object)("Repository performance during stats was " + 1000.0f * (float)info.getTotalNbDocs() / (float)(t1 - this.t0) + " doc/s"));
    }

    static {
        timeFormater = new SimpleDateFormat("HH:mm:ss");
    }

    protected class StatTask
    implements Runnable {
        private final CoreSession session = NuxeoClient.getInstance().openRepository();
        private final DocumentModel rootDoc;

        protected StatTask(DocumentModel rootDoc) throws Exception {
            this.rootDoc = rootDoc;
        }

        public void dispose() {
            try {
                CoreInstance.getInstance().close(this.session);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }

        @Override
        public synchronized void run() {
            try {
                this.recurse(this.rootDoc);
            }
            catch (ClientException e) {
                try {
                    CoreInstance.getInstance().close(this.session);
                }
                catch (Exception e1) {
                    log.error((Object)e);
                }
            }
        }

        private StatTask getNextTask(DocumentModel root) {
            StatTask newTask;
            if (pool.getQueue().size() > 1) {
                return null;
            }
            try {
                newTask = new StatTask(root);
            }
            catch (Exception e) {
                return null;
            }
            return newTask;
        }

        private void recurse(DocumentModel doc) throws ClientException {
            this.fetchInfoFromDoc(this.session, doc);
            if (doc.isFolder()) {
                long children = 0L;
                for (DocumentModel child : this.session.getChildren(doc.getRef())) {
                    ++children;
                    if (child.isFolder()) {
                        StatTask newTask = this.getNextTask(child);
                        if (newTask != null) {
                            pool.execute(newTask);
                            continue;
                        }
                        this.recurse(child);
                        continue;
                    }
                    this.fetchInfoFromDoc(this.session, child);
                }
                info.childrenCount(children, doc.getPath());
            }
        }

        private void fetchInfoFromDoc(CoreSession session, DocumentModel doc) throws UnsupportedOperationException, ClientException {
            Long size;
            info.addDoc(doc.getType(), doc.getPath());
            if (RepoStatsCommand.this.includeBlob.booleanValue() && doc.hasSchema("file") && (size = (Long)doc.getPart("file").get("content").get("length").getValue()) != null) {
                info.addBlob(size, doc.getPath());
            }
        }
    }

    private static class StatInfo {
        private final Map<String, Long> docsPerTypes = new ConcurrentHashMap<String, Long>();
        private long totalBlobSize = 0L;
        private long totalBlobNb = 0L;
        private long lastTotalNbDocs = 0L;
        private long lastTotalBlobSize = 0L;
        private long lastTotalBlobNb = 0L;
        private long maxDepth = 0L;
        private String maxDepthPath;
        private long maxChildren;
        private String maxChildrenPath;
        private long maxBlobSize;
        private String maxBlobSizePath;

        StatInfo() {
        }

        public Map<String, Long> getDocsPerType() {
            return this.docsPerTypes;
        }

        public synchronized void addDoc(String type, Path path) {
            Long counter = this.docsPerTypes.get(type);
            if ((long)path.segmentCount() > this.maxDepth) {
                this.maxDepth = path.segmentCount();
                this.maxDepthPath = path.toString();
            }
            counter = counter == null ? Long.valueOf(1L) : Long.valueOf(counter + 1L);
            this.docsPerTypes.put(type, counter);
        }

        public synchronized void addBlob(long size, Path path) {
            this.totalBlobSize += size;
            ++this.totalBlobNb;
            if (size > this.maxBlobSize) {
                this.maxBlobSize = size;
                this.maxBlobSizePath = path.toString();
            }
        }

        public synchronized void childrenCount(long children, Path path) {
            if (children > this.maxChildren) {
                this.maxChildren = children;
                this.maxChildrenPath = path.toString();
            }
        }

        public long getTotalNbDocs() {
            long total = 0L;
            for (String k : this.docsPerTypes.keySet()) {
                total += this.docsPerTypes.get(k).longValue();
            }
            this.lastTotalNbDocs = total;
            return total;
        }

        public long getTotalBlobSize() {
            this.lastTotalBlobSize = this.totalBlobSize;
            return this.totalBlobSize;
        }

        public long getTotalBlobNumber() {
            this.lastTotalBlobNb = this.totalBlobNb;
            return this.totalBlobNb;
        }

        public long getLastTotalNbDocs() {
            return this.lastTotalNbDocs;
        }

        public long getLastTotalBlobSize() {
            return this.lastTotalBlobSize;
        }

        public long getLastTotalBlobNumber() {
            return this.lastTotalBlobNb;
        }
    }
}

