/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.shell.commands.repository;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.blob.StreamingBlob;
import org.nuxeo.ecm.core.client.NuxeoClient;
import org.nuxeo.ecm.shell.commands.repository.MTFSImportCommand;
import org.nuxeo.runtime.services.streaming.FileSource;
import org.nuxeo.runtime.services.streaming.StreamSource;

public class ThreadedImportTask
implements Runnable {
    private static final Log log = LogFactory.getLog(ThreadedImportTask.class);
    private static int taskCounter = 0;
    private boolean isRunning = false;
    private long uploadedFiles = 0L;
    private long uploadedKO;
    private int batchSize;
    private CoreSession session;
    private DocumentModel rootDoc;
    private File rootFile;
    private Boolean skipContainerCreation = false;
    private Boolean isRootTask = false;
    private String taskId = null;

    private static synchronized int getNextTaskId() {
        return ++taskCounter;
    }

    public ThreadedImportTask(CoreSession session, int batchSize) throws Exception {
        if (session == null) {
            // empty if block
        }
        if (session == null) {
            session = NuxeoClient.getInstance().openRepository();
        }
        this.session = session;
        this.batchSize = batchSize;
        this.uploadedFiles = 0L;
        this.taskId = "T" + ThreadedImportTask.getNextTaskId();
    }

    public ThreadedImportTask(File rootFile, DocumentModel rootDoc) throws Exception {
        this(null, rootFile, rootDoc);
    }

    public ThreadedImportTask(CoreSession session, File rootFile, DocumentModel rootDoc) throws Exception {
        this(session, 50);
        this.rootFile = rootFile;
        this.rootDoc = rootDoc;
    }

    protected void commit() throws Exception {
        this.commit(false);
    }

    protected void commit(boolean force) throws Exception {
        ++this.uploadedFiles;
        if (this.uploadedFiles % 10L == 0L) {
            MTFSImportCommand.addCreatedDoc(this.taskId, this.uploadedFiles);
        }
        if (this.uploadedFiles % (long)this.batchSize == 0L || force) {
            log.debug((Object)("Comiting Core Session after " + this.uploadedFiles + " files"));
            this.session.save();
        }
    }

    public DocumentModel createDirectory(DocumentModel parent, File file) throws Exception {
        String docType = "Folder";
        String name = this.getValidNameFromFileName(file.getName());
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        options.put("BLOCK_JMS_PRODUCING", true);
        DocumentModel doc = this.session.createDocumentModel(docType, options);
        doc.setPathInfo(parent.getPathAsString(), name);
        doc.setProperty("dublincore", "title", (Object)file.getName());
        doc.putContextData("BLOCK_JMS_PRODUCING", (Serializable)Boolean.valueOf(true));
        doc.putContextData("BLOCK_SYNC_INDEXING", (Serializable)Boolean.valueOf(true));
        log.debug((Object)("Creating Folder " + name + " at " + parent.getPathAsString()));
        doc = this.session.createDocument(doc);
        this.commit();
        return doc;
    }

    public DocumentModel createFile(DocumentModel parent, File file) throws Exception {
        if (!file.exists()) {
            log.error((Object)("non readable file : " + file.getName()));
            return null;
        }
        String mimeType = this.getMimeType(file);
        String docType = "File";
        String name = this.getValidNameFromFileName(file.getName());
        String fileName = file.getName();
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        options.put("BLOCK_JMS_PRODUCING", true);
        DocumentModel doc = this.session.createDocumentModel(docType, options);
        doc.putContextData("BLOCK_JMS_PRODUCING", (Serializable)Boolean.valueOf(true));
        doc.putContextData("BLOCK_SYNC_INDEXING", (Serializable)Boolean.valueOf(true));
        doc.setPathInfo(parent.getPathAsString(), name);
        doc.setProperty("dublincore", "title", (Object)file.getName());
        doc.setProperty("file", "filename", (Object)fileName);
        FileSource src = new FileSource(file);
        StreamingBlob streamingBlob = new StreamingBlob((StreamSource)src, mimeType);
        doc.setProperty("file", "content", (Object)streamingBlob);
        long kbSize = file.length() / 1024L;
        log.debug((Object)("Creating doc " + name + " at " + parent.getPathAsString() + " with file " + fileName + " of size " + kbSize + "KB"));
        doc = this.session.createDocument(doc);
        this.uploadedKO += kbSize;
        this.commit();
        return doc;
    }

    protected ThreadedImportTask getTask(DocumentModel parent, File file) {
        ThreadedImportTask newTask;
        if (this.isRootTask.booleanValue()) {
            this.isRootTask = false;
            return null;
        }
        if (this.uploadedFiles < (long)(this.batchSize / 3)) {
            return null;
        }
        int scheduledTasks = MTFSImportCommand.getExecutor().getQueue().size();
        if (scheduledTasks >= 5) {
            return null;
        }
        try {
            newTask = new ThreadedImportTask(file, parent);
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
        newTask.setBatchSize(this.getBatchSize());
        newTask.setSkipContainerCreation(true);
        return newTask;
    }

    protected void upload(DocumentModel parent, File file) throws Exception {
        if (file.isDirectory()) {
            DocumentModel folder;
            Boolean newThread = false;
            if (this.skipContainerCreation.booleanValue()) {
                folder = parent;
                this.skipContainerCreation = false;
                newThread = true;
            } else {
                folder = this.createDirectory(parent, file);
            }
            File[] files = file.listFiles();
            if (files.length > 0) {
                ThreadedImportTask task = null;
                if (!newThread.booleanValue()) {
                    task = this.getTask(folder, file);
                }
                if (task != null) {
                    this.session.save();
                    MTFSImportCommand.getExecutor().execute(task);
                } else {
                    for (File f : file.listFiles()) {
                        this.upload(folder, f);
                    }
                }
            }
        } else {
            this.createFile(parent, file);
        }
    }

    public void setInputFile(File rootFile) {
        this.rootFile = rootFile;
    }

    public void setTargetFolder(DocumentModel rootDoc) {
        this.rootDoc = rootDoc;
    }

    protected String getMimeType(File file) {
        String fileName = file.getName();
        if (fileName == null) {
            return "application/octet-stream";
        }
        if (fileName.endsWith(".doc")) {
            return "application/msword";
        }
        if (fileName.endsWith(".xls")) {
            return "application/vnd.ms-excel";
        }
        if (fileName.endsWith(".ppt")) {
            return "application/vnd.ms-powerpoint";
        }
        if (fileName.endsWith(".txt")) {
            return "text/plain";
        }
        if (fileName.endsWith(".html")) {
            return "text/html";
        }
        if (fileName.endsWith(".xml")) {
            return "text/xml";
        }
        if (fileName.endsWith(".jpg")) {
            return "image/jpeg";
        }
        if (fileName.endsWith(".jpeg")) {
            return "image/jpeg";
        }
        if (fileName.endsWith(".gif")) {
            return "image/gif";
        }
        if (fileName.endsWith(".odt")) {
            return "application/vnd.oasis.opendocument.text";
        }
        if (fileName.endsWith(".zip")) {
            return "application/zip";
        }
        return "application/octet-stream";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        ThreadedImportTask threadedImportTask = this;
        synchronized (threadedImportTask) {
            return this.isRunning;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        ThreadedImportTask threadedImportTask = this;
        synchronized (threadedImportTask) {
            if (this.isRunning) {
                throw new IllegalStateException("Task already running");
            }
            this.isRunning = true;
            if (this.rootDoc == null || this.rootFile == null) {
                this.isRunning = false;
                throw new IllegalArgumentException("target folder and source file must be specified");
            }
        }
        try {
            this.upload(this.rootDoc, this.rootFile);
            this.session.save();
            MTFSImportCommand.addCreatedDoc(this.taskId, this.uploadedFiles);
            CoreInstance.getInstance().close(this.session);
        }
        catch (Exception e) {
            log.error((Object)"Error during import", (Throwable)e);
        }
        finally {
            ThreadedImportTask threadedImportTask2 = this;
            synchronized (threadedImportTask2) {
                this.isRunning = false;
            }
        }
    }

    protected String getValidNameFromFileName(String fileName) {
        String name = IdUtils.generateId((String)fileName, (String)"-", (boolean)true, (int)100);
        name = name.replace("'", "");
        name = name.replace("(", "");
        name = name.replace(")", "");
        name = name.replace("+", "");
        return name;
    }

    public void dispose() {
        try {
            CoreInstance.getInstance().close(this.session);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setSkipContainerCreation(Boolean skipContainerCreation) {
        this.skipContainerCreation = skipContainerCreation;
    }

    public void setRootTask() {
        this.isRootTask = true;
        taskCounter = 0;
        this.taskId = "T0";
    }
}

