/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.shell.commands.scripting;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.shell.Command;
import org.nuxeo.ecm.shell.CommandDescriptor;
import org.nuxeo.ecm.shell.CommandOption;
import org.nuxeo.ecm.shell.CommandParameter;
import org.nuxeo.ecm.shell.commands.scripting.ScriptingCommand;
import org.nuxeo.ecm.shell.header.CommandArgument;
import org.nuxeo.ecm.shell.header.CommandHeader;
import org.nuxeo.ecm.shell.header.CommandPattern;
import org.nuxeo.ecm.shell.header.GroovyHeaderExtractor;
import org.nuxeo.ecm.shell.header.HeaderExtractor;
import org.nuxeo.ecm.shell.header.PyHeaderExtractor;

public class ScriptingCommandDescriptor
implements CommandDescriptor {
    protected static final Map<String, HeaderExtractor> extractors = new HashMap<String, HeaderExtractor>();
    protected CommandHeader header;
    protected final String name;
    protected final File file;
    protected long lastModified = 0L;
    protected ScriptingCommand cmd;

    public ScriptingCommandDescriptor(File file) {
        this.file = file;
        this.name = FileUtils.getFileNameNoExt((String)file.getName());
    }

    @Override
    public String[] getAliases() {
        return null;
    }

    @Override
    public CommandOption[] getOptions() {
        this.load();
        if (this.header == null) {
            return null;
        }
        CommandOption[] opts = new CommandOption[this.header.pattern.options.size()];
        int i = 0;
        for (org.nuxeo.ecm.shell.header.CommandOption o : this.header.pattern.options) {
            opts[i++] = this.toCommandOption(o);
        }
        return opts;
    }

    @Override
    public CommandParameter[] getArguments() {
        this.load();
        if (this.header == null) {
            return null;
        }
        CommandParameter[] args = new CommandParameter[this.header.pattern.args.size()];
        int i = 0;
        for (CommandArgument a : this.header.pattern.args) {
            args[i] = this.toCommandParam(a, i);
            ++i;
        }
        return args;
    }

    protected CommandOption toCommandOption(org.nuxeo.ecm.shell.header.CommandOption o) {
        CommandOption opt = new CommandOption();
        opt.setName(o.names[0]);
        opt.setCommand(this.getName());
        opt.setDefaultValue(o.defaultValue);
        opt.setType(o.type);
        opt.setIsVariable(o.type != null);
        opt.setShortcut(o.names.length > 1 ? o.names[1] : null);
        opt.setIsRequired(o.isRequired);
        return opt;
    }

    protected CommandParameter toCommandParam(CommandArgument a, int index) {
        CommandParameter param = new CommandParameter();
        param.type = a.type;
        param.index = index;
        return param;
    }

    @Override
    public String getDescription() {
        this.load();
        if (this.header == null) {
            return "N/A";
        }
        return this.header.description;
    }

    @Override
    public String getHelp() {
        this.load();
        if (this.header == null) {
            return "N/A";
        }
        return this.header.help;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean hasArguments() {
        CommandParameter[] args = this.getArguments();
        return args != null && args.length > 0;
    }

    @Override
    public boolean hasOptions() {
        CommandOption[] opts = this.getOptions();
        return opts != null && opts.length > 0;
    }

    @Override
    public boolean isDynamicScript() {
        return true;
    }

    @Override
    public Command newInstance() throws Exception {
        return this.getScriptingCommand();
    }

    @Override
    public int compareTo(CommandDescriptor o) {
        return this.getName().compareTo(o.getName());
    }

    public String toString() {
        return this.header.toString();
    }

    public void load() {
        try {
            this.getScriptingCommand();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptingCommand getScriptingCommand() throws Exception {
        if (this.file.lastModified() > this.lastModified) {
            String ext = FileUtils.getFileExtension((String)this.file.getName());
            if (ext == null) {
                throw new IllegalArgumentException("Script File must have a valid extension: " + this.file.getAbsolutePath());
            }
            this.cmd = new ScriptingCommand(this.file);
            HeaderExtractor extractor = extractors.get(ext);
            if (extractor != null) {
                FileReader reader = new FileReader(this.file);
                try {
                    this.header = extractor.extractHeader(reader);
                    if (this.header != null) {
                        if (this.header.description == null) {
                            this.header.description = "N/A";
                        }
                        if (this.header.help == null) {
                            this.header.help = "N/A";
                        }
                        if (this.header.pattern == null) {
                            this.header.pattern = new CommandPattern();
                            this.header.pattern.names = new String[]{this.getName()};
                        }
                    }
                }
                finally {
                    reader.close();
                }
            }
        }
        return this.cmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompiledScript compileScript(ScriptEngine engine, File file) throws ScriptException {
        if (engine instanceof Compilable) {
            CompiledScript compiledScript;
            Compilable comp = (Compilable)((Object)engine);
            FileReader reader = new FileReader(file);
            try {
                compiledScript = comp.compile(reader);
            }
            catch (Throwable throwable) {
                try {
                    ((Reader)reader).close();
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ScriptException(e);
                }
            }
            ((Reader)reader).close();
            return compiledScript;
        }
        return null;
    }

    static {
        extractors.put("groovy", new GroovyHeaderExtractor());
        extractors.put("py", new PyHeaderExtractor());
        extractors.put("js", new GroovyHeaderExtractor());
    }
}

