/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.shell.commands.user;

import au.com.bytecode.opencsv.CSVReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.repository.RepositoryInstance;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.shell.CommandLine;
import org.nuxeo.ecm.shell.commands.repository.AbstractCommand;
import org.nuxeo.runtime.api.Framework;

public class GroupModCommand
extends AbstractCommand {
    private static final Log log = LogFactory.getLog(GroupModCommand.class);
    public static final String COMMAND_NAME = "groupmod";
    public static final int CSV_COLUMN_COUNT = 1;
    public static final String GROUP_DIRECTORY_NAME = "groupDirectory";

    public void printUsage() {
        log.error((Object)"Usage:\ngroupmod --file USERS_FILE.csv\ngroupmod --user username groupname");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(CommandLine cmdLine) throws Exception {
        String[] elements = cmdLine.getParameters();
        if (elements.length != 1) {
            this.printUsage();
            return;
        }
        String groupName = elements[0];
        boolean importThroughCsv = false;
        File csvFile = null;
        String userName = null;
        String optionName = "file";
        if (cmdLine.isOptionSet(optionName)) {
            String csvFileName = cmdLine.getOption(optionName);
            log.debug((Object)("Reading user definitions of CSV file " + csvFileName));
            csvFile = new File(csvFileName);
            importThroughCsv = true;
        } else {
            optionName = "user";
            if (cmdLine.isOptionSet(optionName)) {
                userName = cmdLine.getOption(optionName);
                log.debug((Object)("Adding user " + userName + " to group " + groupName + " ..."));
            } else {
                this.printUsage();
                return;
            }
        }
        optionName = "set";
        boolean appendUsers = true;
        if (cmdLine.isOptionSet(optionName)) {
            appendUsers = false;
        }
        RepositoryInstance repository = null;
        Session directorySession = null;
        try {
            repository = this.context.getRepositoryInstance();
            log.debug((Object)("Repository connection: " + repository));
            DirectoryService dirService = (DirectoryService)Framework.getService(DirectoryService.class);
            log.debug((Object)("Directory names: " + dirService.getDirectoryNames()));
            directorySession = dirService.open(GROUP_DIRECTORY_NAME);
            if (importThroughCsv) {
                this.importCsvFile(csvFile, appendUsers, groupName, directorySession);
            } else {
                this.modifyGroup(Collections.singletonList(userName), appendUsers, groupName, directorySession);
            }
        }
        finally {
            if (directorySession != null) {
                directorySession.close();
            }
            if (repository != null) {
                repository.close();
            }
        }
    }

    private void importCsvFile(File file, boolean appendUsers, String groupName, Session directorySession) throws Exception {
        String[] nextLine;
        CSVReader csvReader = new CSVReader((Reader)new FileReader(file));
        ArrayList<String> userNames = new ArrayList<String>();
        boolean firstLine = true;
        while ((nextLine = csvReader.readNext()) != null) {
            if (!firstLine) {
                if (nextLine.length == 0 || nextLine.length == 1 && (nextLine[0] == null || "".equals(nextLine[0]))) continue;
                if (nextLine.length == 1) {
                    userNames.add(nextLine[0]);
                } else {
                    log.error((Object)("The following CSV line will not be imported because it hasn't the required 1 field \n" + Arrays.asList(nextLine)));
                }
            }
            firstLine = false;
        }
        csvReader.close();
        this.modifyGroup(userNames, appendUsers, groupName, directorySession);
    }

    private void modifyGroup(List<String> userNames, boolean appendUsers, String groupName, Session directorySession) throws Exception {
        List groupMemberNames;
        DocumentModel entry = directorySession.getEntry(groupName);
        log.debug((Object)("Entry = " + entry));
        if (entry == null) {
            log.error((Object)("The group denoted by \"" + groupName + "\" doesn't exist in the directory."));
            return;
        }
        if (appendUsers) {
            groupMemberNames = (List)entry.getProperty("group", "members");
            groupMemberNames.addAll(userNames);
        } else {
            groupMemberNames = userNames;
        }
        entry.setProperty("group", "members", (Object)groupMemberNames);
        directorySession.updateEntry(entry);
        log.info((Object)("Group " + groupName + " updated successfully."));
    }
}

