/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.shell.commands.user;

import au.com.bytecode.opencsv.CSVReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.repository.RepositoryInstance;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.shell.CommandLine;
import org.nuxeo.ecm.shell.commands.repository.AbstractCommand;
import org.nuxeo.runtime.api.Framework;

public class UserAddCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "useradd";
    public static final int USERS_CSV_COLUMN_COUNT = 5;
    public static final String[] USERS_CSV_FIELD_NAMES = new String[]{"username", "firstName", "lastName", "email", "company"};
    public static final String USER_DIRECTORY_NAME = "userDirectory";
    private static final Log log = LogFactory.getLog(UserAddCommand.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(CommandLine cmdLine) throws Exception {
        String[] elements = cmdLine.getParameters();
        if (elements.length > 1) {
            log.error((Object)"Usage:\nuseradd --file USERS_FILE.csv\nuseradd username");
            return;
        }
        boolean importThroughCsv = false;
        File csvFile = null;
        HashMap<String, Object> userFields = new HashMap<String, Object>();
        String optionName = null;
        optionName = "file";
        if (cmdLine.isOptionSet(optionName)) {
            String csvFileName = cmdLine.getOption(optionName);
            log.debug((Object)("Reading user definitions of CSV file " + csvFileName));
            csvFile = new File(csvFileName);
            importThroughCsv = true;
        } else {
            String userName = elements[0];
            log.debug((Object)("Creating user " + userName + " ..."));
            userFields.put("username", userName);
            optionName = "firstname";
            if (cmdLine.isOptionSet(optionName)) {
                userFields.put("firstName", cmdLine.getOption(optionName));
            }
            if (cmdLine.isOptionSet(optionName = "lastname")) {
                userFields.put("lastName", cmdLine.getOption(optionName));
            }
            if (cmdLine.isOptionSet(optionName = "email")) {
                userFields.put("email", cmdLine.getOption(optionName));
            }
            if (cmdLine.isOptionSet(optionName = "company")) {
                userFields.put("company", cmdLine.getOption(optionName));
            }
        }
        RepositoryInstance repository = null;
        Session directorySession = null;
        try {
            repository = this.context.getRepositoryInstance();
            log.debug((Object)("Repository connection: " + repository));
            DirectoryService dirService = (DirectoryService)Framework.getService(DirectoryService.class);
            log.debug((Object)("Directory names: " + dirService.getDirectoryNames()));
            directorySession = dirService.open(USER_DIRECTORY_NAME);
            if (importThroughCsv) {
                this.importCsvFile(csvFile, directorySession);
            } else {
                this.createUser(userFields, directorySession);
            }
        }
        finally {
            if (directorySession != null) {
                directorySession.close();
            }
            if (repository != null) {
                repository.close();
            }
        }
    }

    private void importCsvFile(File file, Session directorySession) throws Exception {
        String[] nextLine;
        CSVReader csvReader = null;
        csvReader = new CSVReader((Reader)new FileReader(file));
        ArrayList<String[]> users = new ArrayList<String[]>();
        boolean firstLine = true;
        while ((nextLine = csvReader.readNext()) != null) {
            if (!firstLine) {
                if (nextLine.length == 0 || nextLine.length == 1 && (nextLine[0] == null || "".equals(nextLine[0]))) continue;
                if (nextLine.length == 5) {
                    users.add(nextLine);
                } else {
                    log.error((Object)("The following CSV line will not be imported because it hasn't the required 5 fields " + Arrays.asList(USERS_CSV_FIELD_NAMES) + "\n" + Arrays.asList(nextLine)));
                }
            }
            firstLine = false;
        }
        csvReader.close();
        for (String[] user : users) {
            HashMap<String, Object> userFields = new HashMap<String, Object>();
            userFields.put("username", user[0]);
            userFields.put("firstName", user[1]);
            userFields.put("lastName", user[2]);
            userFields.put("email", user[3]);
            userFields.put("company", user[4]);
            this.createUser(userFields, directorySession);
        }
    }

    private void createUser(Map<String, Object> userFields, Session directorySession) throws Exception {
        directorySession.createEntry(userFields);
        log.info((Object)("User " + userFields.get("username") + " created successfully."));
    }
}

