/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.core.api.model.DocumentPart;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.api.model.PropertyVisitor;
import org.nuxeo.ecm.core.api.model.impl.ListProperty;
import org.nuxeo.ecm.core.api.model.impl.MapProperty;
import org.nuxeo.ecm.core.api.model.impl.ScalarProperty;
import org.nuxeo.ecm.core.api.model.impl.primitives.BlobProperty;
import org.nuxeo.ecm.core.schema.types.QName;

public class ValueExporter
implements PropertyVisitor {
    private final Map<String, Serializable> result = new HashMap<String, Serializable>();
    private final boolean prefixed;

    public ValueExporter(boolean prefixed) {
        this.prefixed = prefixed;
    }

    public Map<String, Serializable> getResult() {
        return this.result;
    }

    public Map<String, Serializable> run(DocumentPart dp) throws PropertyException {
        dp.accept(this, this.result);
        return this.result;
    }

    protected String getName(Property property) {
        QName name = property.getField().getName();
        return this.prefixed ? name.getPrefixedName() : name.getLocalName();
    }

    @Override
    public boolean acceptPhantoms() {
        return false;
    }

    @Override
    public Object visit(MapProperty property, Object arg) throws PropertyException {
        Serializable value = property.isContainer() ? new HashMap() : property.getValue();
        if (BlobProperty.class.isAssignableFrom(property.getClass())) {
            value = property.getValue();
            if (property.getParent().isList()) {
                ((Collection)arg).add(value);
            } else {
                ((Map)arg).put(this.getName(property), value);
            }
            return null;
        }
        if (property.getParent().isList()) {
            ((Collection)arg).add(value);
        } else {
            ((Map)arg).put(this.getName(property), value);
        }
        return value;
    }

    @Override
    public Object visit(ListProperty property, Object arg) throws PropertyException {
        ArrayList value = property.isContainer() ? new ArrayList() : property.getValue();
        if (property.getParent().isList()) {
            ((Collection)arg).add(value);
        } else {
            ((Map)arg).put(this.getName(property), value);
        }
        return value;
    }

    @Override
    public Object visit(ScalarProperty property, Object arg) throws PropertyException {
        Serializable value = property.getValue();
        if (property.getParent().isList()) {
            ((Collection)arg).add(value);
        } else {
            ((Map)arg).put(this.getName(property), value);
        }
        return null;
    }
}

