/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.Escaper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonElementVisitor;
import com.google.gson.JsonFormatter;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonTreeNavigator;
import java.io.IOException;

final class JsonPrintFormatter
implements JsonFormatter {
    private final int printMargin;
    private final int indentationSize;
    private final int rightMargin;
    private final boolean escapeHtmlChars;
    public static final int DEFAULT_PRINT_MARGIN = 80;
    public static final int DEFAULT_INDENTATION_SIZE = 2;
    public static final int DEFAULT_RIGHT_MARGIN = 4;

    JsonPrintFormatter() {
        this(true);
    }

    JsonPrintFormatter(boolean escapeHtmlChars) {
        this(80, 2, 4, escapeHtmlChars);
    }

    JsonPrintFormatter(int printMargin, int indentationSize, int rightMargin, boolean escapeHtmlChars) {
        this.printMargin = printMargin;
        this.indentationSize = indentationSize;
        this.rightMargin = rightMargin;
        this.escapeHtmlChars = escapeHtmlChars;
    }

    public void format(JsonElement root, Appendable writer, boolean serializeNulls) throws IOException {
        if (root == null) {
            return;
        }
        JsonWriter jsonWriter = new JsonWriter(writer);
        PrintFormattingVisitor visitor = new PrintFormattingVisitor(jsonWriter, new Escaper(this.escapeHtmlChars), serializeNulls);
        JsonTreeNavigator navigator = new JsonTreeNavigator(visitor, serializeNulls);
        navigator.navigate(root);
        jsonWriter.finishLine();
    }

    private class PrintFormattingVisitor
    implements JsonElementVisitor {
        private final JsonWriter writer;
        private final Escaper escaper;
        private final boolean serializeNulls;

        PrintFormattingVisitor(JsonWriter writer, Escaper escaper, boolean serializeNulls) {
            this.writer = writer;
            this.escaper = escaper;
            this.serializeNulls = serializeNulls;
        }

        private void addCommaCheckingFirst(boolean first) throws IOException {
            if (!first) {
                this.writer.elementSeparator();
            }
        }

        public void startArray(JsonArray array) throws IOException {
            this.writer.beginArray();
        }

        public void visitArrayMember(JsonArray parent, JsonPrimitive member, boolean isFirst) throws IOException {
            this.addCommaCheckingFirst(isFirst);
            this.writer.value(this.escapeJsonPrimitive(member));
        }

        public void visitArrayMember(JsonArray parent, JsonArray member, boolean first) throws IOException {
            this.addCommaCheckingFirst(first);
        }

        public void visitArrayMember(JsonArray parent, JsonObject member, boolean first) throws IOException {
            this.addCommaCheckingFirst(first);
        }

        public void visitNullArrayMember(JsonArray parent, boolean isFirst) throws IOException {
            this.addCommaCheckingFirst(isFirst);
        }

        public void endArray(JsonArray array) {
            this.writer.endArray();
        }

        public void startObject(JsonObject object) throws IOException {
            this.writer.beginObject();
        }

        public void visitObjectMember(JsonObject parent, String memberName, JsonPrimitive member, boolean isFirst) throws IOException {
            this.addCommaCheckingFirst(isFirst);
            this.writer.key(memberName);
            this.writer.fieldSeparator();
            this.writer.value(this.escapeJsonPrimitive(member));
        }

        public void visitObjectMember(JsonObject parent, String memberName, JsonArray member, boolean isFirst) throws IOException {
            this.addCommaCheckingFirst(isFirst);
            this.writer.key(memberName);
            this.writer.fieldSeparator();
        }

        public void visitObjectMember(JsonObject parent, String memberName, JsonObject member, boolean isFirst) throws IOException {
            this.addCommaCheckingFirst(isFirst);
            this.writer.key(memberName);
            this.writer.fieldSeparator();
        }

        public void visitNullObjectMember(JsonObject parent, String memberName, boolean isFirst) throws IOException {
            if (this.serializeNulls) {
                this.visitObjectMember(parent, memberName, (JsonObject)null, isFirst);
            }
        }

        public void endObject(JsonObject object) {
            this.writer.endObject();
        }

        public void visitPrimitive(JsonPrimitive primitive) throws IOException {
            this.writer.value(this.escapeJsonPrimitive(primitive));
        }

        public void visitNull() throws IOException {
            this.writer.value("null");
        }

        private String escapeJsonPrimitive(JsonPrimitive member) throws IOException {
            StringBuilder builder = new StringBuilder();
            member.toString(builder, this.escaper);
            return builder.toString();
        }
    }

    private class JsonWriter {
        private final Appendable writer;
        private StringBuilder line;
        private int level;

        JsonWriter(Appendable writer) {
            this.writer = writer;
            this.level = 0;
            this.line = new StringBuilder();
        }

        void key(String key) throws IOException {
            this.breakLineIfThisToNextExceedsLimit(key.length() + 2);
            this.getLine().append('\"');
            this.getLine().append(key);
            this.getLine().append('\"');
        }

        void value(String value) throws IOException {
            this.breakLineIfThisToNextExceedsLimit(value.length() + 2);
            this.getLine().append(value);
        }

        void fieldSeparator() throws IOException {
            this.getLine().append(':');
            this.breakLineIfNeeded();
        }

        void elementSeparator() throws IOException {
            this.getLine().append(',');
            this.breakLineIfNeeded();
        }

        void beginObject() throws IOException {
            this.breakLineIfNeeded();
            this.getLine().append('{');
            ++this.level;
        }

        void endObject() {
            this.getLine().append('}');
            --this.level;
        }

        void beginArray() throws IOException {
            this.breakLineIfNeeded();
            this.getLine().append('[');
            ++this.level;
        }

        void endArray() {
            this.getLine().append(']');
            --this.level;
        }

        private void breakLineIfNeeded() throws IOException {
            this.breakLineIfThisToNextExceedsLimit(0);
        }

        private void breakLineIfThisToNextExceedsLimit(int nextLength) throws IOException {
            if (this.getLine().length() + nextLength > JsonPrintFormatter.this.printMargin - JsonPrintFormatter.this.rightMargin) {
                this.finishLine();
            }
        }

        private void finishLine() throws IOException {
            if (this.line != null) {
                this.writer.append(this.line).append("\n");
            }
            this.line = null;
        }

        private StringBuilder getLine() {
            if (this.line == null) {
                this.createNewLine();
            }
            return this.line;
        }

        private void createNewLine() {
            this.line = new StringBuilder();
            for (int i = 0; i < this.level; ++i) {
                for (int j = 0; j < JsonPrintFormatter.this.indentationSize; ++j) {
                    this.line.append(' ');
                }
            }
        }
    }
}

