/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.activity.stream;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.nuxeo.ecm.activity.ActivitiesList;
import org.nuxeo.ecm.activity.ActivitiesListImpl;
import org.nuxeo.ecm.activity.Activity;
import org.nuxeo.ecm.activity.ActivityHelper;
import org.nuxeo.ecm.activity.ActivityStream;
import org.nuxeo.ecm.activity.ActivityStreamFilter;
import org.nuxeo.ecm.activity.ActivityStreamService;
import org.nuxeo.ecm.activity.ActivityStreamServiceImpl;
import org.nuxeo.ecm.social.relationship.RelationshipKind;
import org.nuxeo.ecm.social.relationship.service.RelationshipService;
import org.nuxeo.runtime.api.Framework;

public class UserActivityStreamFilter
implements ActivityStreamFilter {
    public static final String ID = "UserActivityStreamFilter";
    public static final String QUERY_TYPE_PARAMETER = "queryType";
    public static final String ACTOR_PARAMETER = "actor";
    public static final String USER_ACTIVITY_STREAM_NAME = "userActivityStream";

    public String getId() {
        return ID;
    }

    public boolean isInterestedIn(Activity activity) {
        return false;
    }

    public void handleNewActivity(ActivityStreamService activityStreamService, Activity activity) {
    }

    public void handleRemovedActivities(ActivityStreamService activityStreamService, Collection<Serializable> activityIds) {
    }

    public ActivitiesList query(ActivityStreamService activityStreamService, Map<String, Serializable> parameters, long offset, long limit) {
        Query query;
        QueryType queryType = (QueryType)((Object)parameters.get(QUERY_TYPE_PARAMETER));
        if (queryType == null) {
            throw new IllegalArgumentException("queryType is required.");
        }
        String actor = (String)((Object)parameters.get(ACTOR_PARAMETER));
        if (actor == null) {
            throw new IllegalArgumentException("actor is required");
        }
        actor = ActivityHelper.createUserActivityObject((String)actor);
        ActivityStream userActivityStream = activityStreamService.getActivityStream(USER_ACTIVITY_STREAM_NAME);
        List verbs = userActivityStream.getVerbs();
        List relationshipKinds = userActivityStream.getRelationshipKinds();
        EntityManager em = ((ActivityStreamServiceImpl)activityStreamService).getEntityManager();
        switch (queryType) {
            case ACTIVITY_STREAM_FOR_ACTOR: {
                RelationshipService relationshipService = (RelationshipService)Framework.getLocalService(RelationshipService.class);
                ArrayList actors = new ArrayList();
                for (String relationshipKind : relationshipKinds) {
                    actors.addAll(relationshipService.getTargetsOfKind(actor, RelationshipKind.fromString((String)relationshipKind)));
                }
                if (actors.isEmpty()) {
                    return new ActivitiesListImpl();
                }
                query = em.createQuery("select activity from Activity activity where activity.actor in (:actors) and activity.verb in (:verbs) order by activity.publishedDate desc");
                query.setParameter("actors", actors);
                query.setParameter("verbs", (Object)verbs);
                break;
            }
            case ACTIVITY_STREAM_FROM_ACTOR: {
                query = em.createQuery("select activity from Activity activity where activity.actor = :actor and activity.verb in (:verbs) order by activity.publishedDate desc");
                query.setParameter(ACTOR_PARAMETER, (Object)actor);
                query.setParameter("verbs", (Object)verbs);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid QueryType parameter");
            }
        }
        if (limit > 0L) {
            query.setMaxResults((int)limit);
            if (offset > 0L) {
                query.setFirstResult((int)offset);
            }
        }
        return new ActivitiesListImpl((Collection)query.getResultList());
    }

    public static enum QueryType {
        ACTIVITY_STREAM_FOR_ACTOR,
        ACTIVITY_STREAM_FROM_ACTOR;

    }
}

