/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.reload;

import java.lang.reflect.Method;
import java.net.URL;

public class MutableClassLoaderDelegate {
    protected final ClassLoader cl;
    protected Method addURL;

    public MutableClassLoaderDelegate(ClassLoader cl) {
        this.cl = cl;
        Class<?> clazz = cl.getClass();
        do {
            try {
                this.addURL = clazz.getDeclaredMethod("addURL", URL.class);
            }
            catch (NoSuchMethodException e) {
                clazz = clazz.getSuperclass();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to adapt class loader: " + cl.getClass(), e);
            }
        } while (this.addURL == null && clazz != null);
        if (this.addURL == null) {
            throw new IllegalArgumentException("Incompatible class loader: " + cl.getClass() + ". ClassLoader must provide a method: addURL(URL url)");
        }
        this.addURL.setAccessible(true);
    }

    public void addURL(URL url) {
        try {
            this.addURL.invoke((Object)this.cl, url);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to add URL to class loader: " + url, e);
        }
    }

    public ClassLoader getClassLoader() {
        return this.cl;
    }
}

