/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.ldap;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.schema.NXSchema;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.directory.AbstractDirectory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.DirectoryFieldMapper;
import org.nuxeo.ecm.directory.Reference;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.ldap.ContextProvider;
import org.nuxeo.ecm.directory.ldap.LDAPDirectoryDescriptor;
import org.nuxeo.ecm.directory.ldap.LDAPDirectoryFactory;
import org.nuxeo.ecm.directory.ldap.LDAPDynamicReferenceDescriptor;
import org.nuxeo.ecm.directory.ldap.LDAPReference;
import org.nuxeo.ecm.directory.ldap.LDAPServerDescriptor;
import org.nuxeo.ecm.directory.ldap.LDAPSession;
import org.nuxeo.runtime.api.Framework;

public class LDAPDirectory
extends AbstractDirectory {
    private static final Log log = LogFactory.getLog(LDAPDirectory.class);
    public static final String DN_SPECIAL_ATTRIBUTE_KEY = "dn";
    protected final LDAPDirectoryDescriptor config;
    protected final Properties contextProperties;
    protected final SearchControls searchControls;
    protected final Map<String, Field> schemaFieldMap;
    protected final LDAPDirectoryFactory factory;
    protected final List<Session> sessions = new LinkedList<Session>();
    protected final String baseFilter;
    protected ContextProvider testServer;

    public LDAPDirectory(LDAPDirectoryDescriptor config) throws ClientException {
        this.config = config;
        this.factory = (LDAPDirectoryFactory)((Object)Framework.getRuntime().getComponent("org.nuxeo.ecm.directory.ldap.LDAPDirectoryFactory"));
        if (config.getIdField() == null || config.getIdField().equals("")) {
            throw new DirectoryException("idField configuration is missing for directory " + config.getName());
        }
        if (config.getSchemaName() == null || config.getSchemaName().equals("")) {
            throw new DirectoryException("schema configuration is missing for directory " + config.getName());
        }
        if (config.getSearchBaseDn() == null || config.getSearchBaseDn().equals("")) {
            throw new DirectoryException("searchBaseDn configuration is missing for directory " + config.getName());
        }
        Schema schema = NXSchema.getSchemaManager().getSchema(config.getSchemaName());
        if (schema == null) {
            throw new DirectoryException(config.getSchemaName() + " is not a registered schema");
        }
        this.schemaFieldMap = new LinkedHashMap<String, Field>();
        for (Field f : schema.getFields()) {
            this.schemaFieldMap.put(f.getName().getLocalName(), f);
        }
        this.fieldMapper = new DirectoryFieldMapper(config.fieldMapping);
        this.contextProperties = this.computeContextProperties();
        this.baseFilter = config.getAggregatedSearchFilter();
        this.addReferences(config.getInverseReferences());
        this.addReferences(config.getLdapReferences());
        this.searchControls = this.computeSearchControls();
        this.cache.setMaxSize(config.getCacheMaxSize());
        this.cache.setTimeout(config.getCacheTimeout());
        log.debug((Object)String.format("initialized LDAP directory %s with fields [%s] and references [%s]", config.getName(), StringUtils.join((Object[])this.schemaFieldMap.keySet().toArray(), (String)", "), StringUtils.join((Object[])this.references.keySet().toArray(), (String)", ")));
    }

    protected Properties computeContextProperties() throws DirectoryException {
        String bindDn;
        Properties props = new Properties();
        LDAPServerDescriptor serverConfig = this.getServer();
        if (null == serverConfig) {
            throw new DirectoryException("LDAP server configuration not found: " + this.config.getServerName());
        }
        props.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        String ldapUrls = serverConfig.getLdapUrls();
        if (serverConfig.getLdapUrls() == null || this.config.getSchemaName().equals("")) {
            throw new DirectoryException("Server LDAP URL configuration is missing for directory " + this.config.getName());
        }
        props.put("java.naming.provider.url", ldapUrls);
        props.put("java.naming.referral", "follow");
        if (serverConfig.getConnectionTimeout() > -1) {
            if (!serverConfig.useSsl()) {
                props.put("com.sun.jndi.ldap.connect.timeout", Integer.toString(serverConfig.getConnectionTimeout()));
            } else {
                log.warn((Object)"SSL connections do not operate correctly when used with the connection timeout parameter, disabling timout");
            }
        }
        if ((bindDn = serverConfig.getBindDn()) != null) {
            props.put("java.naming.security.principal", bindDn);
            props.put("java.naming.security.credentials", serverConfig.getBindPassword());
        }
        if (serverConfig.isPoolingEnabled()) {
            props.put("com.sun.jndi.ldap.connect.pool", "true");
            props.put("com.sun.jndi.ldap.connect.pool.protocol", "plain ssl");
            props.put("com.sun.jndi.ldap.connect.pool.authentication", "none simple DIGEST-MD5");
            props.put("com.sun.jndi.ldap.connect.pool.timeout", "1800000");
        }
        return props;
    }

    public Properties getContextProperties() {
        return this.contextProperties;
    }

    protected SearchControls computeSearchControls() throws DirectoryException {
        SearchControls scts = new SearchControls();
        scts.setSearchScope(this.config.getSearchScope());
        HashSet<String> attrs = new HashSet<String>();
        attrs.addAll(this.fieldMapper.getBackendFields(this.schemaFieldMap.keySet()));
        attrs.add("objectClass");
        for (Reference reference : this.references.values()) {
            if (!(reference instanceof LDAPReference)) continue;
            LDAPReference ldapReference = (LDAPReference)reference;
            attrs.add(ldapReference.getStaticAttributeId(this.fieldMapper));
            attrs.add(ldapReference.getDynamicAttributeId());
            for (LDAPDynamicReferenceDescriptor dynAtt : ldapReference.getDynamicAttributes()) {
                attrs.add(dynAtt.baseDN);
                attrs.add(dynAtt.filter);
            }
        }
        if (this.config.getPasswordField() != null) {
            attrs.remove(this.config.getPasswordField());
        }
        scts.setReturningAttributes(attrs.toArray(new String[attrs.size()]));
        scts.setCountLimit(this.config.getQuerySizeLimit());
        scts.setTimeLimit(this.config.getQueryTimeLimit());
        return scts;
    }

    public SearchControls getSearchControls() {
        return this.getSearchControls(false);
    }

    public SearchControls getSearchControls(boolean fetchAllAttributes) {
        if (fetchAllAttributes) {
            SearchControls scts = new SearchControls();
            scts.setSearchScope(this.config.getSearchScope());
            return scts;
        }
        return this.searchControls;
    }

    protected DirContext createContext() throws DirectoryException {
        try {
            String serverName = this.config.getServerName();
            if (serverName == null || serverName.equals("")) {
                throw new DirectoryException("server configuration is missing for directory " + this.config.getName());
            }
            LDAPServerDescriptor serverConfig = this.getServer();
            if (serverConfig.isDynamicServerList()) {
                String ldapUrls = serverConfig.getLdapUrls();
                this.contextProperties.put("java.naming.provider.url", ldapUrls);
            }
            return new InitialDirContext(this.contextProperties);
        }
        catch (NamingException e) {
            throw new DirectoryException("Cannot connect to LDAP directory '" + this.getName() + "': " + e.getMessage(), (Throwable)e);
        }
    }

    public String getName() {
        return this.config.getName();
    }

    public String getSchema() {
        return this.config.getSchemaName();
    }

    public String getParentDirectory() {
        return null;
    }

    public String getIdField() {
        return this.config.getIdField();
    }

    public String getPasswordField() {
        return this.config.getPasswordField();
    }

    public LDAPServerDescriptor getServer() {
        return this.factory.getServer(this.config.getServerName());
    }

    public Session getSession() throws DirectoryException {
        DirContext context = this.testServer != null ? this.testServer.getContext() : this.createContext();
        LDAPSession session = new LDAPSession(this, context);
        this.addSession((Session)session);
        return session;
    }

    public synchronized void removeSession(Session session) {
        this.sessions.remove(session);
    }

    public synchronized void addSession(Session session) {
        this.sessions.add(session);
    }

    protected synchronized void clearSessions() {
        this.sessions.clear();
    }

    public void shutdown() {
        try {
            ArrayList<Session> sessionsToClose = new ArrayList<Session>();
            sessionsToClose.addAll(this.sessions);
            for (Session session : sessionsToClose) {
                session.close();
            }
            this.clearSessions();
        }
        catch (ClientException e) {
            log.error((Object)"exception during shutdown", (Throwable)e);
        }
    }

    public String getBaseFilter() {
        String idField = this.getIdField();
        DirectoryFieldMapper fieldMapper = this.getFieldMapper();
        String idAttribute = fieldMapper.getBackendField(idField);
        String idFilter = String.format("(%s=*)", idAttribute);
        if (this.baseFilter != null && !"".equals(this.baseFilter)) {
            if (this.baseFilter.startsWith("(")) {
                return String.format("(&%s%s)", this.baseFilter, idFilter);
            }
            return String.format("(&(%s)%s)", this.baseFilter, idFilter);
        }
        return idFilter;
    }

    public LDAPDirectoryDescriptor getConfig() {
        return this.config;
    }

    public Map<String, Field> getSchemaFieldMap() {
        return this.schemaFieldMap;
    }

    public void setTestServer(ContextProvider testServer) {
        this.testServer = testServer;
    }
}

