/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.DirectoryFactory;
import org.nuxeo.ecm.directory.DirectoryServiceImpl;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.directory.sql.SQLDirectoryDescriptor;
import org.nuxeo.ecm.directory.sql.SQLDirectoryProxy;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;

public class SQLDirectoryFactory
extends DefaultComponent
implements DirectoryFactory {
    public static final ComponentName NAME = new ComponentName("org.nuxeo.ecm.directory.sql.SQLDirectoryFactory");
    private static final Log log = LogFactory.getLog(SQLDirectoryFactory.class);
    public List<SQLDirectoryDescriptor> descriptors = new ArrayList<SQLDirectoryDescriptor>();
    private Map<String, Directory> directories;

    public Directory getDirectory(String name) throws DirectoryException {
        return this.directories.get(name);
    }

    public String getName() {
        return NAME.getName();
    }

    public void activate(ComponentContext context) {
        this.directories = new LinkedHashMap<String, Directory>();
    }

    public void deactivate(ComponentContext context) {
        try {
            this.shutdown();
        }
        catch (DirectoryException e) {
            log.error((Object)"Error shutting down sql directories", (Throwable)e);
        }
        this.directories = null;
    }

    protected static DirectoryServiceImpl getDirectoryService() {
        return (DirectoryServiceImpl)Framework.getRuntime().getComponent(DirectoryService.NAME);
    }

    public void registerExtension(Extension extension) throws Exception {
        Object[] contribs;
        for (Object contrib : contribs = extension.getContributions()) {
            SQLDirectoryDescriptor descriptor = (SQLDirectoryDescriptor)contrib;
            String directoryName = descriptor.getName();
            if (descriptor.getRemove()) {
                log.info((Object)("Removing directory: " + directoryName));
            } else if (this.directories.containsKey(directoryName)) {
                log.info((Object)("Re-registered directory: " + directoryName));
            } else {
                log.info((Object)("Registered directory: " + directoryName));
            }
            this.addDescriptor(descriptor);
        }
    }

    protected void addDescriptor(SQLDirectoryDescriptor descriptor) {
        this.descriptors.add(descriptor);
        this.refresh();
    }

    protected void removeDescriptor(SQLDirectoryDescriptor descriptor) {
        this.descriptors.remove(descriptor);
        this.refresh();
    }

    protected void refresh() {
        DirectoryServiceImpl dirService = SQLDirectoryFactory.getDirectoryService();
        for (Map.Entry<String, Directory> es : this.directories.entrySet()) {
            String directoryName = es.getKey();
            Directory directory = es.getValue();
            dirService.unregisterDirectory(directoryName, (DirectoryFactory)this);
            try {
                directory.shutdown();
            }
            catch (DirectoryException e) {
                log.error((Object)("Error shutting down sql directory with name '" + directoryName + "'"), (Throwable)e);
            }
        }
        this.directories.clear();
        LinkedHashMap<String, SQLDirectoryDescriptor> effective = new LinkedHashMap<String, SQLDirectoryDescriptor>();
        for (SQLDirectoryDescriptor descriptor : this.descriptors) {
            String directoryName = descriptor.getName();
            if (descriptor.getRemove()) {
                effective.remove(directoryName);
                continue;
            }
            if (effective.containsKey(directoryName)) {
                SQLDirectoryDescriptor old = (SQLDirectoryDescriptor)effective.get(directoryName);
                descriptor.merge(old);
            }
            effective.put(directoryName, descriptor);
        }
        for (SQLDirectoryDescriptor descriptor : effective.values()) {
            String descriptorName = descriptor.getName();
            this.directories.put(descriptorName, new SQLDirectoryProxy(descriptor));
            dirService.registerDirectory(descriptorName, (DirectoryFactory)this);
        }
    }

    public void unregisterExtension(Extension extension) throws Exception {
        Object[] contribs;
        for (Object contrib : contribs = extension.getContributions()) {
            SQLDirectoryDescriptor descriptor = (SQLDirectoryDescriptor)contrib;
            String descriptorName = descriptor.getName();
            log.info((Object)("Unregistered directory: " + descriptorName));
            this.removeDescriptor(descriptor);
        }
    }

    public void shutdown() throws DirectoryException {
        for (Directory directory : this.directories.values()) {
            directory.shutdown();
        }
    }

    public List<Directory> getDirectories() throws DirectoryException {
        return new ArrayList<Directory>(this.directories.values());
    }
}

