/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.workspace.listeners;

import java.io.Serializable;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.social.workspace.adapters.SocialWorkspace;
import org.nuxeo.ecm.social.workspace.helper.SocialWorkspaceHelper;
import org.nuxeo.ecm.social.workspace.service.SocialWorkspaceService;
import org.nuxeo.runtime.api.Framework;

public class VisibilitySocialDocumentListener
implements PostCommitEventListener {
    public static final String ALREADY_PROCESSED = VisibilitySocialDocumentListener.class.getName();

    public void handleEvent(EventBundle events) throws ClientException {
        if (events.containsEventName("documentCreated") || events.containsEventName("documentModified")) {
            for (Event event : events) {
                if (!"documentCreated".equals(event.getName()) && !"documentModified".equals(event.getName())) continue;
                VisibilitySocialDocumentListener.handleEvent(event);
            }
        }
    }

    public static void handleEvent(Event event) throws ClientException {
        EventContext ctx = event.getContext();
        if (!(ctx instanceof DocumentEventContext)) {
            return;
        }
        DocumentModel document = ((DocumentEventContext)ctx).getSourceDocument();
        if (ctx.hasProperty(ALREADY_PROCESSED)) {
            return;
        }
        if (!SocialWorkspaceHelper.isSocialDocument(document)) {
            return;
        }
        SocialWorkspace socialWorkspace = VisibilitySocialDocumentListener.getSocialWorkspaceService().getDetachedSocialWorkspace(document);
        if (socialWorkspace == null) {
            return;
        }
        document.putContextData(ALREADY_PROCESSED, (Serializable)Boolean.valueOf(true));
        Boolean isPublic = (Boolean)document.getPropertyValue("socialdoc:isPublic");
        VisibilitySocialDocumentListener.updateSocialDocumentVisibility(document, isPublic == null ? false : isPublic);
    }

    private static void updateSocialDocumentVisibility(DocumentModel document, boolean isPublic) throws ClientException {
        if (isPublic) {
            SocialWorkspaceHelper.toSocialDocument(document).makePublic();
        } else {
            SocialWorkspaceHelper.toSocialDocument(document).restrictToMembers();
        }
    }

    private static SocialWorkspaceService getSocialWorkspaceService() {
        try {
            return (SocialWorkspaceService)Framework.getService(SocialWorkspaceService.class);
        }
        catch (Exception e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }
}

