/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.util;

import com.sun.facelets.FaceletContext;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ComponentTagUtils {
    private static final Log log = LogFactory.getLog(ComponentTagUtils.class);

    private ComponentTagUtils() {
    }

    public static boolean isValueReference(String value) {
        if (value == null) {
            return false;
        }
        return value.contains("#{") && value.indexOf("#{") < value.indexOf(125) || value.contains("${") && value.indexOf("${") < value.indexOf(125);
    }

    @Deprecated
    public static boolean isMethodReference(String value) {
        boolean isValue = ComponentTagUtils.isValueReference(value);
        return isValue && value.contains("(") && value.indexOf(40) < value.indexOf(41) && (!value.contains(":") || value.indexOf(58) > value.indexOf(40));
    }

    public static Object resolveElExpression(FacesContext context, String elExpression) {
        if (!ComponentTagUtils.isValueReference(elExpression)) {
            return elExpression;
        }
        if (context == null) {
            log.error((Object)String.format("FacesContext is null => cannot resolve el expression '%s'", elExpression));
            return null;
        }
        Application app = context.getApplication();
        try {
            return app.evaluateExpressionGet(context, elExpression, Object.class);
        }
        catch (Exception e) {
            log.error((Object)String.format("Faces context: Error processing expression '%s'", elExpression), (Throwable)e);
            return null;
        }
    }

    public static Object resolveElExpression(FaceletContext faceletContext, String elExpression) {
        if (!ComponentTagUtils.isValueReference(elExpression)) {
            return elExpression;
        }
        if (faceletContext == null) {
            log.error((Object)String.format("FaceletContext is null => cannot resolve el expression '%s'", elExpression));
            return null;
        }
        ExpressionFactory eFactory = faceletContext.getExpressionFactory();
        ELContext elContext = faceletContext.getFacesContext().getELContext();
        ValueExpression expr = eFactory.createValueExpression((ELContext)faceletContext, elExpression, Object.class);
        try {
            return expr.getValue(elContext);
        }
        catch (Exception e) {
            log.error((Object)String.format("Facelet context: Error processing expression '%s'", elExpression), (Throwable)e);
            return null;
        }
    }
}

