/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.opencmis.impl.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Policy;
import org.apache.chemistry.opencmis.client.runtime.ObjectIdImpl;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.ChangeEventInfo;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.FailedToDeleteData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderContainer;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderList;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.ObjectParentData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.enums.ChangeType;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.RelationshipDirection;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisContentAlreadyExistsException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.Converter;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractPropertyData;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.BindingsObjectFactoryImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ChangeEventInfoDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.FailedToDeleteDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectInFolderContainerImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectInFolderDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectInFolderListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectParentDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertiesImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIdImpl;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisTypeDefinitionListType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisTypeDefinitionType;
import org.apache.chemistry.opencmis.commons.impl.server.AbstractCmisService;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.ObjectInfo;
import org.apache.chemistry.opencmis.commons.spi.BindingsObjectFactory;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.impl.CompoundFilter;
import org.nuxeo.ecm.core.api.impl.FacetFilter;
import org.nuxeo.ecm.core.api.impl.LifeCycleFilter;
import org.nuxeo.ecm.core.api.impl.blob.ByteArrayBlob;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoObjectData;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoPropertyData;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoPropertyDataBase;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoRepositories;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoRepository;
import org.nuxeo.ecm.core.opencmis.impl.util.ListUtils;
import org.nuxeo.ecm.core.opencmis.impl.util.SimpleImageInfo;
import org.nuxeo.ecm.core.opencmis.impl.util.TypeManagerImpl;
import org.nuxeo.ecm.platform.audit.api.AuditReader;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.filemanager.api.FileManager;
import org.nuxeo.ecm.platform.mimetype.MimetypeNotFoundException;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.ecm.platform.mimetype.service.MimetypeRegistryService;
import org.nuxeo.runtime.api.Framework;

public class NuxeoCmisService
extends AbstractCmisService {
    public static final int DEFAULT_TYPE_LEVELS = 2;
    public static final int DEFAULT_FOLDER_LEVELS = 2;
    public static final int DEFAULT_CHANGE_LOG_SIZE = 100;
    public static final int DEFAULT_QUERY_SIZE = 100;
    public static final int DEFAULT_MAX_CHILDREN = 100;
    public static final int DEFAULT_MAX_RELATIONSHIPS = 100;
    public static final String NUXEO_WAR = "nuxeo.war";
    private static final Log log = LogFactory.getLog(NuxeoCmisService.class);
    protected final BindingsObjectFactory objectFactory = new BindingsObjectFactoryImpl();
    protected final NuxeoRepository repository;
    protected final CoreSession coreSession;
    protected final boolean coreSessionOwned;
    protected final Filter documentFilter;
    protected final CallContext callContext;
    protected static String REPLACE_QUOTE = Matcher.quoteReplacement("\\'");
    protected boolean collectObjectInfos = true;
    protected Map<String, ObjectInfo> objectInfos;

    public NuxeoCmisService(NuxeoRepository repository, CallContext callContext) {
        this.repository = repository;
        this.callContext = callContext;
        this.coreSession = repository == null ? null : this.openCoreSession(repository.getId());
        this.coreSessionOwned = true;
        this.documentFilter = this.getDocumentFilter();
    }

    public NuxeoCmisService(NuxeoRepository repository, CallContext callContext, CoreSession coreSession) {
        this.repository = repository;
        this.callContext = callContext;
        this.coreSession = coreSession;
        this.coreSessionOwned = false;
        this.documentFilter = this.getDocumentFilter();
    }

    public void close() {
        if (this.coreSession != null && this.coreSessionOwned) {
            this.closeCoreSession();
        }
        this.clearObjectInfos();
    }

    protected CoreSession openCoreSession(String repositoryId) {
        try {
            Repository repository = ((RepositoryManager)Framework.getService(RepositoryManager.class)).getRepository(repositoryId);
            if (repository == null) {
                throw new CmisRuntimeException("Cannot get repository: " + repositoryId);
            }
            return repository.open();
        }
        catch (CmisRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CmisRuntimeException(e.toString(), (Throwable)e);
        }
    }

    protected void closeCoreSession() {
        try {
            Repository.close((CoreSession)this.coreSession);
        }
        catch (Exception e) {
            throw new CmisRuntimeException(e.toString(), (Throwable)e);
        }
    }

    public NuxeoRepository getNuxeoRepository() {
        return this.repository;
    }

    public CoreSession getCoreSession() {
        return this.coreSession;
    }

    public BindingsObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public CallContext getCallContext() {
        return this.callContext;
    }

    protected Filter getDocumentFilter() {
        FacetFilter facetFilter = new FacetFilter("HiddenInNavigation", false);
        LifeCycleFilter lcFilter = new LifeCycleFilter("deleted", false);
        return new CompoundFilter(new Filter[]{facetFilter, lcFilter});
    }

    protected String getIdFromDocumentRef(DocumentRef ref) throws ClientException {
        if (ref instanceof IdRef) {
            return ((IdRef)ref).value;
        }
        return this.coreSession.getDocument(ref).getId();
    }

    public List<RepositoryInfo> getRepositoryInfos(ExtensionsData extension) {
        List<NuxeoRepository> repos = NuxeoRepositories.getRepositories();
        ArrayList<RepositoryInfo> infos = new ArrayList<RepositoryInfo>(repos.size());
        for (NuxeoRepository repo : repos) {
            String latestChangeLogToken = this.getLatestChangeLogToken(repo.getId());
            infos.add(repo.getRepositoryInfo(latestChangeLogToken));
        }
        return infos;
    }

    public RepositoryInfo getRepositoryInfo(String repositoryId, ExtensionsData extension) {
        String latestChangeLogToken = this.getLatestChangeLogToken(repositoryId);
        return NuxeoRepositories.getRepository(repositoryId).getRepositoryInfo(latestChangeLogToken);
    }

    public TypeDefinition getTypeDefinition(String repositoryId, String typeId, ExtensionsData extension) {
        TypeDefinition type = this.repository.getTypeDefinition(typeId);
        if (type == null) {
            throw new CmisInvalidArgumentException("No such type: " + typeId);
        }
        return Converter.convert((CmisTypeDefinitionType)Converter.convert((TypeDefinition)type));
    }

    public TypeDefinitionList getTypeChildren(String repositoryId, String typeId, Boolean includePropertyDefinitions, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        TypeDefinitionList types = this.repository.getTypeChildren(typeId, includePropertyDefinitions, maxItems, skipCount);
        return Converter.convert((CmisTypeDefinitionListType)Converter.convert((TypeDefinitionList)types));
    }

    public List<TypeDefinitionContainer> getTypeDescendants(String repositoryId, String typeId, BigInteger depth, Boolean includePropertyDefinitions, ExtensionsData extension) {
        int d = depth == null ? 2 : depth.intValue();
        List<TypeDefinitionContainer> types = this.repository.getTypeDescendants(typeId, d, includePropertyDefinitions);
        ArrayList tmp = new ArrayList(types.size());
        Converter.convertTypeContainerList(types, tmp);
        return Converter.convertTypeContainerList(tmp);
    }

    protected DocumentModel getDocumentModel(String id) {
        IdRef docRef = new IdRef(id);
        try {
            if (!this.coreSession.exists((DocumentRef)docRef)) {
                throw new CmisObjectNotFoundException(docRef.toString());
            }
            DocumentModel doc = this.coreSession.getDocument((DocumentRef)docRef);
            if (this.isFilteredOut(doc)) {
                throw new CmisObjectNotFoundException(docRef.toString());
            }
            return doc;
        }
        catch (ClientException e) {
            throw new CmisRuntimeException(e.toString(), (Throwable)e);
        }
    }

    public NuxeoObjectData getObject(String repositoryId, String objectId, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        DocumentModel doc = this.getDocumentModel(objectId);
        NuxeoObjectData data = new NuxeoObjectData(this, doc, filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl, extension);
        this.collectObjectInfo(repositoryId, data);
        return data;
    }

    public boolean isFilteredOut(DocumentModel doc) {
        return !this.documentFilter.accept(doc);
    }

    protected DocumentModel createDocumentModel(ObjectId folder, TypeDefinition type) {
        DocumentModel doc;
        String typeId = type.getId();
        String nuxeoTypeId = type.getLocalName();
        if (BaseTypeId.CMIS_DOCUMENT.value().equals(typeId)) {
            nuxeoTypeId = "File";
        } else if (BaseTypeId.CMIS_FOLDER.value().equals(typeId)) {
            nuxeoTypeId = "Folder";
        } else if (BaseTypeId.CMIS_RELATIONSHIP.value().equals(typeId)) {
            nuxeoTypeId = "DefaultRelation";
        }
        try {
            doc = this.coreSession.createDocumentModel(nuxeoTypeId);
        }
        catch (ClientException e) {
            throw new IllegalArgumentException(typeId);
        }
        if (folder != null) {
            DocumentModel parentDoc;
            try {
                parentDoc = this.coreSession.getDocument((DocumentRef)new IdRef(folder.getId()));
            }
            catch (ClientException e) {
                throw new CmisRuntimeException("Cannot create object", (Throwable)e);
            }
            String pathSegment = nuxeoTypeId;
            doc.setPathInfo(parentDoc.getPathAsString(), pathSegment);
        }
        return doc;
    }

    protected DocumentModel createDocumentModel(ObjectId folder, ContentStream contentStream, String name) {
        Blob blob;
        DocumentModel parent;
        FileManager fileManager = (FileManager)Framework.getLocalService(FileManager.class);
        MimetypeRegistryService mtr = (MimetypeRegistryService)Framework.getLocalService(MimetypeRegistry.class);
        if (fileManager == null || mtr == null || name == null || folder == null) {
            return null;
        }
        try {
            parent = this.coreSession.getDocument((DocumentRef)new IdRef(folder.getId()));
        }
        catch (ClientException e) {
            throw new CmisRuntimeException("Cannot create object", (Throwable)e);
        }
        String path = parent.getPathAsString();
        if (contentStream == null) {
            String mimeType;
            try {
                mimeType = mtr.getMimetypeFromFilename(name);
            }
            catch (MimetypeNotFoundException e) {
                mimeType = "application/octet-stream";
            }
            blob = new ByteArrayBlob(new byte[0], mimeType, null, name, null);
        } else {
            try {
                blob = NuxeoPropertyData.getPersistentBlob(contentStream, null);
            }
            catch (IOException e) {
                throw new CmisRuntimeException(e.toString(), (Throwable)e);
            }
        }
        try {
            return fileManager.createDocumentFromBlob(this.coreSession, blob, path, false, name);
        }
        catch (Exception e) {
            throw new CmisRuntimeException(e.toString(), (Throwable)e);
        }
    }

    protected NuxeoObjectData createObject(Properties properties, ObjectId folder, BaseTypeId baseType, ContentStream contentStream) {
        boolean created;
        String name;
        String typeId;
        PropertyData d;
        Map p;
        TypeDefinition type = null;
        if (properties != null && (p = properties.getProperties()) != null && (d = (PropertyData)p.get("cmis:objectTypeId")) != null) {
            typeId = (String)d.getFirstValue();
            if (baseType == null) {
                type = this.repository.getTypeDefinition(typeId);
                if (type == null) {
                    throw new IllegalArgumentException(typeId);
                }
                baseType = type.getBaseTypeId();
            }
        } else {
            typeId = null;
        }
        if (typeId == null) {
            switch (baseType) {
                case CMIS_DOCUMENT: {
                    typeId = BaseTypeId.CMIS_DOCUMENT.value();
                    break;
                }
                case CMIS_FOLDER: {
                    typeId = BaseTypeId.CMIS_FOLDER.value();
                    break;
                }
                case CMIS_POLICY: {
                    throw new CmisRuntimeException("Cannot create policy");
                }
                case CMIS_RELATIONSHIP: {
                    throw new CmisRuntimeException("Cannot create relationship");
                }
                default: {
                    throw new CmisRuntimeException("No base type");
                }
            }
        }
        if (type == null) {
            type = this.repository.getTypeDefinition(typeId);
        }
        if (type == null || type.getBaseTypeId() != baseType) {
            throw new CmisInvalidArgumentException(typeId);
        }
        if (type.isCreatable() == Boolean.FALSE) {
            throw new CmisInvalidArgumentException("Not creatable: " + typeId);
        }
        PropertyData npd = (PropertyData)properties.getProperties().get("cmis:name");
        String string = name = npd == null ? null : (String)npd.getFirstValue();
        if (StringUtils.isBlank((String)name)) {
            name = null;
        }
        if (contentStream != null && StringUtils.isBlank((String)contentStream.getFileName()) && name != null) {
            contentStream = new ContentStreamImpl(name, contentStream.getBigLength(), contentStream.getMimeType().trim(), contentStream.getStream());
        }
        DocumentModel doc = null;
        if (BaseTypeId.CMIS_DOCUMENT.value().equals(typeId)) {
            doc = this.createDocumentModel(folder, contentStream, name);
        }
        boolean bl = created = doc != null;
        if (!created) {
            doc = this.createDocumentModel(folder, type);
        }
        NuxeoObjectData data = new NuxeoObjectData(this, doc);
        this.updateProperties(data, null, properties, true);
        if (!created && contentStream != null) {
            try {
                NuxeoPropertyData.setContentStream(doc, contentStream, true);
            }
            catch (CmisContentAlreadyExistsException e) {
            }
            catch (IOException e) {
                throw new CmisRuntimeException(e.toString(), (Throwable)e);
            }
        }
        try {
            if (!created) {
                PathSegmentService pss = (PathSegmentService)Framework.getLocalService(PathSegmentService.class);
                String pathSegment = pss.generatePathSegment(doc);
                Path path = doc.getPath();
                doc.setPathInfo(path == null ? null : path.removeLastSegments(1).toString(), pathSegment);
                doc = this.coreSession.createDocument(doc);
            } else {
                doc = this.coreSession.saveDocument(doc);
            }
            data.doc = doc;
            this.coreSession.save();
        }
        catch (ClientException e) {
            throw new CmisRuntimeException("Cannot create", (Throwable)e);
        }
        return data;
    }

    protected <T> void updateProperties(NuxeoObjectData object, String changeToken, Properties properties, boolean creation) {
        Map p;
        TypeDefinition type = object.getTypeDefinition();
        if (properties == null || (p = properties.getProperties()) == null) {
            return;
        }
        for (Map.Entry en : p.entrySet()) {
            String key = (String)en.getKey();
            PropertyData d = (PropertyData)en.getValue();
            this.setObjectProperty(object, key, d, type, creation);
        }
    }

    protected <T> void updateProperties(NuxeoObjectData object, String changeToken, Map<String, ?> properties, TypeDefinition type, boolean creation) {
        if (properties == null) {
            return;
        }
        for (Map.Entry<String, ?> en : properties.entrySet()) {
            String key = en.getKey();
            Object value = en.getValue();
            PropertyDefinition pd = (PropertyDefinition)type.getPropertyDefinitions().get(key);
            if (pd == null) {
                throw new CmisRuntimeException("Unknown property: " + key);
            }
            this.setObjectProperty(object, key, value, pd, creation);
        }
    }

    protected <T> void setObjectProperty(NuxeoObjectData object, String key, PropertyData<T> d, TypeDefinition type, boolean creation) {
        PropertyDefinition pd = (PropertyDefinition)type.getPropertyDefinitions().get(key);
        if (pd == null) {
            throw new CmisRuntimeException("Unknown property: " + key);
        }
        Object value = d == null ? null : (pd.getCardinality() == Cardinality.SINGLE ? d.getFirstValue() : d.getValues());
        this.setObjectProperty(object, key, value, pd, creation);
    }

    protected <T> void setObjectProperty(NuxeoObjectData object, String key, Object value, PropertyDefinition<T> pd, boolean creation) {
        Updatability updatability = pd.getUpdatability();
        if (updatability == Updatability.READONLY || updatability == Updatability.ONCREATE && !creation) {
            return;
        }
        if ("cmis:objectTypeId".equals(key) || "cmis:lastModificationDate".equals(key)) {
            return;
        }
        NuxeoPropertyDataBase np = (NuxeoPropertyDataBase)NuxeoPropertyData.construct(object, pd, this.callContext);
        np.setValue(value);
    }

    protected String setInitialVersioningState(NuxeoObjectData object, VersioningState versioningState) {
        try {
            String id;
            if (versioningState == null) {
                versioningState = VersioningState.MAJOR;
            }
            DocumentRef ref = null;
            switch (versioningState) {
                case NONE: 
                case CHECKEDOUT: {
                    id = object.getId();
                    break;
                }
                case MINOR: {
                    ref = object.doc.checkIn(VersioningOption.MINOR, null);
                    object.doc.getCoreSession().save();
                    id = object.getId();
                    break;
                }
                case MAJOR: {
                    ref = object.doc.checkIn(VersioningOption.MAJOR, null);
                    object.doc.getCoreSession().save();
                    id = object.getId();
                    break;
                }
                default: {
                    throw new AssertionError(versioningState);
                }
            }
            return id;
        }
        catch (ClientException e) {
            throw new CmisRuntimeException(e.toString(), (Throwable)e);
        }
    }

    public String create(String repositoryId, Properties properties, String folderId, ContentStream contentStream, VersioningState versioningState, List<String> policies, ExtensionsData extension) {
        NuxeoObjectData object = this.createObject(properties, (ObjectId)new ObjectIdImpl(folderId), null, contentStream);
        return this.setInitialVersioningState(object, versioningState);
    }

    public String createDocument(String repositoryId, Properties properties, String folderId, ContentStream contentStream, VersioningState versioningState, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        NuxeoObjectData object = this.createObject(properties, (ObjectId)new ObjectIdImpl(folderId), BaseTypeId.CMIS_DOCUMENT, contentStream);
        return this.setInitialVersioningState(object, versioningState);
    }

    public String createFolder(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        NuxeoObjectData object = this.createObject(properties, (ObjectId)new ObjectIdImpl(folderId), BaseTypeId.CMIS_FOLDER, null);
        return object.getId();
    }

    public String createPolicy(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        throw new CmisNotSupportedException();
    }

    public String createRelationship(String repositoryId, Properties properties, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        NuxeoObjectData object = this.createObject(properties, null, BaseTypeId.CMIS_RELATIONSHIP, null);
        return object.getId();
    }

    public String createDocumentFromSource(String repositoryId, String sourceId, Properties properties, String folderId, VersioningState versioningState, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        if (folderId == null) {
            throw new CmisInvalidArgumentException("Invalid null folder ID");
        }
        DocumentModel doc = this.getDocumentModel(sourceId);
        DocumentModel folder = this.getDocumentModel(folderId);
        try {
            DocumentModel copyDoc = this.coreSession.copy(doc.getRef(), folder.getRef(), null);
            NuxeoObjectData copy = new NuxeoObjectData(this, copyDoc);
            if (properties != null && properties.getPropertyList() != null && !properties.getPropertyList().isEmpty()) {
                this.updateProperties(copy, null, properties, false);
                copy.doc = this.coreSession.saveDocument(copyDoc);
            }
            this.coreSession.save();
            return this.setInitialVersioningState(copy, versioningState);
        }
        catch (ClientException e) {
            throw new CmisRuntimeException(e.toString(), (Throwable)e);
        }
    }

    public NuxeoObjectData copy(String sourceId, String targetId, Map<String, ?> properties, TypeDefinition type, VersioningState versioningState, List<Policy> policies, List<Ace> addACEs, List<Ace> removeACEs, OperationContext context) {
        DocumentModel doc = this.getDocumentModel(sourceId);
        DocumentModel folder = this.getDocumentModel(targetId);
        try {
            DocumentModel copyDoc = this.coreSession.copy(doc.getRef(), folder.getRef(), null);
            NuxeoObjectData copy = new NuxeoObjectData(this, copyDoc, context);
            if (properties != null && !properties.isEmpty()) {
                this.updateProperties(copy, null, properties, type, false);
                copy.doc = this.coreSession.saveDocument(copyDoc);
            }
            this.coreSession.save();
            String id = this.setInitialVersioningState(copy, versioningState);
            NuxeoObjectData res = id.equals(copy.getId()) ? copy : new NuxeoObjectData(this, this.getDocumentModel(id));
            return res;
        }
        catch (ClientException e) {
            throw new CmisRuntimeException(e.toString(), (Throwable)e);
        }
    }

    public void deleteContentStream(String repositoryId, Holder<String> objectIdHolder, Holder<String> changeTokenHolder, ExtensionsData extension) {
        this.setContentStream(repositoryId, objectIdHolder, Boolean.TRUE, changeTokenHolder, null, extension);
    }

    public FailedToDeleteData deleteTree(String repositoryId, String folderId, Boolean allVersions, UnfileObject unfileObjects, Boolean continueOnFailure, ExtensionsData extension) {
        if (unfileObjects == UnfileObject.UNFILE) {
            throw new CmisConstraintException("Unfiling not supported");
        }
        if (this.repository.getRootFolderId().equals(folderId)) {
            throw new CmisInvalidArgumentException("Cannot delete root");
        }
        try {
            DocumentModel doc = this.getDocumentModel(folderId);
            if (!doc.isFolder()) {
                throw new CmisInvalidArgumentException("Not a folder: " + folderId);
            }
            this.coreSession.removeDocument((DocumentRef)new IdRef(folderId));
            this.coreSession.save();
            return new FailedToDeleteDataImpl();
        }
        catch (ClientException e) {
            throw new CmisRuntimeException(e.toString(), (Throwable)e);
        }
    }

    public AllowableActions getAllowableActions(String repositoryId, String objectId, ExtensionsData extension) {
        DocumentModel doc = this.getDocumentModel(objectId);
        return NuxeoObjectData.getAllowableActions(doc, false);
    }

    public ContentStream getContentStream(String repositoryId, String objectId, String streamId, BigInteger offset, BigInteger length, ExtensionsData extension) {
        if ("nx:icon".equals(streamId)) {
            try {
                SimpleImageInfo info;
                String iconPath;
                DocumentModel doc = this.getDocumentModel(objectId);
                try {
                    iconPath = (String)((Object)doc.getPropertyValue("common:icon"));
                }
                catch (PropertyException e) {
                    iconPath = null;
                }
                InputStream is = NuxeoObjectData.getIconStream(iconPath, this.callContext);
                if (is == null) {
                    throw new CmisConstraintException("No icon content stream: " + objectId);
                }
                int slash = iconPath.lastIndexOf(47);
                String filename = slash == -1 ? iconPath : iconPath.substring(slash + 1);
                try {
                    info = new SimpleImageInfo(is);
                }
                catch (IOException e) {
                    throw new CmisRuntimeException(e.toString(), (Throwable)e);
                }
                is = NuxeoObjectData.getIconStream(iconPath, this.callContext);
                return new ContentStreamImpl(filename, BigInteger.valueOf(info.getLength()), info.getMimeType(), is);
            }
            catch (ClientException e) {
                throw new CmisRuntimeException(e.toString(), (Throwable)e);
            }
        }
        if (streamId == null) {
            DocumentModel doc = this.getDocumentModel(objectId);
            ContentStream cs = NuxeoPropertyData.getContentStream(doc);
            if (cs != null) {
                return cs;
            }
            throw new CmisConstraintException("No content stream: " + objectId);
        }
        throw new CmisInvalidArgumentException("Invalid stream id: " + streamId);
    }

    public List<RenditionData> getRenditions(String repositoryId, String objectId, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        DocumentModel doc = this.getDocumentModel(objectId);
        return NuxeoObjectData.getRenditions(doc, maxItems, skipCount, this.callContext);
    }

    public ObjectData getObjectByPath(String repositoryId, String path, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        DocumentModel doc;
        try {
            PathRef pathRef = new PathRef(path);
            if (this.coreSession.exists((DocumentRef)pathRef)) {
                doc = this.coreSession.getDocument((DocumentRef)pathRef);
                if (this.isFilteredOut(doc)) {
                    throw new CmisObjectNotFoundException(path);
                }
            } else {
                doc = this.getObjectByPathOfNames(path);
            }
        }
        catch (ClientException e) {
            throw new CmisRuntimeException(e.toString(), (Throwable)e);
        }
        NuxeoObjectData data = new NuxeoObjectData(this, doc, filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl, extension);
        this.collectObjectInfo(repositoryId, data);
        return data;
    }

    protected DocumentModel getObjectByPathOfNames(String path) throws ClientException, CmisObjectNotFoundException {
        DocumentModel doc = this.coreSession.getRootDocument();
        for (String name : new Path(path).segments()) {
            String query = String.format("SELECT * FROM Document WHERE ecm:parentId = %s AND dc:title = %s", NuxeoCmisService.escapeStringForNXQL(doc.getId()), NuxeoCmisService.escapeStringForNXQL(name));
            DocumentModelList docs = this.coreSession.query(query);
            if (docs.isEmpty()) {
                throw new CmisObjectNotFoundException(path);
            }
            doc = null;
            for (DocumentModel d : docs) {
                if (this.isFilteredOut(d)) continue;
                if (doc == null) {
                    doc = d;
                    continue;
                }
                log.warn((Object)String.format("Path '%s' returns several documents for '%s'", path, name));
                break;
            }
            if (doc != null) continue;
            throw new CmisObjectNotFoundException(path);
        }
        return doc;
    }

    protected static String escapeStringForNXQL(String s) {
        return "'" + s.replaceAll("'", REPLACE_QUOTE) + "'";
    }

    public Properties getProperties(String repositoryId, String objectId, String filter, ExtensionsData extension) {
        DocumentModel doc = this.getDocumentModel(objectId);
        NuxeoObjectData data = new NuxeoObjectData(this, doc, filter, null, null, null, null, null, null);
        return data.getProperties();
    }

    public ObjectInfo getObjectInfo(String repositoryId, String objectId) {
        ObjectInfo info = this.getObjectInfo().get(objectId);
        if (info != null) {
            return info;
        }
        DocumentModel doc = this.getDocumentModel(objectId);
        NuxeoObjectData data = new NuxeoObjectData(this, doc, null, Boolean.TRUE, IncludeRelationships.BOTH, null, Boolean.TRUE, Boolean.FALSE, null);
        return this.getObjectInfo(repositoryId, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ObjectInfo getObjectInfo(String repositoryId, ObjectData data) {
        ObjectInfo info = this.getObjectInfo().get(data.getId());
        if (info != null) {
            return info;
        }
        try {
            this.collectObjectInfos = false;
            info = this.getObjectInfoIntern(repositoryId, data);
            this.getObjectInfo().put(info.getId(), info);
        }
        catch (Exception e) {
            log.error((Object)e.toString(), (Throwable)e);
        }
        finally {
            this.collectObjectInfos = true;
        }
        return info;
    }

    protected Map<String, ObjectInfo> getObjectInfo() {
        if (this.objectInfos == null) {
            this.objectInfos = new HashMap<String, ObjectInfo>();
        }
        return this.objectInfos;
    }

    public void clearObjectInfos() {
        this.objectInfos = null;
    }

    protected void collectObjectInfo(String repositoryId, String objectId) {
        if (this.collectObjectInfos && this.callContext.isObjectInfoRequired()) {
            this.getObjectInfo(repositoryId, objectId);
        }
    }

    protected void collectObjectInfo(String repositoryId, ObjectData data) {
        if (this.collectObjectInfos && this.callContext.isObjectInfoRequired()) {
            this.getObjectInfo(repositoryId, data);
        }
    }

    public void addObjectInfo(ObjectInfo info) {
        throw new UnsupportedOperationException();
    }

    public void moveObject(String repositoryId, Holder<String> objectIdHolder, String targetFolderId, String sourceFolderId, ExtensionsData extension) {
        String objectId;
        if (objectIdHolder == null || (objectId = (String)objectIdHolder.getValue()) == null) {
            throw new CmisInvalidArgumentException("Missing object ID");
        }
        if (this.repository.getRootFolderId().equals(objectId)) {
            throw new CmisConstraintException("Cannot move root");
        }
        if (targetFolderId == null) {
            throw new CmisInvalidArgumentException("Missing target folder ID");
        }
        try {
            this.getDocumentModel(objectId);
            IdRef docRef = new IdRef(objectId);
            DocumentModel parent = this.coreSession.getParentDocument((DocumentRef)docRef);
            if (this.isFilteredOut(parent)) {
                throw new CmisObjectNotFoundException("No parent: " + objectId);
            }
            if (sourceFolderId == null) {
                sourceFolderId = parent.getId();
            } else if (!parent.getId().equals(sourceFolderId)) {
                throw new CmisInvalidArgumentException("Object " + objectId + " is not filed in " + sourceFolderId);
            }
            DocumentModel target = this.getDocumentModel(targetFolderId);
            if (!target.isFolder()) {
                throw new CmisInvalidArgumentException("Target is not a folder: " + targetFolderId);
            }
            this.coreSession.move((DocumentRef)docRef, (DocumentRef)new IdRef(targetFolderId), null);
            this.coreSession.save();
        }
        catch (ClientException e) {
            throw new CmisRuntimeException(e.toString(), (Throwable)e);
        }
    }

    public void setContentStream(String repositoryId, Holder<String> objectIdHolder, Boolean overwriteFlag, Holder<String> changeTokenHolder, ContentStream contentStream, ExtensionsData extension) {
        String objectId;
        if (objectIdHolder == null || (objectId = (String)objectIdHolder.getValue()) == null) {
            throw new CmisInvalidArgumentException("Missing object ID");
        }
        DocumentModel doc = this.getDocumentModel(objectId);
        try {
            NuxeoPropertyData.setContentStream(doc, contentStream, !Boolean.FALSE.equals(overwriteFlag));
            this.coreSession.saveDocument(doc);
            this.coreSession.save();
        }
        catch (CmisBaseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CmisRuntimeException(e.toString(), (Throwable)e);
        }
    }

    public void updateProperties(String repositoryId, Holder<String> objectIdHolder, Holder<String> changeTokenHolder, Properties properties, ExtensionsData extension) {
        String objectId;
        if (objectIdHolder == null || (objectId = (String)objectIdHolder.getValue()) == null) {
            throw new CmisInvalidArgumentException("Missing object ID");
        }
        DocumentModel doc = this.getDocumentModel(objectId);
        NuxeoObjectData object = new NuxeoObjectData(this, doc);
        String changeToken = changeTokenHolder == null ? null : (String)changeTokenHolder.getValue();
        this.updateProperties(object, changeToken, properties, false);
        try {
            this.coreSession.saveDocument(doc);
            this.coreSession.save();
        }
        catch (ClientException e) {
            throw new CmisRuntimeException(e.toString(), (Throwable)e);
        }
    }

    public Acl applyAcl(String repositoryId, String objectId, Acl addAces, Acl removeAces, AclPropagation aclPropagation, ExtensionsData extension) {
        throw new CmisNotSupportedException();
    }

    public Acl applyAcl(String repositoryId, String objectId, Acl aces, AclPropagation aclPropagation) {
        throw new CmisNotSupportedException();
    }

    public Acl getAcl(String repositoryId, String objectId, Boolean onlyBasicPermissions, ExtensionsData extension) {
        throw new CmisNotSupportedException();
    }

    public ObjectList getContentChanges(String repositoryId, Holder<String> changeLogTokenHolder, Boolean includeProperties, String filter, Boolean includePolicyIds, Boolean includeAcl, BigInteger maxItems, ExtensionsData extension) {
        long minDate;
        if (changeLogTokenHolder == null) {
            throw new CmisInvalidArgumentException("Missing change log token holder");
        }
        String changeLogToken = (String)changeLogTokenHolder.getValue();
        if (changeLogToken == null) {
            minDate = 0L;
        } else {
            try {
                minDate = Long.parseLong(changeLogToken);
            }
            catch (NumberFormatException e) {
                throw new CmisInvalidArgumentException("Invalid change log token");
            }
        }
        try {
            int max;
            AuditReader reader = (AuditReader)Framework.getService(AuditReader.class);
            if (reader == null) {
                throw new CmisRuntimeException("Cannot find audit service");
            }
            int n = max = maxItems == null ? -1 : maxItems.intValue();
            if (max < 0) {
                max = 100;
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            String query = "FROM LogEntry log WHERE log.eventDate >= :minDate   AND log.eventId IN (:evCreated, :evModified, :evRemoved)   AND log.repositoryId = :repoId ORDER BY log.eventDate";
            params.put("minDate", new Date(minDate));
            params.put("evCreated", "documentCreated");
            params.put("evModified", "documentModified");
            params.put("evRemoved", "documentRemoved");
            params.put("repoId", repositoryId);
            List entries = reader.nativeQuery(query, params, 1, max + 1);
            ObjectListImpl ol = new ObjectListImpl();
            boolean hasMoreItems = entries.size() > max;
            ol.setHasMoreItems(Boolean.valueOf(hasMoreItems));
            if (hasMoreItems) {
                entries = entries.subList(0, max);
            }
            ArrayList<ObjectDataImpl> ods = new ArrayList<ObjectDataImpl>(entries.size());
            Date date = null;
            for (Object entry : entries) {
                ChangeType changeType;
                LogEntry logEntry = (LogEntry)entry;
                ObjectDataImpl od = new ObjectDataImpl();
                ChangeEventInfoDataImpl cei = new ChangeEventInfoDataImpl();
                String eventId = logEntry.getEventId();
                if ("documentCreated".equals(eventId)) {
                    changeType = ChangeType.CREATED;
                } else if ("documentModified".equals(eventId)) {
                    changeType = ChangeType.UPDATED;
                } else {
                    if (!"documentRemoved".equals(eventId)) continue;
                    changeType = ChangeType.DELETED;
                }
                cei.setChangeType(changeType);
                GregorianCalendar changeTime = (GregorianCalendar)Calendar.getInstance();
                date = logEntry.getEventDate();
                changeTime.setTime(date);
                cei.setChangeTime(changeTime);
                od.setChangeEventInfo((ChangeEventInfo)cei);
                PropertiesImpl properties = new PropertiesImpl();
                properties.addProperty((PropertyData)new PropertyIdImpl("cmis:objectId", logEntry.getDocUUID()));
                properties.addProperty((PropertyData)new PropertyIdImpl("cmis:objectTypeId", logEntry.getDocType()));
                od.setProperties((Properties)properties);
                ods.add(od);
            }
            ol.setObjects(ods);
            ol.setNumItems(BigInteger.valueOf(-1L));
            String latestChangeLogToken = date == null ? null : String.valueOf(date.getTime());
            changeLogTokenHolder.setValue((Object)latestChangeLogToken);
            return ol;
        }
        catch (Exception e) {
            throw new CmisRuntimeException(e.toString(), (Throwable)e);
        }
    }

    protected String getLatestChangeLogToken(String repositoryId) {
        try {
            AuditReader reader = (AuditReader)Framework.getService(AuditReader.class);
            if (reader == null) {
                log.warn((Object)"Audit Service not found. latest change log token will be '0'");
                return "0";
            }
            HashMap<String, String> params = new HashMap<String, String>();
            String query = "FROM LogEntry log WHERE log.eventId IN (:evCreated, :evModified, :evRemoved) ORDER BY log.eventDate DESC";
            params.put("evCreated", "documentCreated");
            params.put("evModified", "documentModified");
            params.put("evRemoved", "documentRemoved");
            List entries = reader.nativeQuery(query, params, 1, 1);
            if (entries.size() == 0) {
                return "0";
            }
            LogEntry logEntry = (LogEntry)entries.get(0);
            return String.valueOf(logEntry.getEventDate().getTime());
        }
        catch (Exception e) {
            throw new CmisRuntimeException(e.toString(), (Throwable)e);
        }
    }

    public ObjectList query(String repositoryId, String statement, Boolean searchAllVersions, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        long numItems;
        ArrayList<ObjectDataImpl> list;
        long max;
        long skip;
        long l = skip = skipCount == null ? 0L : skipCount.longValue();
        if (skip < 0L) {
            skip = 0L;
        }
        long l2 = max = maxItems == null ? -1L : maxItems.longValue();
        if (max <= 0L) {
            max = 100L;
        }
        IterableQueryResult res = null;
        try {
            HashMap typeInfo = new HashMap();
            if (searchAllVersions == null) {
                searchAllVersions = Boolean.FALSE;
            }
            res = this.coreSession.queryAndFetch(statement, "CMISQL", new Object[]{this, typeInfo, searchAllVersions});
            list = new ArrayList<ObjectDataImpl>();
            if (skip > 0L) {
                res.skipTo(skip);
            }
            for (Map map : res) {
                String id;
                ObjectDataImpl od = this.makeObjectData(map, typeInfo);
                if (Boolean.TRUE.equals(includeAllowableActions)) {
                    // empty if block
                }
                if (includeRelationships != null && includeRelationships != IncludeRelationships.NONE && (id = od.getId()) != null) {
                    List<ObjectData> relationships = NuxeoObjectData.getRelationships(id, includeRelationships, this.coreSession, this);
                    od.setRelationships(relationships);
                }
                if (renditionFilter == null || renditionFilter.length() > 0) {
                    // empty if block
                }
                list.add(od);
                if ((long)list.size() < max) continue;
                break;
            }
            numItems = res.size();
        }
        catch (ClientException e) {
            throw new CmisRuntimeException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (res != null) {
                res.close();
            }
        }
        ObjectListImpl objList = new ObjectListImpl();
        objList.setObjects(list);
        objList.setNumItems(BigInteger.valueOf(numItems));
        objList.setHasMoreItems(Boolean.valueOf(numItems > skip + (long)list.size()));
        return objList;
    }

    protected ObjectDataImpl makeObjectData(Map<String, Serializable> map, Map<String, PropertyDefinition<?>> typeInfo) {
        ObjectDataImpl od = new ObjectDataImpl();
        PropertiesImpl properties = new PropertiesImpl();
        for (Map.Entry<String, Serializable> en : map.entrySet()) {
            String queryName = en.getKey();
            PropertyDefinition<?> pd = typeInfo.get(queryName);
            if (pd == null) {
                throw new NullPointerException("Cannot get " + queryName);
            }
            AbstractPropertyData p = (AbstractPropertyData)this.objectFactory.createPropertyData(pd, (Object)en.getValue());
            p.setLocalName(pd.getLocalName());
            p.setDisplayName(pd.getDisplayName());
            p.setQueryName(queryName);
            properties.addProperty((PropertyData)p);
        }
        od.setProperties((Properties)properties);
        return od;
    }

    public void addObjectToFolder(String repositoryId, String objectId, String folderId, Boolean allVersions, ExtensionsData extension) {
        throw new CmisNotSupportedException();
    }

    public void removeObjectFromFolder(String repositoryId, String objectId, String folderId, ExtensionsData extension) {
        if (folderId != null) {
            try {
                DocumentModel folder = this.getDocumentModel(folderId);
                DocumentModel parent = this.coreSession.getParentDocument((DocumentRef)new IdRef(objectId));
                if (!parent.getId().equals(folder.getId())) {
                    throw new CmisInvalidArgumentException("Object " + objectId + " is not filed in  " + folderId);
                }
            }
            catch (ClientException e) {
                throw new CmisRuntimeException(e.toString(), (Throwable)e);
            }
        }
        this.deleteObject(repositoryId, objectId, Boolean.FALSE, extension);
    }

    public ObjectInFolderList getChildren(String repositoryId, String folderId, String filter, String orderBy, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        if (folderId == null) {
            throw new CmisInvalidArgumentException("Null folderId");
        }
        return this.getChildrenInternal(repositoryId, folderId, filter, orderBy, includeAllowableActions, includeRelationships, renditionFilter, includePathSegment, maxItems, skipCount, false);
    }

    protected ObjectInFolderList getChildrenInternal(String repositoryId, String folderId, String filter, String orderBy, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, BigInteger maxItems, BigInteger skipCount, boolean folderOnly) {
        DocumentModelList children;
        ObjectInFolderListImpl result = new ObjectInFolderListImpl();
        ArrayList<ObjectInFolderDataImpl> list = new ArrayList<ObjectInFolderDataImpl>();
        DocumentModel folder = this.getDocumentModel(folderId);
        if (!folder.isFolder()) {
            return null;
        }
        try {
            children = this.coreSession.getChildren(folder.getRef());
        }
        catch (ClientException e) {
            throw new CmisRuntimeException(e.toString(), (Throwable)e);
        }
        for (DocumentModel child : children) {
            if (this.isFilteredOut(child) || folderOnly && !child.isFolder()) continue;
            NuxeoObjectData data = new NuxeoObjectData(this, child, filter, includeAllowableActions, includeRelationships, renditionFilter, Boolean.FALSE, Boolean.FALSE, null);
            ObjectInFolderDataImpl oifd = new ObjectInFolderDataImpl();
            oifd.setObject((ObjectData)data);
            if (Boolean.TRUE.equals(includePathSegment)) {
                oifd.setPathSegment(child.getName());
            }
            list.add(oifd);
            this.collectObjectInfo(repositoryId, data);
        }
        if (StringUtils.isNotBlank((String)orderBy)) {
            Collections.sort(list, new OrderByComparator(orderBy, this.repository));
        }
        ListUtils.BatchedList batch = ListUtils.getBatchedList(list, maxItems, skipCount, 100);
        result.setObjects(batch.getList());
        result.setHasMoreItems(batch.getHasMoreItems());
        result.setNumItems(batch.getNumItems());
        this.collectObjectInfo(repositoryId, folderId);
        return result;
    }

    public List<ObjectInFolderContainer> getDescendants(String repositoryId, String folderId, BigInteger depth, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, ExtensionsData extension) {
        int levels;
        if (folderId == null) {
            throw new CmisInvalidArgumentException("Null folderId");
        }
        int n = levels = depth == null ? 2 : depth.intValue();
        if (levels == 0) {
            throw new CmisInvalidArgumentException("Invalid depth: 0");
        }
        return this.getDescendantsInternal(repositoryId, folderId, filter, includeAllowableActions, includeRelationships, renditionFilter, includePathSegment, 0, levels, false);
    }

    public List<ObjectInFolderContainer> getFolderTree(String repositoryId, String folderId, BigInteger depth, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, ExtensionsData extension) {
        int levels;
        if (folderId == null) {
            throw new CmisInvalidArgumentException("Null folderId");
        }
        int n = levels = depth == null ? 2 : depth.intValue();
        if (levels == 0) {
            throw new CmisInvalidArgumentException("Invalid depth: 0");
        }
        return this.getDescendantsInternal(repositoryId, folderId, filter, includeAllowableActions, includeRelationships, renditionFilter, includePathSegment, 0, levels, true);
    }

    protected List<ObjectInFolderContainer> getDescendantsInternal(String repositoryId, String folderId, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegments, int level, int maxLevels, boolean folderOnly) {
        if (maxLevels != -1 && level >= maxLevels) {
            return null;
        }
        ObjectInFolderList children = this.getChildrenInternal(repositoryId, folderId, filter, null, includeAllowableActions, includeRelationships, renditionFilter, includePathSegments, null, null, folderOnly);
        if (children == null) {
            return Collections.emptyList();
        }
        ArrayList<ObjectInFolderContainer> res = new ArrayList<ObjectInFolderContainer>(children.getObjects().size());
        for (ObjectInFolderData child : children.getObjects()) {
            ObjectInFolderContainerImpl oifc = new ObjectInFolderContainerImpl();
            oifc.setObject(child);
            List<ObjectInFolderContainer> subChildren = this.getDescendantsInternal(repositoryId, child.getObject().getId(), filter, includeAllowableActions, includeRelationships, renditionFilter, includePathSegments, level + 1, maxLevels, folderOnly);
            if (subChildren != null) {
                oifc.setChildren(subChildren);
            }
            res.add((ObjectInFolderContainer)oifc);
        }
        return res;
    }

    public ObjectData getFolderParent(String repositoryId, String folderId, String filter, ExtensionsData extension) {
        List<ObjectParentData> parents = this.getObjectParentsInternal(repositoryId, folderId, filter, null, null, null, Boolean.TRUE, true);
        return parents.isEmpty() ? null : parents.get(0).getObject();
    }

    public List<ObjectParentData> getObjectParents(String repositoryId, String objectId, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includeRelativePathSegment, ExtensionsData extension) {
        return this.getObjectParentsInternal(repositoryId, objectId, filter, includeAllowableActions, includeRelationships, renditionFilter, includeRelativePathSegment, false);
    }

    protected List<ObjectParentData> getObjectParentsInternal(String repositoryId, String objectId, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includeRelativePathSegment, boolean folderOnly) {
        String parentId;
        String pathSegment;
        try {
            IdRef docRef = new IdRef(objectId);
            if (!this.coreSession.exists((DocumentRef)docRef)) {
                throw new CmisObjectNotFoundException(objectId);
            }
            DocumentModel doc = this.coreSession.getDocument((DocumentRef)docRef);
            if (this.isFilteredOut(doc)) {
                throw new CmisObjectNotFoundException(objectId);
            }
            if (folderOnly && !doc.isFolder()) {
                throw new CmisInvalidArgumentException("Not a folder: " + objectId);
            }
            pathSegment = doc.getName();
            if (pathSegment == null) {
                return Collections.emptyList();
            }
            DocumentRef parentRef = doc.getParentRef();
            if (parentRef == null) {
                return Collections.emptyList();
            }
            if (!this.coreSession.exists(parentRef)) {
                return Collections.emptyList();
            }
            DocumentModel parent = this.coreSession.getDocument(parentRef);
            if (this.isFilteredOut(parent)) {
                return Collections.emptyList();
            }
            parentId = parent.getId();
        }
        catch (ClientException e) {
            throw new CmisRuntimeException(e.toString(), (Throwable)e);
        }
        NuxeoObjectData od = this.getObject(repositoryId, parentId, filter, includeAllowableActions, includeRelationships, renditionFilter, Boolean.FALSE, Boolean.FALSE, null);
        ObjectParentDataImpl opd = new ObjectParentDataImpl((ObjectData)od);
        if (!Boolean.FALSE.equals(includeRelativePathSegment)) {
            opd.setRelativePathSegment(pathSegment);
        }
        return Collections.singletonList(opd);
    }

    public void applyPolicy(String repositoryId, String policyId, String objectId, ExtensionsData extension) {
        throw new CmisNotSupportedException();
    }

    public List<ObjectData> getAppliedPolicies(String repositoryId, String objectId, String filter, ExtensionsData extension) {
        return Collections.emptyList();
    }

    public void removePolicy(String repositoryId, String policyId, String objectId, ExtensionsData extension) {
        throw new CmisNotSupportedException();
    }

    public ObjectList getObjectRelationships(String repositoryId, String objectId, Boolean includeSubRelationshipTypes, RelationshipDirection relationshipDirection, String typeId, String filter, Boolean includeAllowableActions, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        IncludeRelationships includeRelationships = relationshipDirection == null || relationshipDirection == RelationshipDirection.SOURCE ? IncludeRelationships.SOURCE : (relationshipDirection == RelationshipDirection.TARGET ? IncludeRelationships.TARGET : IncludeRelationships.BOTH);
        List<ObjectData> rels = NuxeoObjectData.getRelationships(objectId, includeRelationships, this.coreSession, this);
        ListUtils.BatchedList<ObjectData> batch = ListUtils.getBatchedList(rels, maxItems, skipCount, 100);
        ObjectListImpl res = new ObjectListImpl();
        res.setObjects(batch.getList());
        res.setNumItems(batch.getNumItems());
        res.setHasMoreItems(batch.getHasMoreItems());
        return res;
    }

    public void checkIn(String repositoryId, Holder<String> objectIdHolder, Boolean major, Properties properties, ContentStream contentStream, String checkinComment, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        String objectId;
        if (objectIdHolder == null || (objectId = (String)objectIdHolder.getValue()) == null) {
            throw new CmisInvalidArgumentException("Missing object ID");
        }
        VersioningOption option = Boolean.TRUE.equals(major) ? VersioningOption.MAJOR : VersioningOption.MINOR;
        DocumentModel doc = this.getDocumentModel(objectId);
        if (doc.isVersion() || doc.isProxy()) {
            throw new CmisInvalidArgumentException("Cannot check in non-PWC: " + doc);
        }
        NuxeoObjectData object = new NuxeoObjectData(this, doc);
        this.updateProperties(object, null, properties, false);
        if (contentStream != null) {
            try {
                NuxeoPropertyData.setContentStream(doc, contentStream, true);
            }
            catch (IOException e) {
                throw new CmisRuntimeException(e.toString(), (Throwable)e);
            }
        }
        try {
            this.coreSession.saveDocument(doc);
            DocumentRef ver = doc.checkIn(option, checkinComment);
            doc.removeLock();
            this.coreSession.save();
            objectIdHolder.setValue((Object)this.getIdFromDocumentRef(ver));
        }
        catch (ClientException e) {
            throw new CmisRuntimeException(e.toString(), (Throwable)e);
        }
    }

    public String checkIn(String objectId, boolean major, Map<String, ?> properties, ObjectType type, ContentStream contentStream, String checkinComment) {
        VersioningOption option = major ? VersioningOption.MAJOR : VersioningOption.MINOR;
        DocumentModel doc = this.getDocumentModel(objectId);
        if (doc.isVersion() || doc.isProxy()) {
            throw new CmisInvalidArgumentException("Cannot check in non-PWC: " + doc);
        }
        NuxeoObjectData object = new NuxeoObjectData(this, doc);
        this.updateProperties(object, null, properties, (TypeDefinition)type, false);
        if (contentStream != null) {
            try {
                NuxeoPropertyData.setContentStream(doc, contentStream, true);
            }
            catch (IOException e) {
                throw new CmisRuntimeException(e.toString(), (Throwable)e);
            }
        }
        try {
            this.coreSession.saveDocument(doc);
            DocumentRef ver = doc.checkIn(option, checkinComment);
            doc.removeLock();
            this.coreSession.save();
            return this.getIdFromDocumentRef(ver);
        }
        catch (ClientException e) {
            throw new CmisRuntimeException(e.toString(), (Throwable)e);
        }
    }

    public void checkOut(String repositoryId, Holder<String> objectIdHolder, ExtensionsData extension, Holder<Boolean> contentCopiedHolder) {
        String objectId;
        if (objectIdHolder == null || (objectId = (String)objectIdHolder.getValue()) == null) {
            throw new CmisInvalidArgumentException("Missing object ID");
        }
        String pwcId = this.checkOut(objectId);
        objectIdHolder.setValue((Object)pwcId);
        if (contentCopiedHolder != null) {
            contentCopiedHolder.setValue((Object)Boolean.TRUE);
        }
    }

    public String checkOut(String objectId) {
        DocumentModel doc = this.getDocumentModel(objectId);
        try {
            DocumentModel pwc;
            if (doc.isProxy()) {
                throw new CmisInvalidArgumentException("Cannot check out non-version: " + objectId);
            }
            if (doc.isVersion()) {
                pwc = this.coreSession.getWorkingCopy(doc.getRef());
                if (pwc == null) {
                    throw new CmisObjectNotFoundException(objectId);
                }
            } else {
                pwc = doc;
            }
            if (pwc.isCheckedOut()) {
                throw new CmisConstraintException("Already checked out: " + objectId);
            }
            if (pwc.isLocked()) {
                throw new CmisInvalidArgumentException("Cannot check out since currently locked: " + objectId);
            }
            pwc.setLock();
            pwc.checkOut();
            this.coreSession.save();
            return pwc.getId();
        }
        catch (ClientException e) {
            throw new CmisRuntimeException(e.toString(), (Throwable)e);
        }
    }

    public void cancelCheckOut(String repositoryId, String objectId, ExtensionsData extension) {
        this.cancelCheckOut(objectId);
    }

    public void cancelCheckOut(String objectId) {
        DocumentModel doc = this.getDocumentModel(objectId);
        try {
            if (doc.isVersion() || doc.isProxy() || !doc.isCheckedOut()) {
                throw new CmisInvalidArgumentException("Cannot cancel check out of non-PWC: " + doc);
            }
            DocumentRef docRef = doc.getRef();
            DocumentRef verRef = this.coreSession.getLastDocumentVersionRef(docRef);
            if (verRef == null) {
                this.coreSession.removeDocument(docRef);
            } else {
                this.coreSession.restoreToVersion(docRef, verRef, true, true);
                doc.removeLock();
            }
            this.coreSession.save();
        }
        catch (ClientException e) {
            throw new CmisRuntimeException(e.toString(), (Throwable)e);
        }
    }

    public ObjectList getCheckedOutDocs(String repositoryId, String folderId, String filter, String orderBy, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        List<String> props = StringUtils.isBlank((String)filter) ? Arrays.asList("cmis:objectId", "cmis:objectTypeId", "cmis:baseTypeId") : NuxeoObjectData.getPropertyIdsFromFilter(filter);
        ArrayList<String> clauses = new ArrayList<String>(3);
        clauses.add("nuxeo:isVersion = false");
        clauses.add("(nuxeo:isCheckedIn = false OR nuxeo:isCheckedIn IS NULL)");
        if (folderId != null) {
            String qid = "'" + folderId.replace("'", "''") + "'";
            clauses.add("IN_FOLDER(" + qid + ")");
        }
        String order = StringUtils.isBlank((String)orderBy) ? "" : " ORDER BY " + orderBy;
        String statement = "SELECT " + StringUtils.join(props, (String)", ") + " FROM " + BaseTypeId.CMIS_DOCUMENT.value() + " WHERE " + StringUtils.join(clauses, (String)" AND ") + order;
        Boolean searchAllVersions = Boolean.TRUE;
        return this.query(repositoryId, statement, searchAllVersions, includeAllowableActions, includeRelationships, renditionFilter, maxItems, skipCount, extension);
    }

    public List<ObjectData> getAllVersions(String repositoryId, String objectId, String versionSeriesId, String filter, Boolean includeAllowableActions, ExtensionsData extension) {
        DocumentModel doc;
        if (objectId != null) {
            doc = this.getDocumentModel(objectId);
        } else if (versionSeriesId != null) {
            doc = this.getDocumentModel(versionSeriesId);
        } else {
            throw new CmisInvalidArgumentException("Missing object ID or version series ID");
        }
        try {
            DocumentModel pwc;
            List versions = this.coreSession.getVersionsRefs(doc.getRef());
            ArrayList<ObjectData> list = new ArrayList<ObjectData>(versions.size());
            for (DocumentRef verRef : versions) {
                String verId = this.getIdFromDocumentRef(verRef);
                NuxeoObjectData od = this.getObject(repositoryId, verId, filter, includeAllowableActions, IncludeRelationships.NONE, null, Boolean.FALSE, Boolean.FALSE, null);
                list.add(od);
            }
            DocumentModel documentModel = pwc = doc.isVersion() ? this.coreSession.getWorkingCopy(doc.getRef()) : doc;
            if (pwc != null && pwc.isCheckedOut()) {
                NuxeoObjectData od = new NuxeoObjectData(this, pwc, filter, includeAllowableActions, IncludeRelationships.NONE, null, Boolean.FALSE, Boolean.FALSE, extension);
                list.add(od);
            }
            Collections.reverse(list);
            return list;
        }
        catch (ClientException e) {
            throw new CmisRuntimeException(e.toString(), (Throwable)e);
        }
    }

    public NuxeoObjectData getObjectOfLatestVersion(String repositoryId, String objectId, String versionSeriesId, Boolean major, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        DocumentModel doc;
        if (objectId != null) {
            doc = this.getDocumentModel(objectId);
        } else if (versionSeriesId != null) {
            doc = this.getDocumentModel(versionSeriesId);
        } else {
            throw new CmisInvalidArgumentException("Missing object ID or version series ID");
        }
        try {
            if (Boolean.TRUE.equals(major)) {
                List versions = this.coreSession.getVersions(doc.getRef());
                Collections.reverse(versions);
                for (DocumentModel ver : versions) {
                    if (!ver.isMajorVersion()) continue;
                    return this.getObject(repositoryId, ver.getId(), filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl, null);
                }
                return null;
            }
            DocumentRef verRef = this.coreSession.getLastDocumentVersionRef(doc.getRef());
            String verId = this.getIdFromDocumentRef(verRef);
            return this.getObject(repositoryId, verId, filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl, null);
        }
        catch (ClientException e) {
            throw new CmisRuntimeException(e.toString(), (Throwable)e);
        }
    }

    public Properties getPropertiesOfLatestVersion(String repositoryId, String objectId, String versionSeriesId, Boolean major, String filter, ExtensionsData extension) {
        NuxeoObjectData od = this.getObjectOfLatestVersion(repositoryId, objectId, versionSeriesId, major, filter, Boolean.FALSE, IncludeRelationships.NONE, null, Boolean.FALSE, Boolean.FALSE, null);
        return od == null ? null : od.getProperties();
    }

    public void deleteObject(String repositoryId, String objectId, Boolean allVersions, ExtensionsData extension) {
        try {
            DocumentModelList docs;
            DocumentModel doc = this.getDocumentModel(objectId);
            if (doc.isFolder() && (docs = this.coreSession.getChildren((DocumentRef)new IdRef(objectId), null, this.documentFilter, null)).size() > 0) {
                throw new CmisConstraintException("Cannot delete non-empty folder: " + objectId);
            }
            this.coreSession.removeDocument(doc.getRef());
            this.coreSession.save();
        }
        catch (ClientException e) {
            throw new CmisRuntimeException(e.toString(), (Throwable)e);
        }
    }

    public void deleteObjectOrCancelCheckOut(String repositoryId, String objectId, Boolean allVersions, ExtensionsData extension) {
        try {
            DocumentModel doc = this.getDocumentModel(objectId);
            DocumentRef docRef = doc.getRef();
            DocumentRef verRef = this.coreSession.getLastDocumentVersionRef(docRef);
            if (verRef != null && doc.isLocked() && doc.isCheckedOut()) {
                this.cancelCheckOut(repositoryId, objectId, extension);
            } else {
                this.deleteObject(repositoryId, objectId, allVersions, extension);
            }
        }
        catch (ClientException e) {
            throw new CmisRuntimeException(e.toString(), (Throwable)e);
        }
    }

    public static class OrderByComparator
    implements Comparator<ObjectInFolderData> {
        protected static String ASC = " asc";
        protected static String DESC = " desc";
        protected String[] props;
        protected boolean[] descs;

        public OrderByComparator(String orderBy, NuxeoRepository repository) {
            TypeManagerImpl typeManager = repository.getTypeManager();
            String[] orders = orderBy.split(",");
            this.props = new String[orders.length];
            this.descs = new boolean[orders.length];
            for (int i = 0; i < orders.length; ++i) {
                boolean desc;
                String prop;
                String order = orders[i].trim();
                String lower = order.toLowerCase();
                if (lower.endsWith(DESC)) {
                    prop = order.substring(0, order.length() - DESC.length()).trim();
                    desc = true;
                } else if (lower.endsWith(ASC)) {
                    prop = order.substring(0, order.length() - ASC.length()).trim();
                    desc = false;
                } else {
                    prop = order;
                    desc = false;
                }
                String propId = typeManager.getPropertyIdForQueryName(prop);
                if (propId == null) {
                    throw new CmisInvalidArgumentException("Invalid orderBy: " + orderBy);
                }
                this.props[i] = propId;
                this.descs[i] = desc;
            }
        }

        @Override
        public int compare(ObjectInFolderData ob1, ObjectInFolderData ob2) {
            int cmp = 0;
            for (int i = 0; i < this.props.length; ++i) {
                Object v2;
                String prop = this.props[i];
                boolean desc = this.descs[i];
                NuxeoPropertyDataBase<?> p1 = ((NuxeoObjectData)ob1.getObject()).getProperty(prop);
                NuxeoPropertyDataBase<?> p2 = ((NuxeoObjectData)ob2.getObject()).getProperty(prop);
                Object v1 = p1 == null ? null : p1.getValue();
                Object t = v2 = p2 == null ? null : (Object)p2.getValue();
                cmp = v1 == null && v2 == null ? 0 : (v1 == null ? -1 : (v2 == null ? 1 : ((Comparable)v1).compareTo(v2)));
                if (desc) {
                    cmp = -cmp;
                }
                if (cmp != 0) break;
            }
            return cmp;
        }
    }
}

