/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.suggestbox.handlers;

import edu.emory.mathcs.backport.java.util.Collections;
import java.io.Serializable;
import java.util.Map;
import org.jboss.seam.Component;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.platform.contentview.jsf.ContentView;
import org.nuxeo.ecm.platform.contentview.seam.ContentViewActions;
import org.nuxeo.ecm.platform.faceted.search.jsf.FacetedSearchActions;
import org.nuxeo.ecm.platform.suggestbox.service.SearchDocumentsSuggestion;
import org.nuxeo.ecm.virtualnavigation.action.MultiNavTreeManager;

@Operation(id="Suggestion.JSF.NavigateToFacetedSearch", category="User Interface", label="FacetedSearchSuggestionHandler", description="")
public class FacetedSearchSuggestionHandler {
    public static final String ID = "Suggestion.JSF.NavigateToFacetedSearch";

    @OperationMethod
    public Object run(Object input) throws OperationException, ClientException {
        if (!(input instanceof SearchDocumentsSuggestion)) {
            throw new OperationException(String.format("Expected an instance of SearchDocumentsSuggestion, got '%s'", input));
        }
        SearchDocumentsSuggestion suggestion = (SearchDocumentsSuggestion)input;
        MultiNavTreeManager multiNavTreeManager = (MultiNavTreeManager)Component.getInstance(MultiNavTreeManager.class);
        FacetedSearchActions facetedSearchActions = (FacetedSearchActions)Component.getInstance(FacetedSearchActions.class);
        ContentViewActions contentViewActions = (ContentViewActions)Component.getInstance(ContentViewActions.class);
        facetedSearchActions.clearSearch();
        facetedSearchActions.setCurrentContentViewName(null);
        String contentViewName = facetedSearchActions.getCurrentContentViewName();
        ContentView contentView = contentViewActions.getContentView(contentViewName);
        DocumentModel dm = contentView.getSearchDocumentModel();
        for (Map.Entry searchEntry : suggestion.getSearchCriteria().entrySet()) {
            String searchField = (String)searchEntry.getKey();
            Serializable searchValue = (Serializable)searchEntry.getValue();
            Property searchProperty = dm.getProperty(searchField);
            if (searchProperty.isList()) {
                dm.setPropertyValue(searchField, (Serializable)((Object)Collections.singleton((Object)searchValue)));
                continue;
            }
            dm.setPropertyValue(searchField, searchValue);
        }
        multiNavTreeManager.setSelectedNavigationTree("facetedSearch");
        return "faceted_search_results";
    }
}

