/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.packages.dependencies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.packages.InternalPackageManager;
import org.nuxeo.connect.packages.dependencies.DependencyResolution;
import org.nuxeo.connect.packages.dependencies.DependencySet;
import org.nuxeo.connect.packages.dependencies.TargetPlatformFilterHelper;
import org.nuxeo.connect.packages.dependencies.UpdateCheckResult;
import org.nuxeo.connect.update.Package;
import org.nuxeo.connect.update.PackageDependency;
import org.nuxeo.connect.update.Version;
import org.nuxeo.connect.update.VersionRange;

public class RecursiveDependencyResolver {
    protected String packageId;
    protected String targetPlatform;
    protected InternalPackageManager pm;
    protected boolean resolved = false;
    protected DependencyResolution resolution;
    protected List<DependencyResolution> fallBacks = new ArrayList<DependencyResolution>();
    protected Map<String, List<Version>> deps = new HashMap<String, List<Version>>();
    protected List<String> orderedPackages = new ArrayList<String>();
    protected List<DownloadablePackage> installedPackages;

    public RecursiveDependencyResolver(String packageId, InternalPackageManager pm, String targetPlatform) {
        this.packageId = packageId;
        this.pm = pm;
        this.targetPlatform = targetPlatform;
    }

    public void sort(InternalPackageManager pm) {
        for (String pkgName : this.deps.keySet()) {
            List<Version> versions = this.deps.get(pkgName);
            List<Version> orderedVersion = pm.getPreferedVersions(pkgName);
            Collections.reverse(orderedVersion);
            for (Version v : orderedVersion) {
                if (!versions.contains(v)) continue;
                versions.remove(v);
                versions.add(0, v);
            }
        }
    }

    public DependencyResolution tryResolve() {
        this.resolved = false;
        for (String pkgName : this.deps.keySet()) {
            for (Version v : this.deps.get(pkgName)) {
                DependencySet set = new DependencySet(this.deps.keySet());
                if (this.resolved) continue;
                this.buildDependencySet(set, pkgName, v);
            }
        }
        if (this.resolved) {
            return this.resolution;
        }
        if (this.fallBacks.size() > 0) {
            DependencyResolution fbRes = this.fallBacks.get(0);
            fbRes.markAsSuccess();
            return fbRes;
        }
        return null;
    }

    protected void buildDependencySet(DependencySet set, String packageName, Version v) {
        set.set(packageName, v);
        if (!this.resolved) {
            if (!set.isComplete()) {
                String pkgName = set.getNextPackageName();
                for (Version v2 : this.deps.get(pkgName)) {
                    this.buildDependencySet(set.clone(), pkgName, v2);
                }
            } else {
                this.resolution = this.resolve(set);
                if (this.resolution.isValidated()) {
                    UpdateCheckResult updateRes = this.checkForUpdates(set);
                    if (!updateRes.requireUpdate) {
                        this.resolved = true;
                    } else if (!updateRes.isUpdatePossible()) {
                        this.resolution.markAsFailed();
                        for (DownloadablePackage pkg : updateRes.getPackagesToRemove()) {
                            this.resolution.markPackageForRemoval(pkg.getName(), pkg.getVersion());
                        }
                        this.fallBacks.add(this.resolution);
                    } else if (updateRes.isTransparentUpdate()) {
                        for (DownloadablePackage pkg : updateRes.getPackagesToAdd()) {
                            this.resolution.addPackage(pkg.getName(), pkg.getVersion());
                        }
                        this.resolution.sort(this.pm);
                        this.resolved = true;
                    }
                }
            }
        }
    }

    protected List<DownloadablePackage> getInstalledPackages() {
        if (this.installedPackages == null) {
            this.installedPackages = this.pm.listInstalledPackages();
        }
        return this.installedPackages;
    }

    protected UpdateCheckResult checkForUpdates(DependencySet set) {
        UpdateCheckResult result = new UpdateCheckResult();
        HashMap toUpdatePackageNames = new HashMap();
        for (DownloadablePackage pkg : this.getInstalledPackages()) {
            for (PackageDependency dep : pkg.getDependencies()) {
                if (set.getTargetVersion(dep.getName()) == null || dep.getVersionRange().matchVersion(set.getTargetVersion(dep.getName()))) continue;
                result.setRequireUpdate(true);
                ArrayList<DownloadablePackage> possibleUpdates = (ArrayList<DownloadablePackage>)toUpdatePackageNames.get(pkg.getName());
                if (possibleUpdates == null) {
                    List<DownloadablePackage> unfiltredPossibleUpdates = this.pm.findRemotePackages(pkg.getName());
                    possibleUpdates = new ArrayList<DownloadablePackage>();
                    for (DownloadablePackage pup : unfiltredPossibleUpdates) {
                        if (!TargetPlatformFilterHelper.isCompatibleWithTargetPlatform(pup, this.targetPlatform)) continue;
                        possibleUpdates.add(pup);
                    }
                }
                ArrayList<DownloadablePackage> filtredPossibleUpdates = new ArrayList<DownloadablePackage>();
                for (DownloadablePackage pupdate : possibleUpdates) {
                    for (PackageDependency newDep : pupdate.getDependencies()) {
                        if (!newDep.getName().equals(dep.getName()) || !newDep.getVersionRange().matchVersion(set.getTargetVersion(dep.getName()))) continue;
                        filtredPossibleUpdates.add(pupdate);
                    }
                }
                if (filtredPossibleUpdates.size() == 0) {
                    result.setUpdatePossible(pkg.getName(), false);
                    result.addPackageToRemove(pkg);
                    continue;
                }
                result.setUpdatePossible(pkg.getName(), true);
                toUpdatePackageNames.put(pkg.getName(), filtredPossibleUpdates);
            }
        }
        if (toUpdatePackageNames.size() == 0) {
            return result;
        }
        if (!result.isUpdatePossible()) {
            return result;
        }
        ArrayList<DownloadablePackage> choosenPackgesToUpdate = new ArrayList<DownloadablePackage>();
        HashMap dependencyUpdates = new HashMap();
        for (String pkgName : toUpdatePackageNames.keySet()) {
            HashMap oneDependencyUpdatesOptimal = new HashMap();
            for (DownloadablePackage pkg : (List)toUpdatePackageNames.get(pkgName)) {
                HashMap<String, VersionRange> oneDependencyUpdates = new HashMap<String, VersionRange>();
                for (PackageDependency dep : pkg.getDependencies()) {
                    if (set.getTargetVersion(dep.getName()) == null) {
                        oneDependencyUpdates.put(dep.getName(), dep.getVersionRange());
                        continue;
                    }
                    if (dep.getVersionRange().matchVersion(set.getTargetVersion(dep.getName()))) continue;
                    oneDependencyUpdates.put(dep.getName(), dep.getVersionRange());
                }
                if (oneDependencyUpdates.size() > oneDependencyUpdatesOptimal.size()) continue;
                oneDependencyUpdatesOptimal = oneDependencyUpdates;
                choosenPackgesToUpdate.add(pkg);
            }
            dependencyUpdates.putAll(oneDependencyUpdatesOptimal);
        }
        if (dependencyUpdates.size() == 0) {
            result.setTransparentUpdate();
            for (DownloadablePackage pkg : choosenPackgesToUpdate) {
                result.addPackage(pkg);
            }
        }
        return result;
    }

    public void addDep(String pkgName, List<Version> versions) {
        if (!this.deps.containsKey(pkgName)) {
            this.deps.put(pkgName, versions);
        } else {
            List<Version> existingVersions = this.deps.get(pkgName);
            for (Version v : versions) {
                if (existingVersions.contains(v)) continue;
                existingVersions.add(v);
            }
        }
        this.orderedPackages.remove(pkgName);
        this.orderedPackages.add(pkgName);
    }

    protected DependencyResolution resolve(DependencySet depSet) {
        return this.resolve(this.packageId, depSet);
    }

    protected DependencyResolution resolve(String pkgId, DependencySet depSet) {
        DependencyResolution res = new DependencyResolution();
        DownloadablePackage pkg = this.pm.getPackage(pkgId);
        this.recurseResolve(pkg, res, depSet);
        if (!res.isFailed()) {
            res.markAsSuccess();
        }
        return res;
    }

    protected void recurseResolve(Package pkg, DependencyResolution res, DependencySet depSet) {
        for (PackageDependency dep : pkg.getDependencies()) {
            Version targetVersion = depSet.getTargetVersion(dep.getName());
            if (!dep.getVersionRange().matchVersion(targetVersion)) {
                res.markAsFailed();
                return;
            }
            if (!res.addPackage(dep.getName(), targetVersion)) {
                return;
            }
            DownloadablePackage subPkg = this.pm.findPackageById(dep.getName() + "-" + targetVersion.toString());
            this.recurseResolve(subPkg, res, depSet);
        }
    }

    public int getNaxPossibilities() {
        int res = 1;
        for (String pkgName : this.deps.keySet()) {
            res *= this.deps.get(pkgName).size();
        }
        return res;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (String pkgName : this.deps.keySet()) {
            sb.append(pkgName);
            sb.append(" : ");
            for (Version v : this.deps.get(pkgName)) {
                sb.append(v.toString());
                sb.append(", ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public List<String> getOrderedPackages() {
        return this.orderedPackages;
    }
}

