/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.packages.dependencies;

import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.nuxeo.connect.data.DownloadablePackage;

public class TargetPlatformFilterHelper {
    public static boolean isCompatibleWithTargetPlatform(DownloadablePackage pkg, String targetPlatform) {
        if (targetPlatform == null) {
            return true;
        }
        if (pkg.getTargetPlatforms() == null || pkg.getTargetPlatforms().length == 0) {
            return true;
        }
        for (String pf : pkg.getTargetPlatforms()) {
            if (!FilenameUtils.wildcardMatch((String)targetPlatform, (String)pf, (IOCase)IOCase.INSENSITIVE)) continue;
            return true;
        }
        return false;
    }
}

