/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.image;

import it.tidalwave.image.ImageModel;
import it.tidalwave.image.ImageModelHolder;
import it.tidalwave.image.Quality;
import it.tidalwave.image.java2d.ImplementationFactoryJ2D;
import it.tidalwave.image.metadata.EXIFDirectory;
import it.tidalwave.image.metadata.MakerNote;
import it.tidalwave.image.metadata.RAWMakerNoteReader;
import it.tidalwave.image.metadata.WorkaroundBM25;
import it.tidalwave.image.op.CreateOp;
import it.tidalwave.image.op.ImplementationFactoryRegistry;
import it.tidalwave.image.op.Operation;
import it.tidalwave.image.op.OperationImplementation;
import it.tidalwave.image.op.ReadOp;
import it.tidalwave.image.op.ScaleOp;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditableImage
implements Cloneable,
Serializable {
    private static final String CLASS = EditableImage.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private static WorkaroundBM25 workaroundBM25;
    private static RAWMakerNoteReader rawMakerNoteReader;
    private ImageModelHolder imageModelHolder;
    private transient IIOMetadata iioMetadata;
    private transient EXIFDirectory exifDirectory = new EXIFDirectory();
    private transient MakerNote makerNote = new MakerNote();
    private Map<String, Object> attributeMapByName = new HashMap<String, Object>();
    public long latestOperationTime;
    private int latestSerializationSize;

    public EditableImage() {
    }

    public EditableImage(ImageModel imageModel) {
        this.imageModelHolder = ImageModelHolder.wrap(imageModel);
    }

    public static EditableImage create(CreateOp createOp) {
        EditableImage.checkNotNull(createOp, "createOp");
        EditableImage editableImage = new EditableImage(null);
        Object image = editableImage.internalExecute(createOp);
        editableImage.imageModelHolder = ImageModelHolder.wrap(ImplementationFactoryRegistry.getInstance().createImageModel(image));
        return editableImage;
    }

    public static EditableImage create(ReadOp readOp) throws IOException {
        EditableImage.checkNotNull(readOp, "readOp");
        return readOp.execute();
    }

    public final boolean hasRaster() {
        return this.imageModelHolder.get() != null;
    }

    public final ImageModel getImageModel() {
        return this.imageModelHolder.get();
    }

    public static Collection<String> getAvailableExtensions() {
        logger.info("getAvailableExtensions()");
        TreeSet<String> suffixList = new TreeSet<String>();
        for (String formatName : ImageIO.getReaderFormatNames()) {
            Iterator<ImageReader> i = ImageIO.getImageReadersByFormatName(formatName);
            while (i.hasNext()) {
                ImageReader imageReader = i.next();
                ImageReaderSpi originatingProvider = imageReader.getOriginatingProvider();
                String[] suffixes = originatingProvider.getFileSuffixes();
                List<String> suffixesAsList = Arrays.asList(suffixes);
                logger.info(">>>> reader - format name: " + formatName + " provider: " + originatingProvider.getPluginClassName() + " supports " + suffixesAsList);
                suffixList.addAll(suffixesAsList);
            }
        }
        logger.info(">>>> returning " + suffixList);
        return suffixList;
    }

    public final EXIFDirectory getEXIFDirectory() {
        return this.exifDirectory;
    }

    public final MakerNote getMakerNote() {
        return this.makerNote;
    }

    public final int getWidth() {
        return this.imageModelHolder.get().getWidth();
    }

    public final int getHeight() {
        return this.imageModelHolder.get().getHeight();
    }

    public final DataType getDataType() {
        return this.imageModelHolder.get().getDataType();
    }

    public final int getBandCount() {
        return this.imageModelHolder.get().getBandCount();
    }

    public final int getBitsPerBand() {
        return this.getDataType().getSize();
    }

    public final int getBitsPerPixel() {
        return this.getBandCount() * this.getBitsPerBand();
    }

    public final <T extends Operation> T execute(T operation) {
        EditableImage.checkNotNull(operation, "operation");
        long time = System.currentTimeMillis();
        Object image = this.internalExecute(operation);
        this.imageModelHolder.get().setImage(image);
        this.latestOperationTime = System.currentTimeMillis() - time;
        return operation;
    }

    public final EditableImage execute2(Operation operation) {
        try {
            EditableImage.checkNotNull(operation, "operation");
            long time = System.currentTimeMillis();
            Object image = this.internalExecute(operation);
            Class<?> modelClass = this.imageModelHolder.get().getClass();
            Constructor<?> constructor = modelClass.getConstructor(Object.class);
            ImageModel newModel = (ImageModel)constructor.newInstance(image);
            EditableImage result = new EditableImage(newModel);
            result.attributeMapByName = new HashMap<String, Object>(this.attributeMapByName);
            result.latestOperationTime = System.currentTimeMillis() - time;
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final long getLatestOperationTime() {
        return this.latestOperationTime;
    }

    public final EditableImage createSimilarImage() {
        EditableImage imageCopy = this.imageModelHolder.get().createCopy(false);
        imageCopy.attributeMapByName = new HashMap<String, Object>(this.attributeMapByName);
        return imageCopy;
    }

    public final EditableImage cloneImage() {
        EditableImage imageCopy = this.imageModelHolder.get().createCopy(true);
        imageCopy.attributeMapByName = new HashMap<String, Object>(this.attributeMapByName);
        return imageCopy;
    }

    public Object clone() {
        return this.cloneImage();
    }

    public final EditableImage createResizedImage(int width, int height) {
        return this.createResizedImage(width, height, Quality.FASTEST);
    }

    public final EditableImage createResizedImage(int width, int height, Quality quality) {
        double hScale = (double)width / (double)this.getWidth();
        double vScale = (double)height / (double)this.getHeight();
        ScaleOp scaleOp = new ScaleOp(hScale, vScale, quality);
        this.execute(scaleOp);
        return this;
    }

    public final void setAttribute(String name, Object value) {
        this.attributeMapByName.put(name, value);
    }

    public final Object getAttribute(String name) {
        return this.attributeMapByName.get(name);
    }

    public final Object removeAttribute(String name) {
        return this.attributeMapByName.remove(name);
    }

    public final void dispose() {
        this.imageModelHolder.get().dispose();
        this.imageModelHolder = null;
        this.attributeMapByName.clear();
    }

    public final ColorModel getColorModel() {
        return this.imageModelHolder.get().getColorModel();
    }

    public final ICC_Profile getICCProfile() {
        ColorSpace colorSpace = this.getColorModel().getColorSpace();
        if (colorSpace instanceof ICC_ColorSpace) {
            ICC_ColorSpace iccColorSpace = (ICC_ColorSpace)colorSpace;
            return iccColorSpace.getProfile();
        }
        return null;
    }

    public int getLatestSerializationSize() {
        return this.latestSerializationSize;
    }

    public String toString() {
        return "EditableImage[imageModel: " + this.imageModelHolder + ", attributeMap: " + this.attributeMapByName + "]";
    }

    public final <T> T getInnerProperty(Class<T> propertyClass) {
        if (IIOMetadata.class.equals(propertyClass)) {
            return (T)this.iioMetadata;
        }
        return this.imageModelHolder.get().getInnerProperty(propertyClass);
    }

    private Object internalExecute(Operation operation) throws UnsupportedOperationException {
        OperationImplementation implementation;
        Object image;
        block9: {
            ImplementationFactoryRegistry implementationFactoryRegistry = ImplementationFactoryRegistry.getInstance();
            ImageModel imageModel = this.imageModelHolder.get();
            image = imageModel != null ? imageModel.getImage() : null;
            implementation = null;
            if (image == null && !(operation instanceof CreateOp)) {
                throw new RuntimeException("null image with an Op different that CreateOp");
            }
            try {
                implementation = implementationFactoryRegistry.findImplementation(operation, this.imageModelHolder.get(), false);
            }
            catch (UnsupportedOperationException e) {
                logger.warning("No default implementation of " + operation + " for model: " + image);
                implementation = implementationFactoryRegistry.findImplementation(operation, this.imageModelHolder.get(), true);
                logger.info("Found alternate implementation: " + implementation);
                if (operation instanceof CreateOp) break block9;
                if (implementation.getFactory().canConvertFrom(image.getClass())) {
                    logger.info(">>>> CONVERT FROM using " + implementation.getFactory());
                    this.imageModelHolder = ImageModelHolder.wrap(implementation.getFactory().convertFrom(image));
                    image = this.imageModelHolder.get().getImage();
                } else if (this.imageModelHolder.get().getFactory().canConvertTo(implementation.getFactory().getModelClass())) {
                    logger.info(">>>> CONVERT TO " + implementation.getFactory().getModelClass());
                    image = this.imageModelHolder.get().getFactory().convertTo(implementation.getFactory().getModelClass());
                } else {
                    throw new RuntimeException("Shouldn't get here");
                }
                logger.info(">>>> NEW IMAGE " + image + " NEW IMAGE MODEL " + this.imageModelHolder);
            }
        }
        try {
            return implementation.execute(image);
        }
        catch (RuntimeException e) {
            logger.severe("Operation failed, offending image: " + image);
            throw e;
        }
    }

    public void loadDirectories(ImageReader reader, int imageIndex) {
        logger.fine("loadDirectories()");
        if (this.exifDirectory == null) {
            return;
        }
        try {
            this.iioMetadata = reader.getImageMetadata(imageIndex);
            if (this.iioMetadata == null) {
                logger.fine(">>>> null imagemetadata");
                return;
            }
            logger.finer(">>>> metadata class: " + this.iioMetadata.getClass());
            this.exifDirectory.loadEXIF(this.iioMetadata);
            if (EditableImage.isSubClass(this.iioMetadata.getClass(), "it.tidalwave.imageio.raw.RAWMetadataSupport") && rawMakerNoteReader != null) {
                rawMakerNoteReader.readMakerNote(this.iioMetadata, this.makerNote);
            }
        }
        catch (Exception e) {
            if ("ICC APP2 encountered without prior JFIF!".equals(e.getMessage()) && workaroundBM25 != null) {
                try {
                    workaroundBM25.loadEXIFFromJPEGFile(reader, this.exifDirectory);
                }
                catch (Exception e1) {
                    logger.severe("Cannot load EXIF metadata: " + e1);
                    logger.throwing("", "loadDirectories()", e1);
                }
            }
            logger.severe("Cannot load EXIF metadata: " + e);
            logger.throwing("", "loadEXIFMetadata()", e);
        }
    }

    private static boolean isSubClass(Class aClass, String ancestorClassName) {
        while (aClass != null) {
            if (aClass.getName().equals(ancestorClassName)) {
                return true;
            }
            aClass = aClass.getSuperclass();
        }
        return false;
    }

    private static void checkNotNull(Object object, String name) {
        if (object == null) {
            throw new IllegalArgumentException("null " + name);
        }
    }

    static {
        ImplementationFactoryJ2D j2d = ImplementationFactoryJ2D.getInstance();
        try {
            workaroundBM25 = new WorkaroundBM25();
        }
        catch (Throwable e) {
            logger.warning("Workaround for BM25 not enabled because of: " + e);
        }
        try {
            rawMakerNoteReader = new RAWMakerNoteReader();
        }
        catch (Throwable e) {
            logger.warning("RAW maker note support not enabled because of: " + e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DataType {
        BYTE(0),
        UNSIGNED_SHORT(1),
        SHORT(2),
        INT(3),
        FLOAT(4),
        DOUBLE(5),
        UNDEFINED(32);

        private final int value;

        private DataType(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public int getSize() {
            return DataBuffer.getDataTypeSize(this.value);
        }

        public static DataType valueOf(int value) {
            for (DataType dataType : DataType.values()) {
                if (dataType.value() != value) continue;
                return dataType;
            }
            return UNDEFINED;
        }
    }
}

