/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Archetype {
    private static final int BUFFER_SIZE = 65536;
    private static final int MAX_BUFFER_SIZE = 0x100000;
    private static final int MIN_BUFFER_SIZE = 8192;
    static boolean batchMode = false;
    static String outDir = "${artifactId}";
    static File archive;

    public static void main(String[] args) throws Exception {
        ZipFile zip;
        ZipEntry entry;
        int k;
        String tpl;
        if (args.length == 0) {
            System.err.println("Syntax Error: you must specify a project template name");
        }
        if ("-b".equals(tpl = args[k = 0])) {
            batchMode = true;
            if (args.length < 2) {
                System.err.println("Syntax Error: you must specify a project template name");
            }
            tpl = args[++k];
        }
        archive = new File(tpl);
        if (args.length > ++k) {
            outDir = args[k];
        }
        if ((entry = (zip = new ZipFile(archive)).getEntry("archetype.xml")) == null) {
            System.err.println("Invalid archetype zip.");
            System.exit(1);
        }
        BufferedInputStream in = new BufferedInputStream(zip.getInputStream(entry));
        Document doc = Archetype.load(in);
        zip.close();
        Archetype.processArchetype(doc, System.getProperties());
    }

    private static void expandVars(File file, Map<?, ?> vars) throws IOException {
        String content = Archetype.readFile(file);
        content = Archetype.expandVars(content, vars);
        Archetype.writeFile(file, content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File zip, File dir) throws IOException {
        ZipInputStream in = null;
        try {
            in = new ZipInputStream(new BufferedInputStream(new FileInputStream(zip)));
            Archetype.unzip(in, dir);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static void unzip(ZipInputStream in, File dir) throws IOException {
        dir.mkdirs();
        ZipEntry entry = in.getNextEntry();
        while (entry != null) {
            File file = new File(dir, entry.getName());
            if (entry.isDirectory()) {
                file.mkdirs();
            } else {
                file.getParentFile().mkdirs();
                Archetype.copyToFile(in, file);
            }
            entry = in.getNextEntry();
        }
    }

    public static String getShortName(String name) {
        int p = name.lastIndexOf(46);
        if (p > -1) {
            return name.substring(0, p);
        }
        return name;
    }

    public static String expandVars(String expression, Map<?, ?> properties) {
        int p = expression.indexOf("${");
        if (p == -1) {
            return expression;
        }
        char[] buf = expression.toCharArray();
        StringBuilder result = new StringBuilder(buf.length);
        if (p > 0) {
            result.append(expression.substring(0, p));
        }
        StringBuilder varBuf = new StringBuilder();
        boolean dollar = false;
        boolean var = false;
        block5: for (int i = p; i < buf.length; ++i) {
            char c = buf[i];
            switch (c) {
                case '$': {
                    dollar = true;
                    continue block5;
                }
                case '{': {
                    if (dollar) {
                        dollar = false;
                        var = true;
                        continue block5;
                    }
                    result.append(c);
                    continue block5;
                }
                case '}': {
                    if (var) {
                        var = false;
                        String varName = varBuf.toString();
                        varBuf.setLength(0);
                        Object varValue = properties.get(varName);
                        if (varValue != null) {
                            result.append(varValue.toString());
                            continue block5;
                        }
                        result.append("${").append(varName).append('}');
                        continue block5;
                    }
                    result.append(c);
                    continue block5;
                }
                default: {
                    if (var) {
                        varBuf.append(c);
                        continue block5;
                    }
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(File file) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            String string = Archetype.read(in);
            return string;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(InputStream in) throws IOException {
        StringBuilder sb = new StringBuilder();
        byte[] buffer = Archetype.createBuffer(in.available());
        try {
            int read;
            while ((read = in.read(buffer)) != -1) {
                sb.append(new String(buffer, 0, read));
            }
        }
        finally {
            in.close();
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyToFile(InputStream in, File file) throws IOException {
        FileOutputStream out = null;
        try {
            int read;
            out = new FileOutputStream(file);
            byte[] buffer = Archetype.createBuffer(in.available());
            while ((read = in.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, read);
            }
        }
        finally {
            if (out != null) {
                ((OutputStream)out).close();
            }
        }
    }

    private static byte[] createBuffer(int preferredSize) {
        if (preferredSize < 1) {
            preferredSize = 65536;
        }
        if (preferredSize > 0x100000) {
            preferredSize = 0x100000;
        } else if (preferredSize < 8192) {
            preferredSize = 8192;
        }
        return new byte[preferredSize];
    }

    public static Document load(File file) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(file);
    }

    public static Document load(InputStream in) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(in);
    }

    public static void processVars(Element root, Map<Object, Object> vars) throws Exception {
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element el;
            if (node.getNodeType() != 1 || !"var".equals((el = (Element)node).getNodeName())) continue;
            String key = el.getAttribute("name");
            String label = el.getAttribute("label");
            if (label == null) {
                label = key;
            }
            String val = (String)vars.get(key);
            String def = el.getAttribute("default");
            def = def != null ? Archetype.expandVars(def, vars) : val;
            if (!batchMode && val == null && "true".equals(el.getAttribute("prompt"))) {
                val = Archetype.readVar(label, def);
            }
            if (val == null) {
                val = def;
            }
            vars.put(key, val);
        }
    }

    public static void processResources(Element root, File dir, Map<Object, Object> vars) throws Exception {
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            File dst;
            File src;
            String targetName;
            String srcName;
            if (node.getNodeType() != 1) continue;
            Element el = (Element)node;
            if ("directory".equals(el.getNodeName())) {
                srcName = el.getAttribute("src");
                if (srcName == null) {
                    throw new IllegalArgumentException("directory has no src attribute");
                }
                targetName = el.getAttribute("target");
                if (targetName == null) {
                    throw new IllegalArgumentException("directory has no target attribute");
                }
                srcName = Archetype.expandVars(srcName, vars);
                targetName = Archetype.expandVars(targetName, vars);
                src = new File(dir, srcName);
                dst = new File(dir, targetName);
                System.out.println("Renaming " + src + " to " + dst);
                src.renameTo(dst);
                continue;
            }
            if ("package".equals(el.getNodeName())) {
                srcName = el.getAttribute("src");
                if (srcName == null) {
                    throw new IllegalArgumentException("package has no src attribute");
                }
                targetName = el.getAttribute("target");
                if (targetName == null) {
                    throw new IllegalArgumentException("package has no target attribute");
                }
                srcName = Archetype.expandVars(srcName, vars);
                targetName = Archetype.expandVars(targetName, vars);
                targetName = targetName.replaceAll("\\.", "/");
                src = new File(dir, srcName);
                dst = new File(dir, targetName);
                System.out.println("Renaming " + src + " to " + dst);
                dst.getParentFile().mkdirs();
                src.renameTo(dst);
                continue;
            }
            if (!"template".equals(el.getNodeName())) continue;
            srcName = el.getAttribute("src");
            if (srcName == null) {
                throw new IllegalArgumentException("rename has no src attribute");
            }
            File src2 = new File(dir, srcName);
            System.out.println("Processing " + src2);
            Archetype.expandVars(src2, vars);
        }
    }

    public static void processArchetype(Document doc, Map<Object, Object> vars) throws Exception {
        File out;
        Element root = doc.getDocumentElement();
        Element elVars = null;
        Element elRes = null;
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            Element el = (Element)node;
            if ("vars".equals(el.getNodeName())) {
                elVars = el;
                continue;
            }
            if (!"resources".equals(el.getNodeName())) continue;
            elRes = el;
        }
        if (elVars != null) {
            Archetype.processVars(elVars, vars);
        }
        if ((out = new File(outDir = Archetype.expandVars(outDir, vars))).exists()) {
            System.out.println("Target directory already exists: " + out);
            System.out.println("Please specify as target a directory to be created. Exiting.");
            System.exit(1);
        }
        Archetype.unzip(archive, out);
        new File(out, "archetype.xml").delete();
        if (elRes != null) {
            Archetype.processResources(elRes, out, vars);
        }
    }

    public static String readVar(String key, String value) throws IOException {
        System.out.print(key + (value == null ? ": " : " [" + value + "]: "));
        StringBuilder buf = new StringBuilder();
        int c = System.in.read();
        while (c != -1) {
            if (c == 10 || c == 13) {
                if (buf.length() == 0) {
                    if (value == null) {
                        System.out.println(key + (value == null ? ": " : " [" + value + "]: "));
                        break;
                    }
                    return value;
                }
                return buf.toString();
            }
            buf.append((char)c);
            c = System.in.read();
        }
        return value;
    }

    public static File unzipArchetype(File zipFile) throws IOException {
        File file = File.createTempFile("nuxeo_archetype_" + zipFile.getName(), ".tmp");
        file.delete();
        file.mkdirs();
        Archetype.unzip(zipFile, file);
        return file;
    }

    public static void deleteTree(File dir) {
        Archetype.emptyDirectory(dir);
        dir.delete();
    }

    public static void emptyDirectory(File dir) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                Archetype.deleteTree(file);
                continue;
            }
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File file, byte[] buf) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            fos.write(buf);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    public static void writeFile(File file, String buf) throws IOException {
        Archetype.writeFile(file, buf.getBytes());
    }

    public static void launch(String[] args) {
    }
}

