/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.user.center.profile;

import java.util.Map;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.platform.userworkspace.api.UserWorkspaceService;
import org.nuxeo.ecm.user.center.profile.SimpleCache;
import org.nuxeo.ecm.user.center.profile.UserProfileService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;

public class UserProfileServiceImpl
extends DefaultComponent
implements UserProfileService {
    private UserWorkspaceService userWorkspaceService;
    protected final SimpleCache<String> profileUidCache = new SimpleCache(1000);

    @Override
    public DocumentModel getUserProfileDocument(CoreSession session) throws ClientException {
        DocumentModel userWorkspace = this.getUserWorkspaceService().getCurrentUserPersonalWorkspace(session, null);
        String uid = this.profileUidCache.getIfPresent(session.getPrincipal().getName());
        if (uid != null) {
            return session.getDocument((DocumentRef)new IdRef(uid));
        }
        DocumentModel profile = new UserProfileDocumentGetter(session, userWorkspace).getOrCreate();
        this.profileUidCache.put(session.getPrincipal().getName(), profile.getId());
        return profile;
    }

    @Override
    public DocumentModel getUserProfileDocument(String userName, CoreSession session) throws ClientException {
        DocumentModel userWorkspace = this.getUserWorkspaceService().getUserPersonalWorkspace(userName, session.getRootDocument());
        String uid = this.profileUidCache.getIfPresent(userName);
        if (uid != null) {
            return session.getDocument((DocumentRef)new IdRef(uid));
        }
        DocumentModel profile = new UserProfileDocumentGetter(session, userWorkspace).getOrCreate();
        this.profileUidCache.put(userName, profile.getId());
        return profile;
    }

    @Override
    public DocumentModel getUserProfile(DocumentModel userModel, CoreSession session) throws ClientException {
        DocumentModel userProfileDoc = this.getUserProfileDocument(userModel.getId(), session);
        userProfileDoc.detach(true);
        userProfileDoc.getDataModels().putAll((Map)userModel.getDataModels());
        return userProfileDoc;
    }

    private UserWorkspaceService getUserWorkspaceService() {
        if (this.userWorkspaceService == null) {
            this.userWorkspaceService = (UserWorkspaceService)Framework.getLocalService(UserWorkspaceService.class);
        }
        return this.userWorkspaceService;
    }

    @Override
    public void clearCache() {
        this.profileUidCache.clear();
    }

    private class UserProfileDocumentGetter
    extends UnrestrictedSessionRunner {
        private DocumentModel userWorkspace;
        private DocumentRef userProfileDocRef;

        public UserProfileDocumentGetter(CoreSession session, DocumentModel userWorkspace) {
            super(session);
            this.userWorkspace = userWorkspace;
        }

        public void run() throws ClientException {
            String query = "select * from UserProfile where ecm:parentId='" + this.userWorkspace.getId() + "' " + " AND ecm:isProxy = 0 " + " AND ecm:isCheckedInVersion = 0 AND ecm:currentLifeCycleState != 'deleted'";
            DocumentModelList children = this.session.query(query);
            if (!children.isEmpty()) {
                this.userProfileDocRef = ((DocumentModel)children.get(0)).getRef();
            } else {
                DocumentModel userProfileDoc = this.session.createDocumentModel(this.userWorkspace.getPathAsString(), String.valueOf(System.currentTimeMillis()), "UserProfile");
                userProfileDoc = this.session.createDocument(userProfileDoc);
                this.userProfileDocRef = userProfileDoc.getRef();
                ACP acp = this.session.getACP(this.userProfileDocRef);
                ACL acl = acp.getOrCreateACL();
                acl.add((Object)new ACE("Everyone", "Read", true));
                acp.addACL(acl);
                this.session.setACP(this.userProfileDocRef, acp, true);
                this.session.save();
            }
        }

        public DocumentModel getOrCreate() throws ClientException {
            if (this.session.hasPermission(this.userWorkspace.getRef(), "AddChildren")) {
                this.run();
            } else {
                this.runUnrestricted();
            }
            return this.session.getDocument(this.userProfileDocRef);
        }
    }
}

