/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmimemagic;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.sf.jmimemagic.MagicDetector;
import net.sf.jmimemagic.MagicMatch;
import net.sf.jmimemagic.UnsupportedTypeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.oro.text.perl.Perl5Util;

public class MagicMatcher
implements Cloneable {
    private static Log log = LogFactory.getLog((Class)(class$net$sf$jmimemagic$MagicMatcher == null ? (class$net$sf$jmimemagic$MagicMatcher = MagicMatcher.class$("net.sf.jmimemagic.MagicMatcher")) : class$net$sf$jmimemagic$MagicMatcher));
    private ArrayList subMatchers = new ArrayList(0);
    private MagicMatch match = null;
    static /* synthetic */ Class class$net$sf$jmimemagic$MagicMatcher;

    public MagicMatcher() {
        log.debug((Object)"instantiated");
    }

    public void setMatch(MagicMatch match) {
        log.debug((Object)"setMatch()");
        this.match = match;
    }

    public MagicMatch getMatch() {
        log.debug((Object)"getMatch()");
        return this.match;
    }

    public boolean isValid() {
        log.debug((Object)"isValid()");
        if (this.match == null || this.match.getTest() == null) {
            return false;
        }
        String type = new String(this.match.getTest().array());
        char comparator = this.match.getComparator();
        String description = this.match.getDescription();
        String test = new String(this.match.getTest().array());
        return type != null && !type.equals("") && comparator != '\u0000' && (comparator == '=' || comparator == '!' || comparator == '>' || comparator == '<') && description != null && !description.equals("") && test != null && !test.equals("");
    }

    public void addSubMatcher(MagicMatcher m) {
        log.debug((Object)"addSubMatcher()");
        this.subMatchers.add(m);
    }

    public void setSubMatchers(Collection a) {
        log.debug((Object)("setSubMatchers(): for match '" + this.match.getDescription() + "'"));
        this.subMatchers.clear();
        this.subMatchers.addAll(a);
    }

    public Collection getSubMatchers() {
        log.debug((Object)"getSubMatchers()");
        return this.subMatchers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MagicMatch test(File f, boolean onlyMimeMatch) throws IOException, UnsupportedTypeException {
        log.debug((Object)"test(File)");
        int offset = this.match.getOffset();
        String description = this.match.getDescription();
        String type = this.match.getType();
        String mimeType = this.match.getMimeType();
        log.debug((Object)("test(File): testing '" + f.getName() + "' for '" + description + "'"));
        log.debug((Object)"test(File): \n=== BEGIN MATCH INFO ==");
        log.debug((Object)this.match.print());
        log.debug((Object)"test(File): \n=== END MATCH INFO ====\n");
        RandomAccessFile file = null;
        file = new RandomAccessFile(f, "r");
        int length = 0;
        if (type.equals("byte")) {
            length = 1;
        } else if (type.equals("short") || type.equals("leshort") || type.equals("beshort")) {
            length = 4;
        } else if (type.equals("long") || type.equals("lelong") || type.equals("belong")) {
            length = 8;
        } else if (type.equals("string")) {
            length = this.match.getTest().capacity();
        } else if (type.equals("regex")) {
            length = (int)file.length() - offset;
            if (length < 0) {
                length = 0;
            }
        } else if (type.equals("detector")) {
            length = (int)file.length() - offset;
            if (length < 0) {
                length = 0;
            }
        } else {
            throw new UnsupportedTypeException("unsupported test type '" + type + "'");
        }
        if ((long)length > file.length() - (long)offset) {
            MagicMatch magicMatch = null;
            return magicMatch;
        }
        byte[] buf = new byte[length];
        file.seek(offset);
        int bytesRead = 0;
        int size = 0;
        boolean gotAllBytes = false;
        boolean done = false;
        while (!done) {
            size = file.read(buf, 0, length - bytesRead);
            if (size == -1) {
                throw new IOException("reached end of file before all bytes were read");
            }
            if ((bytesRead += size) != length) continue;
            gotAllBytes = true;
            done = true;
        }
        log.debug((Object)("test(File): stream size is '" + buf.length + "'"));
        MagicMatch match = null;
        MagicMatch submatch = null;
        if (this.testInternal(buf)) {
            match = this.getMatch();
            log.debug((Object)("test(File): testing matched '" + description + "'"));
            if (!onlyMimeMatch && this.subMatchers != null && this.subMatchers.size() > 0) {
                log.debug((Object)("test(File): testing " + this.subMatchers.size() + " submatches for '" + description + "'"));
                for (int i = 0; i < this.subMatchers.size(); ++i) {
                    log.debug((Object)("test(File): testing submatch " + i));
                    MagicMatcher m = (MagicMatcher)this.subMatchers.get(i);
                    submatch = m.test(f, false);
                    if (submatch != null) {
                        log.debug((Object)("test(File): submatch " + i + " matched with '" + submatch.getDescription() + "'"));
                        match.addSubMatch(submatch);
                        continue;
                    }
                    log.debug((Object)("test(File): submatch " + i + " doesn't match"));
                }
            }
        }
        MagicMatch magicMatch = match;
        return magicMatch;
        finally {
            try {
                file.close();
            }
            catch (Exception fce) {}
        }
    }

    public MagicMatch test(byte[] data, boolean onlyMimeMatch) throws IOException, UnsupportedTypeException {
        log.debug((Object)"test(byte[])");
        int offset = this.match.getOffset();
        String description = this.match.getDescription();
        String type = this.match.getType();
        String test = new String(this.match.getTest().array());
        String mimeType = this.match.getMimeType();
        log.debug((Object)("test(byte[]): testing byte[] data for '" + description + "'"));
        log.debug((Object)"test(byte[]): \n=== BEGIN MATCH INFO ==");
        log.debug((Object)this.match.print());
        log.debug((Object)"test(byte[]): \n=== END MATCH INFO ====\n");
        int length = 0;
        if (type.equals("byte")) {
            length = 1;
        } else if (type.equals("short") || type.equals("leshort") || type.equals("beshort")) {
            length = 4;
        } else if (type.equals("long") || type.equals("lelong") || type.equals("belong")) {
            length = 8;
        } else if (type.equals("string")) {
            length = this.match.getTest().capacity();
        } else if (type.equals("regex")) {
            length = data.length - offset - 1;
            if (length < 0) {
                length = 0;
            }
        } else if (type.equals("detector")) {
            length = data.length - offset - 1;
            if (length < 0) {
                length = 0;
            }
        } else {
            throw new UnsupportedTypeException("unsupported test type " + type);
        }
        byte[] buf = new byte[length];
        log.debug((Object)("test(byte[]): offset=" + offset + ",length=" + length + ",data length=" + data.length));
        if (offset + length < data.length) {
            System.arraycopy(data, offset, buf, 0, length);
            log.debug((Object)("test(byte[]): stream size is '" + buf.length + "'"));
            MagicMatch match = null;
            MagicMatch submatch = null;
            if (this.testInternal(buf)) {
                match = this.getMatch();
                log.debug((Object)("test(byte[]): testing matched '" + description + "'"));
                if (!onlyMimeMatch && this.subMatchers != null && this.subMatchers.size() > 0) {
                    log.debug((Object)("test(byte[]): testing " + this.subMatchers.size() + " submatches for '" + description + "'"));
                    for (int i = 0; i < this.subMatchers.size(); ++i) {
                        log.debug((Object)("test(byte[]): testing submatch " + i));
                        MagicMatcher m = (MagicMatcher)this.subMatchers.get(i);
                        submatch = m.test(data, false);
                        if (submatch != null) {
                            log.debug((Object)("test(byte[]): submatch " + i + " matched with '" + submatch.getDescription() + "'"));
                            match.addSubMatch(submatch);
                            continue;
                        }
                        log.debug((Object)("test(byte[]): submatch " + i + " doesn't match"));
                    }
                }
            }
            return match;
        }
        return null;
    }

    private boolean testInternal(byte[] data) {
        log.debug((Object)"testInternal(byte[])");
        if (data.length == 0) {
            return false;
        }
        String type = this.match.getType();
        String test = new String(this.match.getTest().array());
        String mimeType = this.match.getMimeType();
        String description = this.match.getDescription();
        ByteBuffer buffer = ByteBuffer.allocate(data.length);
        if (type != null && test != null && test.length() > 0) {
            if (type.equals("string")) {
                buffer = buffer.put(data);
                return this.testString(buffer);
            }
            if (type.equals("byte")) {
                buffer = buffer.put(data);
                return this.testByte(buffer);
            }
            if (type.equals("short")) {
                buffer = buffer.put(data);
                return this.testShort(buffer);
            }
            if (type.equals("leshort")) {
                buffer = buffer.put(data);
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                return this.testShort(buffer);
            }
            if (type.equals("beshort")) {
                buffer = buffer.put(data);
                buffer.order(ByteOrder.BIG_ENDIAN);
                return this.testShort(buffer);
            }
            if (type.equals("long")) {
                buffer = buffer.put(data);
                return this.testLong(buffer);
            }
            if (type.equals("lelong")) {
                buffer = buffer.put(data);
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                return this.testLong(buffer);
            }
            if (type.equals("belong")) {
                buffer = buffer.put(data);
                buffer.order(ByteOrder.BIG_ENDIAN);
                return this.testLong(buffer);
            }
            if (type.equals("regex")) {
                return this.testRegex(new String(data));
            }
            if (type.equals("detector")) {
                buffer = buffer.put(data);
                return this.testDetector(buffer);
            }
            log.error((Object)("testInternal(byte[]): invalid test type '" + type + "'"));
        } else {
            log.error((Object)("testInternal(byte[]): type or test is empty for '" + mimeType + " - " + description + "'"));
        }
        return false;
    }

    private boolean testByte(ByteBuffer data) {
        log.debug((Object)"testByte()");
        String test = new String(this.match.getTest().array());
        char comparator = this.match.getComparator();
        long bitmask = this.match.getBitmask();
        String s = test;
        byte b = data.get(0);
        b = (byte)((long)b & bitmask);
        log.debug((Object)("testByte(): decoding '" + test + "' to byte"));
        byte tst = Integer.decode(test).byteValue();
        byte t = (byte)(tst & 0xFF);
        log.debug((Object)("testByte(): applying bitmask '" + bitmask + "' to '" + tst + "', result is '" + t + "'"));
        log.debug((Object)("testByte(): comparing byte '" + b + "' to '" + t + "'"));
        switch (comparator) {
            case '=': {
                return t == b;
            }
            case '!': {
                return t != b;
            }
            case '>': {
                return t > b;
            }
            case '<': {
                return t < b;
            }
        }
        return false;
    }

    private boolean testString(ByteBuffer data) {
        log.debug((Object)"testString()");
        ByteBuffer test = this.match.getTest();
        char comparator = this.match.getComparator();
        byte[] b = data.array();
        byte[] t = test.array();
        boolean diff = false;
        int i = 0;
        for (i = 0; i < t.length; ++i) {
            log.debug((Object)("testing byte '" + b[i] + "' from '" + new String(data.array()) + "' against byte '" + t[i] + "' from '" + new String(test.array()) + "'"));
            if (t[i] == b[i]) continue;
            diff = true;
            break;
        }
        switch (comparator) {
            case '=': {
                return !diff;
            }
            case '!': {
                return diff;
            }
            case '>': {
                return t[i] > b[i];
            }
            case '<': {
                return t[i] < b[i];
            }
        }
        return false;
    }

    private boolean testShort(ByteBuffer data) {
        log.debug((Object)"testShort()");
        short val = 0;
        String test = new String(this.match.getTest().array());
        char comparator = this.match.getComparator();
        long bitmask = this.match.getBitmask();
        val = this.byteArrayToShort(data);
        val = (short)(val & (short)bitmask);
        short tst = 0;
        try {
            tst = Integer.decode(test).shortValue();
        }
        catch (NumberFormatException e) {
            log.error((Object)("testShort(): " + e));
            return false;
        }
        log.debug((Object)("testShort(): testing '" + Long.toHexString(val) + "' against '" + Long.toHexString(tst) + "'"));
        switch (comparator) {
            case '=': {
                return val == tst;
            }
            case '!': {
                return val != tst;
            }
            case '>': {
                return val > tst;
            }
            case '<': {
                return val < tst;
            }
        }
        return false;
    }

    private boolean testLong(ByteBuffer data) {
        log.debug((Object)"testLong()");
        long val = 0L;
        String test = new String(this.match.getTest().array());
        char comparator = this.match.getComparator();
        long bitmask = this.match.getBitmask();
        val = this.byteArrayToLong(data);
        long tst = Long.decode(test);
        log.debug((Object)("testLong(): testing '" + Long.toHexString(val &= bitmask) + "' against '" + test + "' => '" + Long.toHexString(tst) + "'"));
        switch (comparator) {
            case '=': {
                return val == tst;
            }
            case '!': {
                return val != tst;
            }
            case '>': {
                return val > tst;
            }
            case '<': {
                return val < tst;
            }
        }
        return false;
    }

    private boolean testRegex(String text) {
        log.debug((Object)"testRegex()");
        String test = new String(this.match.getTest().array());
        char comparator = this.match.getComparator();
        Perl5Util utility = new Perl5Util();
        log.debug((Object)("testRegex(): searching for '" + test + "'"));
        if (comparator == '=') {
            return utility.match(test, text);
        }
        if (comparator == '!') {
            return !utility.match(test, text);
        }
        return false;
    }

    private boolean testDetector(ByteBuffer data) {
        log.debug((Object)"testDetector()");
        String detectorClass = new String(this.match.getTest().array());
        try {
            log.debug((Object)("loading class: " + detectorClass));
            Class<?> c = Class.forName(detectorClass);
            MagicDetector detector = (MagicDetector)c.newInstance();
            String[] types = detector.process(data.array(), this.match.getOffset(), this.match.getLength(), this.match.getBitmask(), this.match.getComparator(), this.match.getMimeType(), this.match.getProperties());
            if (types != null && types.length > 0) {
                this.match.setMimeType(types[0]);
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("failed to load detector: " + detectorClass), (Throwable)e);
        }
        catch (InstantiationException e) {
            log.error((Object)("specified class is not a valid detector class: " + detectorClass), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)("specified class cannot be accessed: " + detectorClass), (Throwable)e);
        }
        return false;
    }

    public String[] getDetectorExtensions() {
        log.debug((Object)"testDetector()");
        String detectorClass = new String(this.match.getTest().array());
        try {
            log.debug((Object)("loading class: " + detectorClass));
            Class<?> c = Class.forName(detectorClass);
            MagicDetector detector = (MagicDetector)c.newInstance();
            return detector.getHandledTypes();
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("failed to load detector: " + detectorClass), (Throwable)e);
        }
        catch (InstantiationException e) {
            log.error((Object)("specified class is not a valid detector class: " + detectorClass), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)("specified class cannot be accessed: " + detectorClass), (Throwable)e);
        }
        return new String[0];
    }

    private String byteToOctalString(byte b) {
        int n1 = b / 32 & 7;
        int n2 = b / 8 & 7;
        int n3 = b & 7;
        return String.valueOf(n1) + String.valueOf(n2) + String.valueOf(n3);
    }

    private short byteArrayToShort(ByteBuffer data) {
        return data.getShort(0);
    }

    private long byteArrayToLong(ByteBuffer data) {
        return data.getInt(0);
    }

    protected Object clone() throws CloneNotSupportedException {
        MagicMatcher clone = new MagicMatcher();
        clone.setMatch((MagicMatch)this.match.clone());
        Iterator i = this.subMatchers.iterator();
        ArrayList<Object> sub = new ArrayList<Object>();
        while (i.hasNext()) {
            MagicMatcher m = (MagicMatcher)i.next();
            sub.add(m.clone());
        }
        clone.setSubMatchers(sub);
        return clone;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

