/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.client.jsf;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.connect.client.ui.SharedPackageListingsSettings;
import org.nuxeo.connect.client.vindoz.InstallAfterRestart;
import org.nuxeo.connect.client.we.StudioSnapshotHelper;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.data.DownloadingPackage;
import org.nuxeo.connect.packages.PackageManager;
import org.nuxeo.connect.update.LocalPackage;
import org.nuxeo.connect.update.PackageType;
import org.nuxeo.connect.update.PackageUpdateService;
import org.nuxeo.connect.update.task.Task;
import org.nuxeo.ecm.admin.setup.SetupWizardActionBean;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.ecm.webapp.seam.NuxeoSeamHotReloadContextKeeper;
import org.nuxeo.launcher.config.ConfigurationGenerator;
import org.nuxeo.runtime.api.Framework;

@Name(value="appsViews")
@Scope(value=ScopeType.CONVERSATION)
public class AppCenterViewsManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Log log = LogFactory.getLog(AppCenterViewsManager.class);
    protected static final Map<String, String> view2PackageListName = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("ConnectAppsUpdates", "updates");
            this.put("ConnectAppsStudio", "studio");
            this.put("ConnectAppsRemote", "remote");
            this.put("ConnectAppsLocal", "local");
        }
    };
    @In(create=true)
    protected String currentAdminSubViewId;
    @In(create=true)
    protected NuxeoSeamHotReloadContextKeeper seamReloadContext;
    @In(create=true)
    protected SetupWizardActionBean setupWizardAction;
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    @In(create=true)
    protected Map<String, String> messages;
    protected String searchString;
    protected SnapshotStatus studioSnapshotStatus;
    protected int studioSnapshotDownloadProgress;
    protected boolean isStudioSnapshopUpdateInProgress = false;
    protected Calendar lastStudioSnapshotUpdate;
    protected String studioSnapshotUpdateError;

    public String getSearchString() {
        if (this.searchString == null) {
            return "";
        }
        return this.searchString;
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
    }

    public boolean getOnlyRemote() {
        return SharedPackageListingsSettings.instance().get("remote").isOnlyRemote();
    }

    public void setOnlyRemote(boolean onlyRemote) {
        SharedPackageListingsSettings.instance().get("remote").setOnlyRemote(onlyRemote);
    }

    protected String getListName() {
        return view2PackageListName.get(this.currentAdminSubViewId);
    }

    public void setPlatformFilter(boolean doFilter) {
        SharedPackageListingsSettings.instance().get(this.getListName()).setPlatformFilter(doFilter);
    }

    public boolean getPlatformFilter() {
        return SharedPackageListingsSettings.instance().get(this.getListName()).getPlatformFilter();
    }

    public String getPackageTypeFilter() {
        return SharedPackageListingsSettings.instance().get(this.getListName()).getPackageTypeFilter();
    }

    public void setPackageTypeFilter(String filter) {
        SharedPackageListingsSettings.instance().get(this.getListName()).setPackageTypeFilter(filter);
    }

    public List<SelectItem> getPackageTypes() {
        ArrayList<SelectItem> types = new ArrayList<SelectItem>();
        SelectItem allItem = new SelectItem((Object)"", "label.packagetype.all");
        types.add(allItem);
        for (PackageType ptype : PackageType.values()) {
            SelectItem item = new SelectItem((Object)ptype.getValue(), "label.packagetype." + ptype.getValue());
            types.add(item);
        }
        return types;
    }

    public void flushCache() {
        PackageManager pm = (PackageManager)Framework.getLocalService(PackageManager.class);
        pm.flushCache();
    }

    public String installStudioSnapshotAndRedirect() throws Exception {
        this.installStudioSnapshot();
        return "view_admin";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installStudioSnapshot() throws Exception {
        if (this.isStudioSnapshopUpdateInProgress) {
            return;
        }
        PackageManager pm = (PackageManager)Framework.getLocalService(PackageManager.class);
        List pkgs = pm.listAllStudioRemotePackages();
        DownloadablePackage snapshotPkg = StudioSnapshotHelper.getSnapshot(pkgs);
        this.studioSnapshotUpdateError = null;
        if (snapshotPkg != null) {
            this.isStudioSnapshopUpdateInProgress = true;
            try {
                StudioAutoInstaller studioAutoInstaller = new StudioAutoInstaller(pm, snapshotPkg.getId());
                studioAutoInstaller.run();
            }
            finally {
                this.isStudioSnapshopUpdateInProgress = false;
            }
        } else {
            this.studioSnapshotUpdateError = AppCenterViewsManager.translate("label.studio.error.noSnapshotPackageFound", new Object[0]);
        }
    }

    public boolean isStudioSnapshopUpdateInProgress() {
        return this.isStudioSnapshopUpdateInProgress;
    }

    protected static String translate(String label, Object ... params) {
        return ComponentUtils.translate((FacesContext)FacesContext.getCurrentInstance(), (String)label, (Object[])params);
    }

    protected String getLastUpdateDate() {
        SimpleDateFormat df = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        return df.format(this.lastStudioSnapshotUpdate.getTime());
    }

    public String getStudioInstallationStatus() {
        String prefix = "label.studio.update.status.";
        if (this.studioSnapshotStatus == null) {
            return AppCenterViewsManager.translate(prefix + "noStatus", new Object[0]);
        }
        Object[] params = new Object[]{};
        if (SnapshotStatus.error.equals((Object)this.studioSnapshotStatus)) {
            if (this.studioSnapshotUpdateError == null) {
                this.studioSnapshotUpdateError = "???";
            }
            params = new Object[]{this.studioSnapshotUpdateError};
        } else if (SnapshotStatus.downloading.equals((Object)this.studioSnapshotStatus)) {
            params = new Object[]{String.valueOf(this.studioSnapshotDownloadProgress)};
        } else if (SnapshotStatus.completed.equals((Object)this.studioSnapshotStatus) || SnapshotStatus.restartNeeded.equals((Object)this.studioSnapshotStatus)) {
            params = new Object[]{this.getLastUpdateDate()};
        }
        return AppCenterViewsManager.translate(prefix + this.studioSnapshotStatus.name(), params);
    }

    protected void setStatus(SnapshotStatus status, String errorMessage) {
        this.studioSnapshotStatus = status;
        this.studioSnapshotUpdateError = errorMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDevMode(boolean value) {
        String feedbackCompId = "changeDevModeForm";
        ConfigurationGenerator conf = this.setupWizardAction.getConfigurationGenerator();
        boolean configurable = conf.isConfigurable();
        if (!configurable) {
            this.facesMessages.addToControl(feedbackCompId, StatusMessage.Severity.ERROR, AppCenterViewsManager.translate("label.setup.nuxeo.org.nuxeo.dev.changingDevModeNotConfigurable", new Object[0]), new Object[0]);
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("org.nuxeo.dev", Boolean.toString(value));
        try {
            conf.saveFilteredConfiguration(params);
            Properties props = conf.getUserConfig();
            conf.getServerConfigurator().dumpProperties(props);
            Framework.getRuntime().reloadProperties();
            if (value) {
                this.facesMessages.addToControl(feedbackCompId, StatusMessage.Severity.WARN, AppCenterViewsManager.translate("label.admin.center.devMode.justActivated", new Object[0]), new Object[0]);
            } else {
                this.facesMessages.addToControl(feedbackCompId, StatusMessage.Severity.INFO, AppCenterViewsManager.translate("label.admin.center.devMode.justDisabled", new Object[0]), new Object[0]);
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            this.facesMessages.addToControl(feedbackCompId, StatusMessage.Severity.ERROR, AppCenterViewsManager.translate("label.admin.center.devMode.errorSaving", e.getMessage()), new Object[0]);
        }
        finally {
            this.setupWizardAction.setNeedsRestart(true);
            this.setupWizardAction.resetParameters();
        }
    }

    protected class StudioAutoInstaller
    implements Runnable {
        protected final String packageId;
        protected final PackageManager pm;

        protected StudioAutoInstaller(PackageManager pm, String packageId) {
            this.pm = pm;
            this.packageId = packageId;
        }

        @Override
        public void run() {
            try {
                AppCenterViewsManager.this.setStatus(SnapshotStatus.downloading, null);
                DownloadingPackage pkg = this.pm.download(this.packageId);
                while (!pkg.isCompleted()) {
                    try {
                        AppCenterViewsManager.this.studioSnapshotDownloadProgress = pkg.getDownloadProgress();
                        Thread.sleep(100L);
                        log.debug((Object)"downloading studio snapshot package");
                    }
                    catch (InterruptedException e) {}
                }
                log.debug((Object)"studio snapshot package download completed, starting installation");
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                PackageUpdateService pus = (PackageUpdateService)Framework.getLocalService(PackageUpdateService.class);
                AppCenterViewsManager.this.setStatus(SnapshotStatus.saving, null);
                try {
                    while (pus.getPackage(pkg.getId()) == null) {
                        try {
                            AppCenterViewsManager.this.studioSnapshotDownloadProgress = pkg.getDownloadProgress();
                            Thread.sleep(50L);
                            log.debug((Object)"downloading studio snapshot package");
                        }
                        catch (InterruptedException e) {}
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Error while sending studio snapshot to update manager", (Throwable)e);
                    AppCenterViewsManager.this.setStatus(SnapshotStatus.error, AppCenterViewsManager.translate("label.studio.update.downloading.error", e.getMessage()));
                    return;
                }
                if (Framework.isDevModeSet()) {
                    AppCenterViewsManager.this.setStatus(SnapshotStatus.installing, null);
                    try {
                        LocalPackage lpkg = pus.getPackage(pkg.getId());
                        Task installTask = lpkg.getInstallTask();
                        installTask.run(new HashMap());
                        AppCenterViewsManager.this.lastStudioSnapshotUpdate = Calendar.getInstance();
                        AppCenterViewsManager.this.setStatus(SnapshotStatus.completed, null);
                    }
                    catch (Exception e) {
                        log.error((Object)"Error while installing studio snapshot", (Throwable)e);
                        AppCenterViewsManager.this.setStatus(SnapshotStatus.error, AppCenterViewsManager.translate("label.studio.update.installation.error", e.getMessage()));
                    }
                } else {
                    InstallAfterRestart.addPackageForInstallation(pkg.getId());
                    AppCenterViewsManager.this.lastStudioSnapshotUpdate = Calendar.getInstance();
                    AppCenterViewsManager.this.setStatus(SnapshotStatus.restartNeeded, null);
                    AppCenterViewsManager.this.setupWizardAction.setNeedsRestart(true);
                }
            }
            catch (Exception e) {
                AppCenterViewsManager.this.setStatus(SnapshotStatus.error, e.getMessage());
            }
        }
    }

    protected static enum SnapshotStatus {
        downloading,
        saving,
        installing,
        error,
        completed,
        restartNeeded;

    }
}

