/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.core.im;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandAvailability;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandLineExecutorService;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandNotAvailable;
import org.nuxeo.ecm.platform.picture.api.BlobHelper;
import org.nuxeo.ecm.platform.picture.core.ImageUtils;
import org.nuxeo.ecm.platform.picture.magick.utils.ImageCropper;
import org.nuxeo.ecm.platform.picture.magick.utils.ImageIdentifier;
import org.nuxeo.ecm.platform.picture.magick.utils.ImageResizer;
import org.nuxeo.ecm.platform.picture.magick.utils.ImageRotater;
import org.nuxeo.ecm.platform.ui.web.util.files.FileUtils;
import org.nuxeo.runtime.api.Framework;

public class IMImageUtils
implements ImageUtils {
    private static final Log log = LogFactory.getLog(IMImageUtils.class);

    @Override
    public Blob crop(Blob blob, final int x, final int y, final int width, final int height) {
        return new ImageMagickCaller(){

            @Override
            public void callImageMagick() throws CommandNotAvailable {
                ImageCropper.crop(this.sourceFile.getAbsolutePath(), this.targetFile.getAbsolutePath(), width, height, x, y);
            }
        }.call(blob, null, "resizer");
    }

    @Override
    public Blob resize(Blob blob, String finalFormat, final int width, final int height, final int depth) {
        return new ImageMagickCaller(){

            @Override
            public void callImageMagick() throws CommandNotAvailable {
                ImageResizer.resize(this.sourceFile.getAbsolutePath(), this.targetFile.getAbsolutePath(), width, height, depth);
            }
        }.call(blob, finalFormat, "resizer");
    }

    @Override
    public Blob rotate(Blob blob, final int angle) {
        return new ImageMagickCaller(){

            @Override
            public void callImageMagick() throws CommandNotAvailable {
                ImageRotater.rotate(this.sourceFile.getAbsolutePath(), this.targetFile.getAbsolutePath(), angle);
            }
        }.call(blob, null, "rotate");
    }

    @Override
    public boolean isAvailable() {
        CommandLineExecutorService cles = (CommandLineExecutorService)Framework.getLocalService(CommandLineExecutorService.class);
        CommandAvailability commandAvailability = cles.getCommandAvailability("identify");
        return commandAvailability.isAvailable();
    }

    public static abstract class ImageMagickCaller {
        protected File sourceFile;
        protected File tmpFile;
        protected File targetFile;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Blob call(Blob blob, String targetExt, String commandName) {
            CommandLineExecutorService cles = (CommandLineExecutorService)Framework.getLocalService(CommandLineExecutorService.class);
            CommandAvailability availability = cles.getCommandAvailability(commandName);
            if (!availability.isAvailable()) {
                return null;
            }
            try {
                this.makeFiles(blob, targetExt);
                this.callImageMagick();
                Blob targetBlob = FileUtils.createTemporaryFileBlob((File)this.targetFile, null, null);
                Framework.trackFile((File)this.targetFile, (Object)targetBlob);
                Blob blob2 = targetBlob;
                return blob2;
            }
            catch (IOException e) {
                log.error((Object)("ImageMagick failed on command: " + commandName), (Throwable)e);
                Blob blob3 = null;
                return blob3;
            }
            catch (CommandNotAvailable e) {
                log.error((Object)("ImageMagick failed on command: " + commandName), (Throwable)e);
                Blob blob4 = null;
                return blob4;
            }
            finally {
                this.cleanFiles();
            }
        }

        protected void makeFiles(Blob blob, String targetExt) throws IOException {
            this.sourceFile = BlobHelper.getFileFromBlob((Blob)blob);
            if (this.sourceFile == null) {
                this.tmpFile = File.createTempFile("nuxeoImageSource", ".tmp");
                blob.transferTo(this.tmpFile);
                this.sourceFile = this.tmpFile;
            }
            if (targetExt == null && (targetExt = FilenameUtils.getExtension((String)blob.getFilename())) == null) {
                try {
                    targetExt = ImageIdentifier.getInfo(this.sourceFile.getPath()).getFormat();
                }
                catch (CommandNotAvailable e) {
                    log.warn((Object)e.getMessage());
                }
            }
            this.targetFile = File.createTempFile("nuxeoImageTarget", "." + targetExt);
        }

        protected void cleanFiles() {
            if (this.tmpFile != null) {
                this.tmpFile.delete();
            }
        }

        public abstract void callImageMagick() throws CommandNotAvailable;
    }
}

