/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.dm.operation;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.platform.routing.dm.api.RoutingTaskConstants;
import org.nuxeo.ecm.platform.routing.dm.operation.AbstractTaskStepOperation;

@Operation(id="Document.Routing.EvaluateCondition", category="Routing", label="Set Task Done", description="Set the task as done.")
public class EvaluateCondition
extends AbstractTaskStepOperation {
    public static final String ID = "Document.Routing.EvaluateCondition";
    private Log log = LogFactory.getLog(EvaluateCondition.class);
    @Context
    protected OperationContext context;
    @Param(name="subject")
    protected String subject;
    @Param(name="operator")
    protected String operator;
    @Param(name="value")
    protected String value;

    @OperationMethod
    public void evaluateCondition(DocumentModel doc) throws ClientException {
        int result = 0;
        Object subjectValue = this.getPropertyValue(doc, this.subject);
        if (subjectValue instanceof Long) {
            Long longValue;
            try {
                longValue = Long.parseLong(this.value);
            }
            catch (NumberFormatException e) {
                this.log.error((Object)"Invalid long value");
                throw new ClientException((Throwable)e);
            }
            result = ((Long)subjectValue).compareTo(longValue);
        }
        if (subjectValue instanceof String) {
            result = ((String)subjectValue).compareTo(this.value);
        }
        if (result == 0 && RoutingTaskConstants.EvaluationOperators.equal.name().equals(this.operator) || result != 0 && RoutingTaskConstants.EvaluationOperators.not_equal.name().equals(this.operator) || result < 0 && RoutingTaskConstants.EvaluationOperators.less_than.name().equals(this.operator) || result > 0 && RoutingTaskConstants.EvaluationOperators.greater_than.name().equals(this.operator) || result <= 0 && RoutingTaskConstants.EvaluationOperators.less_or_equal_than.name().equals(this.operator) || result >= 0 && RoutingTaskConstants.EvaluationOperators.greater_or_equal_than.name().equals(this.operator)) {
            this.context.put("nextStepPos", (Object)"1");
        } else {
            this.context.put("nextStepPos", (Object)"2");
        }
    }

    protected <T> T getPropertyValue(DocumentModel doc, String propertyName) {
        try {
            return (T)doc.getPropertyValue(propertyName);
        }
        catch (PropertyException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }
}

