/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.workspace;

import java.io.Serializable;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.platform.content.template.service.PostContentCreationHandler;
import org.nuxeo.ecm.social.workspace.service.SocialWorkspaceContainerDescriptor;
import org.nuxeo.ecm.social.workspace.service.SocialWorkspaceService;
import org.nuxeo.runtime.api.Framework;

public class CollaborationHandler
implements PostContentCreationHandler {
    public static final String DC_TITLE = "dc:title";
    public static final String DC_DESCRIPTION = "dc:description";

    public void execute(CoreSession session) {
        try {
            SocialWorkspaceService socialWorkspaceService = (SocialWorkspaceService)Framework.getLocalService(SocialWorkspaceService.class);
            SocialWorkspaceContainerDescriptor socialWorkspaceContainer = socialWorkspaceService.getSocialWorkspaceContainerDescriptor();
            PathRef docRef = new PathRef(socialWorkspaceContainer.getPath());
            if (!session.exists((DocumentRef)docRef)) {
                Path path = new Path(socialWorkspaceContainer.getPath());
                String parentPath = path.removeLastSegments(1).toString();
                String name = path.lastSegment();
                DocumentModel container = session.createDocumentModel(parentPath, name, "SocialDomain");
                container.setPropertyValue(DC_TITLE, (Serializable)((Object)socialWorkspaceContainer.getTitle()));
                container.setPropertyValue(DC_DESCRIPTION, (Serializable)((Object)socialWorkspaceContainer.getDescription()));
                session.createDocument(container);
            }
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }
}

